%define major 1.12

Name: tomboy
Version: %major.1
Release: alt1

Summary: Tomboy is a desktop note-taking application

Group: Office
License: LGPLv2.1
Url: http://www.gnome.org/projects/tomboy

Packager: GNOME Maintainers Team <gnome at packages.altlinux.org>

Source: http://ftp.gnome.org/pub/GNOME/sources/%name/%major/%name-%version.tar
Patch: %name-%version-%release.patch

#add_findprov_lib_path %_libdir/%name

# Typical environment for GNOME program
Requires(post): GConf
Requires(post,postun): librarian
BuildPreReq: libGConf-devel
BuildPreReq: desktop-file-utils

BuildRequires: gcc-c++ intltool >= 0.35.0
BuildRequires: pkgconfig(dbus-sharp-1.0) >= 0.4 pkgconfig(dbus-sharp-glib-1.0) >= 0.3
BuildRequires: pkgconfig(gdk-2.0) >= 2.6.0
BuildRequires: pkgconfig(gtk+-2.0) >= 2.14.0
BuildRequires: pkgconfig(atk) >= 1.2.4
BuildRequires: pkgconfig(gtkspell-2.0) >= 2.0.9
BuildRequires: pkgconfig(mono-addins) >= 0.3 pkgconfig(mono-addins-gui) >= 0.3 pkgconfig(mono-addins-setup) >= 0.3
BuildRequires: pkgconfig(gconf-sharp-2.0)
BuildRequires: pkgconfig(gtk-sharp-2.0) >= 2.10.1
BuildRequires: libX11-devel

BuildPreReq: gnome-doc-utils gnome-common
BuildRequires: /proc rpm-build-mono mono-mcs mono-devel >= 1.9.1

%description
Tomboy is a desktop note-taking application for Linux and Unix. Simple
and easy to use, but with potential to help you organize the ideas and
information you deal with every day.  The key to Tomboy's usefulness lies
in the ability to relate notes and ideas together.  Using a WikiWiki-like
linking system, organizing ideas is as simple as typing a name.
Branching an idea off is easy as pressing the Link button. And links
between your ideas won't break, even when renaming and reorganizing them.

%prep
%setup -q
%patch -p1

%build
NOCONFIGURE=1 ./autogen.sh
%configure --disable-schemas-install --disable-scrollkeeper --disable-update-mimedb \
	--enable-panel-applet=no

%make

%install
%make_install install DESTDIR=%buildroot
desktop-file-install --dir %buildroot%_desktopdir \
	--add-category=TextTools \
	%buildroot%_desktopdir/tomboy.desktop

%find_lang %name --with-gnome

%post
%gconf2_install %name

%preun
if [ $1 = 0 ]; then
%gconf2_uninstall %name
fi

%files -f %name.lang
%doc AUTHORS MAINTAINERS README NEWS COPYING COPYING-DOCS
%_bindir/%name
%dir %_libdir/%name/
%_libdir/%name/addins/
%_libdir/%name/Tomboy.exe
%_libdir/%name/Tomboy.exe.*
%_libdir/%name/libtomboy.so
%_man1dir/*
%_desktopdir/*
%_datadir/%name/
%_iconsdir/*/*/apps/tomboy.png
%_iconsdir/*/*/apps/tomboy.svg
%config %_sysconfdir/gconf/schemas/*
%_datadir/dbus-1/services/*
%_datadir/mime/packages/*
%_datadir/icons/hicolor/*/mimetypes/application-x-note.png

%exclude %_pkgconfigdir/*
%exclude %_libdir/%name/*.la

%changelog
