# hey Emacs, its -*- mode: rpm-spec; coding: cp1251; -*-

## Things users may want to change
#
# User (and group) name under which the Tor daemon runs
%define toruser _tor

# Root directory for chrooted environment, must not be
# same as real system root.
%define _tor_root %_localstatedir/%name

Name: tor
Version: 0.2.5.10
Release: alt0.M70P.1

Summary: Anonymizing overlay network for TCP (The onion router)
Group: System/Servers
License: BSD-like
Url: http://tor.eff.org/
Packager: Sviatoslav Sviridov <svd@altlinux.ru>

Source0: http://tor.eff.org/dist/%name-%version.tar
Source1: %name.init
Source2: %name.systemd.service

# Automatically added by buildreq on Fri Jun 24 2011
# optimized out: fontconfig fonts-type1-urw ghostscript-classic libcom_err-devel libkrb5-devel tex-common texlive-base texlive-base-bin texlive-common texlive-latex-base texlive-latex-recommended
BuildRequires: ghostscript-common libevent-devel libssl-devel texlive-fonts-recommended texlive-generic-recommended transfig zlib-devel

%description
Tor is a connection-based low-latency anonymous communication system.
This package provides the "tor" program, which serves as both a client
and a relay node.

Applications connect to the local Tor proxy using the SOCKS
protocol. The local proxy chooses a path through a set of relays, in
which each relay knows its predecessor and successor, but no
others. Traffic flowing down the circuit is unwrapped by a symmetric
key at each relay, which reveals the downstream relay.

Warnings: Tor does no protocol cleaning.  That means there is a danger
that application protocols and associated programs can be induced to
reveal information about the initiator. Tor depends on Privoxy and
similar protocol cleaners to solve this problem. This is alpha code,
and is even more likely than released code to have anonymity-spoiling
bugs. The present network is very small -- this further reduces the
strength of the anonymity provided. Tor is not presently suitable
for high-stakes anonymity.

%prep
%setup

# Set default configuration values
sed -i 's:^#Log notice file.*:Log notice file %_var/log/%name/%name.log:' src/config/torrc.sample.in
sed -i 's:^#DataDirectory.*:DataDirectory %_var/cache/%name:' src/config/torrc.sample.in

%build
%configure --with-tor-user=%{toruser} --with-tor-group=%{toruser}
%make_build

# Perform unit test
%make check

%install
%makeinstall_std

install -pD -m755 %SOURCE1 %buildroot/%_initdir/%name
mv %buildroot/%_sysconfdir/%name/torrc.sample %buildroot/%_sysconfdir/%name/torrc
mkdir -p %buildroot%_tor_root
mkdir -p %buildroot%_var/{cache/%name,log/%name,run/%name}

install -D -p -m 0644 %SOURCE2 %buildroot/%_unitdir/%{name}.service

mkdir -p %buildroot%_sysconfdir/logrotate.d
cat >%buildroot%_sysconfdir/logrotate.d/%name <<__EOF__
%_var/log/%name/*log {
	weekly
	rotate 5
	compress
	missingok
	notifempty
	sharedscripts
	postrotate
		%_initdir/%name condreload >/dev/null
	endscript
}
__EOF__

# Chroot config
#mkdir -p %buildroot%_tor_root{/lib,%_var/{nis,yp/binding,log},%_sysconfdir/%name}

%pre
/usr/sbin/groupadd -r -f %toruser
/usr/sbin/useradd -r -g %toruser -d %_tor_root -s /dev/null -c 'Tor user' %toruser >/dev/null 2>&1 ||:
if [ $1 -gt 1 ]; then
	chown %toruser:auth /etc/tcb/%toruser
	/usr/sbin/usermod -d %_tor_root %toruser
fi

%post
#%_sysconfdir/chroot.d/%name.all force
%post_service %name

%preun
%preun_service %name

#if [ $1 = 0 ]; then
#	rm -f %_tor_root/lib/* %_tor_root/var/yp/binding/*
#fi

%define docdir %_docdir/%name

%files
%dir %_sysconfdir/%name
%config(noreplace) %_sysconfdir/%name/torrc
%config %_sysconfdir/logrotate.d/%name
%{_unitdir}/%{name}.service
%_bindir/tor
# torify is moved to torsocks package to avoid automatic dependency on it
%exclude %_bindir/torify
%_bindir/tor-resolve
%_bindir/tor-gencert
%_man1dir/*.1.*
%_initdir/%name
%dir %_datadir/%name
%_datadir/%name/geoip
%_datadir/%name/geoip6
%doc README LICENSE ChangeLog INSTALL doc/HACKING
%dir %docdir
%docdir/*.html


%defattr(640,root,%toruser,2710)
%_tor_root
%defattr(640,root,%toruser,2770)
%_var/log/%name
%defattr(640,root,%toruser,2730)
%_var/run/%name
%defattr(640,%toruser,%toruser,2700)
%_var/cache/%name

%changelog
