%define ver_major 3.8
%define parser_ver 3.4.4
%define gst_api_ver 1.0
%define gst_ver 0.11.99
%define gst_plugins_ver 0.11.93
%define gtk_ver 3.5.2
%define grilo_ver 0.2.0
%define glib_ver 2.35.0

%define _libexecdir %_prefix/libexec
%define nautilus_extdir %_libdir/nautilus/extensions-3.0

%def_disable static
%def_enable vala
%if_enabled vala
%def_enable rotation
%def_enable zeitgeist
%endif
%def_enable introspection
%def_enable nautilus
%def_enable grilo
%def_enable lirc
%def_disable tracker
%def_enable python
%def_enable browser_plugins
%def_disable coherence_upnp
%def_disable jamendo

%if_enabled browser_plugins
%def_enable gmp_plugin
%def_enable narrowspace_plugin
%def_enable mully_plugin
%def_enable cone_plugin
%endif

Name: totem
Version: %ver_major.2
Release: alt2.M70P.1

Summary: Movie player for GNOME 3
Group: Video
License: GPL%def_disable static
URL: http://www.gnome.org/projects/totem
Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

Obsoletes: %name-gstreamer < %version %name-backend-gstreamer < %version %name-backend-xine < %version
Obsoletes: %name-plugins-mythtv  %name-plugins-galago
Obsoletes: %name-plugins-bemused  %name-plugins-youtube
Obsoletes: %name-plugins-publish  %name-plugins-iplayer
Provides: %name-backend = %version %name-backend-gstreamer = %version %name-backend-xine = %version

Requires: lib%name = %version-%release
Requires: dconf gnome-icon-theme
Requires: gstreamer%gst_api_ver >= %gst_ver
Requires: gst-plugins-base%gst_api_ver
Requires: gst-plugins-good%gst_api_ver
Requires: gst-plugins-bad%gst_api_ver
Requires: gst-plugins-ugly%gst_api_ver
Requires: gst-libav
Requires: iso-codes

#Source: %name-%version.tar
Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz
Source1: totem-bin-backend-ondemand.sh

BuildPreReq: rpm-build-gnome gnome-common gtk-doc
BuildPreReq: intltool >= 0.40.0
%{?_enable_nvtv:BuildRequires: libnvtv-devel >= 0.4.5}

BuildRequires: gstreamer%gst_api_ver-devel >= %gst_ver
BuildRequires: gst-plugins%gst_api_ver-devel >= %gst_plugins_ver
BuildRequires: gstreamer%gst_api_ver-utils >= %gst_ver
BuildRequires: gst-plugins-base%gst_api_ver
BuildRequires: gst-plugins-good%gst_api_ver
BuildRequires: gst-plugins-bad%gst_api_ver-devel
BuildRequires: browser-plugins-npapi-devel

BuildPreReq: iso-codes-devel gnome-icon-theme
BuildPreReq: glib2-devel >= %glib_ver libgtk+3-devel >= %gtk_ver libgio-devel libpeas-devel >= 0.7.3
BuildPreReq: libtotem-pl-parser-devel >= %parser_ver
BuildPreReq: libXtst-devel libXrandr-devel libXxf86vm-devel xorg-xproto-devel

%{?_enable_python:BuildRequires: python-devel python-module-pygobject3-devel pylint}
%{?_enable_vala:BuildRequires: libvala-devel >= 0.14 vala-tools}
BuildRequires: libdbus-devel libdbus-glib-devel libgdata-devel gsettings-desktop-schemas-devel
%{?_enable_lirc:BuildRequires: liblirc-devel}
%{?_enable_tracker:BuildRequires: tracker-devel}
%{?_enable_nautilus:BuildRequires: libnautilus-devel}
%{?_enable_grilo:BuildRequires: libgrilo-devel}
%{?_enable_zeitgeist:BuildRequires: libzeitgeist-devel}
%{?_enable_introspection:BuildRequires: libtotem-pl-parser-gir-devel libgtk+3-gir-devel}

BuildRequires: desktop-file-utils libSM-devel
BuildRequires: db2latex-xsl yelp-tools gcc-c++
BuildRequires: libX11-devel libXext-devel libXi-devel
BuildRequires: libclutter-gst2.0-devel >= 1.3.9 libclutter-gtk3-devel

%description
Totem is simple movie player for the Gnome desktop.
It features a simple playlist, a full-screen mode, seek and volume
controls, as well as a pretty complete keyboard navigation.

%package -n lib%name
Summary: Totem Library
License: LGPLv2+
Group: System/Libraries

%description -n lib%name
This package provides shared library for Totem movie player.

%package -n lib%name-devel
Summary: Development files for Totem Library
License: LGPLv2+
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
This package provides files required to develop programs that use
Totem library.

%package -n lib%name-gir
Summary: GObject introspection data for the Totem library
Group: System/Libraries
Requires: lib%name = %version-%release

%description -n lib%name-gir
GObject introspection data for the Totem library

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the Totem library
Group: System/Libraries
BuildArch: noarch
Requires: lib%name-gir = %version-%release
Requires: lib%name-devel = %version-%release

%description -n lib%name-gir-devel
GObject introspection devel data for the Totem library

%package -n mozilla-plugin-%name
Summary: Mozilla plugin for the Totem media player
Group: Networking/WWW
Requires: %name = %version-%release
Requires: browser-plugins-npapi
Provides: mozilla-plugin-%name-xine
Obsoletes: mozilla-plugin-%name-xine < %version-%release
Provides: mozilla-plugin-%name-gstreamer
Obsoletes: mozilla-plugin-%name-gstreamer < %version-%release

%description -n mozilla-plugin-%name
A Mozilla plug-in for that enables media playback from within webpages
via the Totem media player.

%package plugins
Summary: default plugins for Totem
Group: Video
Requires: %name = %version-%release

%description plugins
A default plugins for Totem:
	gromit
	ontop
	screensaver
	skipto
	properties
	media-player-keys
	pythonconsole
	opensubtitles
	chapters

%package plugins-grilo
Summary: Grilo browser for Totem
Group: Video
Requires: %name = %version-%release

%description plugins-grilo
A plugin to let you browse media content from various sources using
Grilo.

%package plugins-lirc
Summary: LIRC (Infrared remote) plugin for Totem
Group: Video
Requires: %name = %version-%release

%description plugins-lirc
A plugin to add LIRC (Infrared remote) support to Totem.

%package plugins-rotation
Summary: Rotation plugin for Totem
Group: Video
Requires: %name = %version-%release

%description plugins-rotation
A plugin to allow videos to be rotated if they're in the wrong orientation.

%package plugins-zeitgeist
Summary: Zeitgeist plugin for Totem
Group: Video
Requires: %name = %version-%release

%description plugins-zeitgeist
A plugin sending events to Zeitgeist

%package plugins-tracker
Summary: Tracker-based video search plugin for Totem
Group: Video
Requires: %name = %version-%release

%description plugins-tracker
A plugin to allow searching local videos, based on their tags, metadata,
or filenames, as indexing by the Tracker indexer.

%package plugins-jamendo
Summary: Plugin for jamendo.com music collection
Group: Video
Requires: %name = %version-%release
%py_requires json

%description plugins-jamendo
A plugin to allow you to listen to the large collection of Creative
Commons licensed music on Jamendo

%package plugins-coherence_upnp
Summary: Coherence DLNA/UPnP totem plugin
Group: Video
Requires: %name = %version-%release
Requires: python-module-coherence coherence

%description plugins-coherence_upnp
This package contains a DLNA/UPnP client for Totem powered by Coherence

%package plugins-gromit
Summary: Gromit Annotations plugin for totem
Group: Video
Requires: %name = %version-%release
Requires: gromit

%description plugins-gromit
This package contains presentation helper to make annotations on screen via Gromit

%package plugins-brasero
Summary: Video disc recorder plugin for Totem
Group: Video
Requires: %name = %version-%release
Requires: brasero

%description plugins-brasero
This package contains plugin that allow record (S)VCDs or video DVDs
with Brasero

%package devel-doc
Summary: Development documentation for Totem
Group: Development/GNOME and GTK+
BuildArch: noarch
Conflicts: %name < %version

%description devel-doc
This package provides Totem reference manual

%package nautilus
Summary: Nautilus extension for the Totem media player
Group: Video
Requires: %name-video-thumbnailer = %version-%release
Provides: totem-gstreamer-nautilus = %version-%release
Provides: totem-xine-nautilus = %version-%release
Provides: totem-nautilus = %version
Provides: nautilus-totem-gstreamer = %version-%release
Provides: nautilus-totem-xine = %version-%release
Provides: nautilus-totem = %version-%release
Obsoletes: totem-gstreamer-nautilus < %version-%release
Obsoletes: totem-xine-nautilus < %version-%release
Obsoletes: totem-nautilus < %version-%release

%description nautilus
This package provides integration with the Totem media player for
the Nautilus file manager.

%package video-thumbnailer
Summary: Totem video thumbnailer
Group: Video
Requires: gst-plugins-base%gst_api_ver
Requires: gst-plugins-good%gst_api_ver
Requires: gst-plugins-bad%gst_api_ver
Requires: gst-plugins-ugly%gst_api_ver
Requires: gst-libav
Requires: iso-codes

%description video-thumbnailer
This package provides a video thumbnailer from Totem package that can be
used by other applications like filemanagers.

%prep
%setup -n %name-%version

[ ! -d m4 ] && mkdir m4

%build
export BROWSER_PLUGIN_DIR=%browser_plugins_path
%autoreconf
%configure \
	%{subst_enable static} \
	--disable-schemas-compile \
	%{subst_enable python} \
	%{subst_enable vala} \
%if_enabled browser_plugins
	--enable-browser-plugins \
	%{?_enable_gmp_plugin:--enable-gmp-plugin} \
	%{?_enable_narrowspace_plugin:--enable-narrowspace-plugin} \
	%{?_enable_mully_plugin:--enable-mully-plugin} \
	%{?_enable_cone_plugin:--enable-cone-plugin} \
%endif
	%{?_enable_nautilus:--enable-nautilus=yes} \
	--disable-static

%make_build

%install
%make DESTDIR=%buildroot install
find %buildroot%_libdir -name \*.la -delete

%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/*
%exclude %_bindir/%name-video-thumbnailer
%dir %_libdir/%name
# depends on pygtk
#%_libexecdir/%name/totem-bugreport.py
%_datadir/applications/%name.desktop
%_datadir/icons/hicolor/*/*/*.png
%_datadir/icons/hicolor/*/*/*.svg
%_datadir/%name
%_man1dir/*
%exclude %_man1dir/%name-video-thumbnailer.1.*
%config %_datadir/glib-2.0/schemas/org.gnome.totem.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.totem.enums.xml
%_datadir/GConf/gsettings/totem.convert
%doc AUTHORS NEWS README TODO

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_libdir/pkgconfig/*.pc

%if_enabled introspection
%files -n lib%name-gir
%_libdir/girepository-1.0/*.typelib

%files -n lib%name-gir-devel
%_datadir/gir-1.0/*.gir
%endif

%files plugins
%dir %_libdir/%name/plugins
%_libdir/%name/plugins/dbus/
%_libdir/%name/plugins/ontop/
%_libdir/%name/plugins/screensaver/
%_libdir/%name/plugins/skipto/
%_libdir/%name/plugins/properties/
%_libdir/%name/plugins/media-player-keys/
%_libdir/%name/plugins/pythonconsole/
%_libdir/%name/plugins/opensubtitles/
%_libdir/%name/plugins/screenshot/
%_libdir/%name/plugins/chapters/
%_libdir/%name/plugins/save-file/
%_libdir/%name/plugins/im-status/
%_libdir/%name/plugins/apple-trailers/
%_libdir/%name/plugins/autoload-subtitles/
%_libdir/%name/plugins/recent/
%config %_datadir/glib-2.0/schemas/org.gnome.totem.plugins.opensubtitles.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.totem.plugins.pythonconsole.gschema.xml
%_datadir/GConf/gsettings/opensubtitles.convert
%_datadir/GConf/gsettings/pythonconsole.convert

%if_enabled grilo
%files plugins-grilo
%_libdir/%name/plugins/grilo/
%endif

%if_enabled lirc
%files plugins-lirc
%_libdir/%name/plugins/lirc/
%endif

%if_enabled rotation
%files plugins-rotation
%_libdir/%name/plugins/rotation/
%endif

%if_enabled zeitgeist
%files plugins-zeitgeist
%_libdir/%name/plugins/zeitgeist-dp/
%endif

%if_enabled tracker
%files plugins-tracker
%_libdir/%name/plugins/tracker/
%endif

%if_enabled browser_plugins
%files -n mozilla-plugin-%name
%_libexecdir/totem-plugin-viewer
%browser_plugins_path/*
%endif

%if_enabled jamendo
%files plugins-jamendo
%_libdir/%name/plugins/jamendo/
%_datadir/glib-2.0/schemas/org.gnome.totem.plugins.jamendo.gschema.xml
%_datadir/GConf/gsettings/jamendo.convert
%endif

%files plugins-gromit
%_libdir/%name/plugins/gromit/

%files nautilus
%nautilus_extdir/*

%if_enabled coherence_upnp
%files plugins-coherence_upnp
%_libdir/%name/plugins/coherence_upnp/
%endif

%files plugins-brasero
%_libdir/%name/plugins/brasero-disc-recorder/

%files devel-doc
%_datadir/gtk-doc/html/*

%files video-thumbnailer
%_bindir/%name-video-thumbnailer
%_man1dir/%name-video-thumbnailer.1.*
%_datadir/thumbnailers/%name.thumbnailer


%changelog
