%define ver_major 0.16
%define ver_api 0.16

%add_verify_elf_skiplist %_bindir/tracker-needle

%def_enable introspection
%def_disable hal
%def_enable upower
%def_enable libxml2
%def_enable gdkpixbuf
%def_enable libsecret
%def_enable network_manager
%def_disable evolution
%def_disable rss
%def_enable preferences
%def_enable poppler
%def_enable libgxps
%def_enable libexif
%def_enable libiptcdata
%def_enable libgsf
%def_enable libjpeg
%def_enable libtiff
%def_enable libvorbis
%def_enable libflac
%def_enable exempi
%def_enable nautilus_extension
%def_disable gtk_doc
%def_enable taglib
%def_enable needle
%def_disable qt
%def_enable libgif
%def_enable libcue
%def_enable libosinfo

# Unicode support library? (libunistring|libicu)
%define unicode_support libicu

%define _libexecdir %_prefix/libexec

Name: tracker
Version: %ver_major.1
Release: alt4

Summary: Tracker is a powerfull desktop-oriented search tool and indexer
License: GPLv2+
Group: Office
Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>
Url: http://projects.gnome.org/tracker/

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar
Patch: %name-%version-%release.patch

Obsoletes: lib%name-client
Requires: lib%name = %version-%release

%define dbus_ver 1.3.1
%define glib_ver 2.35.1
%define pango_ver 1.0.0
%define gtk_ver 3.0.0
%define libxml2_ver 2.6
%define hal_ver 0.5
%define upower_ver 0.9.0
%define gdkpixbuf_ver 2.12.0
%define qt_ver 4.7.1
%define poppler_ver 0.16.0
%define cairo_ver 1.0
%define gdk_ver 1.0
%define vorbis_ver 0.22
%define flac_ver 1.2.1
%define libexif_ver 0.6
%define libgfs_ver 1.13
%define exempi_ver 2.1.0
%define evo_ver 2.32.0
%define eds_ver 2.32.0
%define gee_ver 0.3
%define taglib_ver 1.6
%define libsecret_ver 0.5
%define libgrss_ver 0.5
%define rest_ver 0.7
%define nm_ver 0.8
%define gst_ver 0.10.31
%define gupnp_dlna_ver 0.9.4
%define sqlite3_ver 3.7.9
%define libosinfo_ver 0.0.2

BuildPreReq: gcc-c++ gnome-common rpm-build-gnome gtk-doc docbook-utils
BuildPreReq: glibc-devel
BuildPreReq: libdbus-devel >= %dbus_ver
BuildPreReq: glib2-devel >= %glib_ver
BuildPreReq: libgio-devel >= %glib_ver
BuildPreReq: libicu-devel libunistring-devel
BuildPreReq: libpango-devel >= %pango_ver
BuildPreReq: libgtk+3-devel >= %gtk_ver
%{?_enable_introspection:BuildPreReq: gobject-introspection-devel >= 0.9.5}
%{?_enable_hal:BuildPreReq: libhal-devel >= %hal_ver}
%{?_enable_upower:BuildPreReq: libupower-devel >= %upower_ver}
%{?_enable_network_manager:BuildPreReq: NetworkManager-glib-devel >= %nm_ver}
%{?_enable_libxml2:BuildPreReq: libxml2-devel >= %libxml2_ver}
BuildPreReq: libpng-devel >= 1.2
BuildPreReq: libuuid-devel
BuildPreReq: libenca-devel >= 1.9
BuildPreReq: vala >= 0.12.0
BuildPreReq: intltool >= 0.35.0
BuildPreReq: sqlite3 libsqlite3-devel >= %sqlite3_ver
BuildRequires: gstreamer1.0-devel >= %gst_ver gst-plugins1.0-devel >= %gst_ver
BuildRequires: libgupnp-dlna-devel >= %gupnp_dlna_ver
%{?_enable_libsecret:BuildPreReq: libsecret-devel >= %libsecret_ver}
%{?_enable_rss:BuildPreReq: libgrss-devel >= %libgrss_ver}
BuildPreReq: libgee0.8-devel >= %gee_ver
%{?_enable_poppler:BuildPreReq: libpoppler-glib-devel >= %poppler_ver}
%{?_enable_libgxps:BuildPreReq: libgxps-devel}
%{?_enable_libexif:BuildPreReq: libexif-devel >= %libexif_ver}
%{?_enable_libiptcdata:BuildPreReq: libiptcdata-devel}
%{?_enable_libgsf:BuildPreReq: libgsf-devel >= %libgfs_ver}
%{?_enable_libjpeg:BuildPreReq: libjpeg-devel}
%{?_enable_libtiff:BuildPreReq: libtiff-devel}
%{?_enable_libvorbis:BuildPreReq: libvorbis-devel >= %vorbis_ver}
%{?_enable_libvorbis:BuildPreReq: libflac-devel >= %flac_ver}
%{?_enable_exempi:BuildPreReq: libexempi-devel >= %exempi_ver}
%{?_enable_evolution:BuildPreReq: evolution-devel >= %evo_ver evolution-data-server-devel >= %eds_ver}
%{?_enable_nautilus_extension:BuildPreReq: libnautilus-devel}
%{?_enable_taglib:BuildPreReq: libtag-devel >= %taglib_ver}
%{?_enable_gtk_doc:BuildPreReq: gtk-doc docbook-utils graphviz}
%{?_enable_qt:BuildPreReq: libqt4-devel}
%{?_enable_libgif:BuildPreReq: libgif-devel}
%{?_enable_libcue:BuildPreReq: libcue-devel}
%{?_enable_libosinfo:BuildPreReq: libosinfo-devel >= %libosinfo_ver}

%description
Tracker is a powerful desktop-neutral first class object
database, tag/metadata database, search tool and indexer.

%package devel
Summary: Headers for developing programs that will use %name-miner
Group: Development/Other
Requires: lib%name = %version-%release
Requires: %name = %version-%release
Obsoletes: lib%name-client-devel
License: LGPLv2.1+

%description devel
Tracker is a powerfull desktop-oriented search tool and indexer.
This package contains header files for development  and link applications with libtracker-miner.

%package devel-doc
Summary: Development documentation for %name
Group: Development/GNOME and GTK+
Conflicts: %name < %version-%release
BuildArch: noarch

%description devel-doc
This package provides development documentation for %name.

%package -n lib%name
Summary: Tracker shared libraries
Group: System/Libraries
Conflicts: %name < %version-%release

%description -n lib%name
This package contains shred Tracker libraries for applications.

%package -n lib%name-gir
Summary: GObject introspection data for the Tracker library
Group: System/Libraries
Requires: %name = %version-%release
Requires: lib%name = %version-%release

%description -n lib%name-gir
GObject introspection data for the Tracker library

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the Tracker library
Group: System/Libraries
BuildArch: noarch
Requires: lib%name-gir = %version-%release

%description -n lib%name-gir-devel
GObject introspection devel data for the Tracker library

%package search-tool
Summary: Tracker search tool(s)
Group: Graphical desktop/GNOME
Requires: %name = %version-%release

%description search-tool
Graphical frontend to tracker search facilities.

%package utils
Summary: Commandline tools for Tracker
Group: Office
Requires: %name = %version-%release

%description utils
Included utilities for Tracker:
  * tracker-import: imports turtle file data into the database.
  * tracker-info: retrieve all information available for a certain file.
  * tracker-control: manage Tracker processes and data.
  * tracker-search: this perfoms a google like search using SEARCHTERM to
    retrieve all matching files where SEARCHTERM appears in any searchable
    metadata.
  * tracker-stats: retreive some statistics.
  * tracker-sparql: allows  the caller to run an RDF query on the database.
  * tracker-tag: tool to manage tags on files.

%package -n evolution-%name
Summary: Tracker plugin for Evolution
Group: Office
Requires: %name = %version-%release
Provides: %name-plugin-evolution = %version-%release
Obsoletes: %name-plugin-evolution

%description -n evolution-%name
Tracker is a powerfull desktop-oriented search tool and indexer.
This package contains plugin for Evolution.

%package -n nautilus-%name
Summary: Nautilus extension for managing tags
Group: Graphical desktop/GNOME
Requires: %name = %version-%release
Provides: %name-nautilus = %version-%release
Obsoletes: %name-nautilus

%description -n nautilus-%name
Nautilus extension for managing tags

%prep
%setup -q
%patch -p1

%build
NOCONFIGURE=1 ./autogen.sh
%configure \
	--disable-static \
	%{subst_enable introspection} \
	%{subst_enable hal} \
	%{subst_enable upower} \
	--with-unicode-support=%unicode_support \
	%{?_enable_network_manager:--enable-network-manager} \
	%{subst_enable libxml2} \
	%{subst_enable gdkpixbuf} \
	%{subst_enable qt} \
	%{subst_enable unac} \
	%{subst_enable libsecret} \
	%{?_enable_rss:--enable-miner-rss} \
	%{?_enable_evolition:--enable-miner-evolution} \
	%{?_enable_nautilus_extension:--enable-nautilus-extension} \
	%{subst_enable taglib} \
	%{?_enable_needle:--enable-tracker-needle} \
	%{?_enable_preferences:--enable-tracker-preferences} \
	%{subst_enable poppler} \
	%{subst_enable libgxps} \
	%{subst_enable libexif} \
	%{subst_enable libiptcdata} \
	%{subst_enable libgsf} \
	%{subst_enable libjpeg} \
	%{subst_enable libtiff} \
	%{subst_enable libgif} \
	%{subst_enable libvorbis} \
	%{subst_enable libflac} \
	%{subst_enable exempi} \
	%{subst_enable libcue} \
	%{subst_enable libosinfo} \
	%{?_enable_gtk_doc:--enable-gtk-doc}

#	--enable-guarantee-metadata \

%make_build

%install
%make DESTDIR=%buildroot install

find %{buildroot} -type f -name "*.la" -exec rm -f {} ';'

%find_lang %name

%files -f %name.lang
%doc AUTHORS ChangeLog COPYING NEWS README
%doc src/libtracker-common/COPYING.LIB
%config(noreplace) %_sysconfdir/xdg/autostart/*
%_datadir/glib-2.0/schemas/*
%dir %_libdir/%name-%ver_api
%_libdir/%name-%ver_api/extract-modules
%_libdir/%name-%ver_api/writeback-modules

%_libexecdir/*

%_datadir/dbus-1/services/*.service
%_man1dir/tracker-miner-fs.1.gz

%dir %_datadir/%name
%_datadir/%name/*.xml
%_datadir/%name/languages
%_datadir/%name/miners
%_datadir/%name/ontologies
%_datadir/%name/extract-rules

%_man1dir/tracker-extract.1.gz
%_man1dir/tracker-writeback.1.gz
%_man1dir/tracker-store.1.gz

%files -n lib%name
%_libdir/libtracker-extract*.so.*
%_libdir/libtracker-miner*.so.*
%_libdir/libtracker-sparql*.so.*
%_libdir/%name-%ver_api/*.so.*

%files utils
%_bindir/tracker-import
%_bindir/tracker-info
%_bindir/tracker-control
%_bindir/tracker-search
%_bindir/tracker-sparql
%_bindir/tracker-stats
%_bindir/tracker-tag
%_man1dir/tracker-import.1.gz
%_man1dir/tracker-info.1.gz
%_man1dir/tracker-control.1.gz
%_man1dir/tracker-search.1.gz
%_man1dir/tracker-sparql.1.gz
%_man1dir/tracker-stats.1.gz
%_man1dir/tracker-tag.1.gz

%files search-tool
%_bindir/tracker-preferences
%_bindir/tracker-needle
%_datadir/applications/*.desktop
%_datadir/icons/*/*/apps/tracker.*
%_datadir/%name/tracker-preferences.ui
%_datadir/%name/tracker-needle.ui
%_man1dir/tracker-preferences.1.gz
%_man1dir/tracker-needle.1.gz

%files devel
%_libdir/%name-%ver_api/*.so
%_includedir/%name-%ver_api
%_pkgconfigdir/*.pc
%_libdir/*.so
%_datadir/vala/vapi/*

%if_enabled gtk_doc
%files devel-doc
%_datadir/gtk-doc/html/*
# temporary delete radio-overview.png, dia have bug - generated image different size on i586 and x86_84
# %exclude %_datadir/gtk-doc/html/ontology/radio-overview.png
%endif

%if_enabled evolution
%files -n evolution-%name
%_libdir/evolution/*/plugins/*
%endif

%if_enabled nautilus_extension
%files -n nautilus-%name
%nautilus_extdir/libnautilus-tracker-tags.so
%endif

%if_enabled introspection
%files -n lib%name-gir
%_typelibdir/*.typelib

%files -n lib%name-gir-devel
%_girdir/*.gir
%endif

%changelog
