%define subver %nil
%set_verify_elf_method textrel=relaxed

%def_enable a52
%def_enable imagemagick
%def_enable libdv
%def_enable libdvdread
%def_enable libfame
%def_enable libjpeg
%def_enable libquicktime
%def_enable libxml2
%def_enable lzo
%def_enable mjpegtools
%def_enable mmx
%def_enable netstream
%def_enable ogg
%def_enable sdl
%def_enable theora
%def_enable v4l
%def_enable vorbis
%def_enable libpostproc
%def_enable freetype2
%def_enable xvid
%def_enable x264
%def_disable pvm3
%def_enable libmpeg2
%def_enable alsa
%def_disable avifile
%def_disable ibp
%def_disable libmpeg3
%def_disable xio

Name: transcode
Version: 1.1.5
Release: alt6

Summary: A linux video stream processing utility

License: GPL
Group: Video
Url: http://tcforge.berlios.de/

Source: %name-%version.tar.bz2
Source1: subtitleripper-0.3-4.tar
Source2: export_dvraw.c
Patch0: %name-subtitleripper.patch
Patch1: %name-mp3merge.patch
# http://article.gmane.org/gmane.comp.video.transcode.user/18434
# http://article.gmane.org/gmane.comp.video.transcode.user/18381
# http://article.gmane.org/gmane.comp.video.transcode.user/18446

# ALTLinux patches
Patch2: transcode-1.1.5-alt-libav.patch
Patch3: transcode-1.1.5-alt-aud_aux.patch
Patch98: transcode-1.1.5-textrel.patch
Patch99: subtitleripper-0.3-4-alt-makefile.patch

%define ffmpeg_ver 0.6
%define avifile_ver 0.737
%define xvid_ver 1.2.2
%define exif_ver 0.6.17

#BuildRequires(pre): xvid-devel >= %xvid_ver
#BuildRequires(pre): libexif-devel >= %exif_ver
# Automatically added by buildreq on Mon Sep 05 2011 (-bi)
# optimized out: elfutils fontconfig libICE-devel libSM-devel libX11-devel libXext-devel libXmu-devel libXt-devel libavcodec-devel libavutil-devel libdv-devel libjpeg-devel libogg-devel libopencore-amrnb0 libopencore-amrwb0 libpng-devel libquicktime111-core libvorbis-devel pkg-config python-base ruby xorg-videoproto-devel xorg-xextproto-devel xorg-xproto-devel zlib-devel
#BuildRequires: glibc-devel-static imake libImageMagick-devel libSDL-devel libXaw-devel libXpm-devel libXv-devel liba52-devel libalsa-devel libavformat-devel libdvdread-devel libfreetype-devel liblame-devel liblzo2-devel libmjpegtools-devel libmpeg2-devel libnetpbm-devel libpostproc-devel libquicktime-devel libtheora-devel libv4l-devel libx264-devel libxml2-devel libxvid-devel rpm-build-ruby xorg-cf-files
BuildRequires: glibc-devel imake libImageMagick-devel libSDL-devel libXaw-devel libXpm-devel
BuildRequires: libXv-devel liba52-devel libalsa-devel
BuildRequires: libavformat-devel libdvdread-devel libfreetype-devel liblame-devel liblzo2-devel
BuildRequires: libmjpegtools-devel libmpeg2-devel libnetpbm-devel libpostproc-devel
BuildRequires: libquicktime-devel libtheora-devel libv4l-devel libx264-devel libxml2-devel
BuildRequires: libxvid-devel >= %xvid_ver xorg-cf-files
BuildPreReq: libpng-devel

%description
transcode  is a linux text-console utility for video stream
processing.

Decoding and encoding is done by loading modules that are
responsible for feeding transcode with raw video/audio streams (import
modules) and encoding the frames (export modules).

It supports elementary video and audio frame transformations, including
de-interlacing or fast resizing of video frames and loading of external
filters.

A number of modules are included to enable import of DVDs
on-the-fly, MPEG elementary (ES) or program streams (VOB), MPEG video,
Digital Video (DV), YUV4MPEG streams, NuppelVideo file format and raw or
compressed (pass-through) video frames and export modules for writing
DivX;-), OpenDivX, DivX 4.xx or uncompressed AVI files with MPEG, AC3
(pass-through) or PCM audio. Additional export modules to write single
frames (PPM) or YUV4MPEG streams are available, as well as an interface
import module to the avifile library. It's modular concept is intended
to provide flexibility and easy user extensibility to include other
video/audio codecs or filetypes.

A set of tools is included to demux (tcdemux), extract (tcextract) and
decode (tcdecode) the sources into raw video/audio streams for import,
probing (tcprobe) and scanning (tcscan) your sources and to enable
post-processing of AVI files, fixing AVI file header information
(avifix), merging multiple files (avimerge) or splitting large AVI files
(avisplit) to fit on a CD.

%package -n subtitleripper
Summary: DVD subtitles ripper/converter
Group: Video
Requires: %name

%description -n subtitleripper
This package contains tools to extract DVD subtitles from a
subtitle stream and converts it to pgm or ppm images or into VobSub
format.

%prep
%setup -q -n %name-%{version}%{subver}
mkdir -p contrib/subrip
tar xf %SOURCE1 -C contrib/subrip/
sed -i s/-lppm/-lnetpbm/ contrib/subrip/subtitleripper/Makefile
sed -i s/getline/get_line/ contrib/subrip/subtitleripper/vobsub.c
%patch0 -p0
%patch1 -p1
%patch2 -p2
%patch3 -p0
%patch98 -p2
%patch99 -p1
install -m644 %SOURCE2 filter/

%build
%autoreconf
%configure \
%{subst_enable mmx} \
%{subst_enable a52} \
%if_enabled a52
--enable-a52-default-decoder \
%endif
%{subst_enable avifile} \
%{subst_enable ibp} \
%{subst_enable imagemagick} \
%{subst_enable libdv} \
%{subst_enable libdvdread} \
%{subst_enable libfame} \
%if_enabled libfame
--with-libfame-libs=/usr/lib \
%endif
%{subst_enable libjpeg} \
%{subst_enable libmpeg3} \
%{subst_enable libquicktime} \
%{subst_enable libxml2} \
%{subst_enable lzo} \
%{subst_enable mjpegtools} \
%{subst_enable netstream} \
%{subst_enable ogg} \
%{subst_enable pvm3} \
%{subst_enable sdl} \
%{subst_enable theora} \
%if_enabled v4l
--enable-v4l \
--enable-libv4l2 \
--enable-libv4lconvert \
%endif
%{subst_enable vorbis} \
%{subst_enable libpostproc} \
%{subst_enable alsa} \
%{subst_enable xvid} \
%{subst_enable x264} \
%if_enabled libmpeg2
--enable-libmpeg2 \
--enable-libmpeg2convert \
%endif
%{subst_enable freetype2}

%make_build

pushd contrib/subrip/subtitleripper
%make "CC=gcc $RPM_OPT_FLAGS"
popd

%install
%makeinstall
pushd contrib/subrip/subtitleripper
install -m755 \
srttool \
subtitle2pgm \
subtitle2vobsub \
pgm2txt %buildroot/%_bindir/
popd

# remove non-packaged files
rm -f %buildroot%_libdir/%name/*.la
rm -rf %buildroot%_docdir/%name

# The package contains a CVS/.svn/.git/.hg/.bzr/_MTN directory of revision control system.
# It was most likely included by accident since CVS/.svn/.hg/... etc. directories 
# usually don't belong in releases. 
# When packaging a CVS/SVN snapshot, export from CVS/SVN rather than use a checkout.
find $RPM_BUILD_ROOT -type d \( -name 'CVS' -o -name '.svn' -o -name '.git' -o -name '.hg' -o -name '.bzr' -o -name '_MTN' \) -print -exec rm -rf {} \; ||:
# the find below is useful in case those CVS/.svn/.git/.hg/.bzr/_MTN directory is added as %%doc
find . -type d \( -name 'CVS' -o -name '.svn' -o -name '.git' -o -name '.hg' -o -name '.bzr' -o -name '_MTN' \) -print -exec rm -rf {} \; ||:

%files
%_bindir/%name
%_bindir/avi*
%_bindir/tc*
%dir %_libdir/%name
%_libdir/%name/*.so
%_libdir/%name/*.cfg
%_libdir/%name/*.awk
%_man1dir/*
%doc AUTHORS ChangeLog README TODO
%doc docs/README*
%doc docs/*.txt docs/html

%files -n subtitleripper
%_bindir/srttool
%_bindir/subtitle2pgm
%_bindir/subtitle2vobsub
%_bindir/pgm2txt
%doc contrib/subrip/subtitleripper/{README*,ChangeLog}

%changelog
