Name: tsung
Version: 1.4.1.git20111220
Release: alt1
Summary: A distributed multi-protocol load testing tool
URL: http://%name.erlang-projects.org/
License: %gpl2plus
Group: Development/Tools
Source: http://%name.erlang-projects.org/dist/%name-%version.tar
BuildArch: noarch
Provides: erlang-%name = %version-%release
Requires: erlang-otp >= R12B perl-RRD
Packager: hsv <hsv@altlinux.org>

BuildRequires(pre): rpm-build-licenses
BuildRequires(pre): rpm-macros-erlang
BuildRequires: rpm-build-erlang
BuildRequires: erlang-otp-devel >= R12B
BuildRequires: perl-RRD

%description
%name is a distributed load testing tool. It is protocol-independent
and can currently be used to stress and benchmark HTTP and Jabber
servers. It simulates user behaviour using an XML description file,
reports many measurements in real time (statistics can be customized
with transactions, and graphics generated using gnuplot).
For HTTP, it supports 1.0 and 1.1, has a proxy mode to record sessions,
supports GET and POST methods, Cookies, and Basic WWW-authentication.
It also has support for SSL.


%prep
%setup


%build
%autoreconf
%configure
%make_build %name doc
%make boot
bzip2 --best --keep --force CHANGES


%install
%make_install \
    DESTDIR=%buildroot \
    PACKAGE_TARNAME=%name-%version \
    DOC_DIR=%_docdir/%name-%version \
    ERLANG_LIB_DIR=%_otplibdir \
    LIBDIR=%_libexecdir/%name \
    install
rm -rf %buildroot%_otplibdir/{*/{src,BUILD_OPTIONS},tsung_*/include}
install -m 0644 CHANGES.* CONTRIBUTORS README TODO doc/*.{erl,png,txt} %buildroot%_docdir/%name-%version/


%files
%_docdir/%name-%version/
%_bindir/*
%_otplibdir/*
%_man1dir/*
%_libexecdir/%name
%_datadir/%name


%changelog
