Name: udev_static-addon
Version: 0.2
Release: alt6
Summary: Set of static device nodes suitable for virtual /dev filesystem
License: GPL
Group: System/Configuration/Hardware
Url: https://bugzilla.altlinux.org/show_bug.cgi?id=6296

Provides: udev_static = %version-%release
Conflicts: udev_static-complete
BuildArch: noarch

Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires: propagator

%description
udev_static is a package complement to udev. While udev itself deals mostly with dynamically created
devices nodes, its approach is not always suitable for real-life usage. In particular, pure udev
system is not able to load an appropriate module when a program accesses corresponding device node,
because this device node simply doesn't exist if the module hasn't been loaded yet. 

modules_lookup tries to make up for this deficiency by intercepting attempts to access yet
amissing device nodes and load associated modules before. Unfortunately it requires a patched
version of tmpfs and still doesn't cover all possible cases

recent udev packages (>= 0.50-alt3) support /etc/udev/devices/ subdirectory where system
administrators can create "preconfigured" device nodes which will be copied to /dev upon
udev daemon startup. But this approach when applied thoughtlessly can use a lot of space right
in root partition.

udev_static provides a compressed cpio archive which contains devices inodes to create
upon udevd startup similar to /etc/udev/devices. But because of the form chosen (compressed
cpio archive) even entire contents of old static dev package takes about 90Kb of disk space.

This package contains an almost complete snapshot of /dev system excluding devices which
_exactly_ are handled by hotplug or other standard subsystems

%prep
%setup -q
%patch -p1

%build
cat udev_static | gencpio - | bzip2 -c > static_devices.cpio.bz2

%install
install -pD -m0644 static_devices.cpio.bz2 %buildroot%_sysconfdir/udev/static_devices.cpio.bz2

%files
%config(noreplace, missingok) %_sysconfdir/udev/static_devices.cpio.bz2

%changelog
