Name: ulogd
Version: 1.24
Release: alt16

Summary: ulogd - The userspace logging daemon for netfilter
Url: http://www.netfilter.org/projects/ulogd/
License: %gpl2plus
Group: System/Servers

Source: http://www.netfilter.org/projects/ulogd/files/%name-%version.tar
Source1: %name.init
Source2: %name.logrotate
Source3: %name.service
Patch0: %name-%version-%release.patch

BuildRequires(pre): rpm-build-licenses
# Automatically added by buildreq on Tue Mar 20 2007
BuildRequires: libpcap-devel zlib-devel libMySQL-devel postgresql-devel libsqlite3-devel

%description
Ulogd is an universal logging daemon for the ULOG target of netfilter, the
Linux 2.6 firewalling subsystem. Ulogd is able to log packets in various
formats to different targets (text files, databases, etc..). It has an
easy-to-use plugin interface to add new protocols and new output targets.

%package mysql
Summary: MySQL output plugin for ulogd
Group: System/Servers
Requires: %name = %version-%release
Requires: zlib

%description mysql
ulogd-mysql is a MySQL output plugin for ulogd. It enables logging of
firewall information into a MySQL database.

%package pgsql
Summary: PostgreSQL output plugin for ulogd
Group: System/Servers
Requires: %name = %version-%release

%description pgsql
ulogd-pgsql is a PostgreSQL output plugin for ulogd. It enables logging of
firewall information into a PostgreSQL database.

%package sqlite3
Summary: SQLite3 output plugin for ulogd
Group: System/Servers
Requires: %name = %version-%release

%description sqlite3
ulogd-sqlite3 is a SQLite output plugin for ulogd. It enables logging of
firewall information into a SQLite v.3 database.

%prep
%setup
%patch0 -p1

%build
#export CFLAGS="$RPM_OPT_FLAGS -fPIC"
%configure \
	--with-mysql=/usr/lib/mysql \
	--with-pgsql=/usr/lib/pgsql \
	--with-sqlite3 \
	--with-sqlite3-log-ip-as-string
make DESTDIR=%buildroot
#rm -f ulogd
#export LDFALGS="-pie"
#make ulogd

%install
mkdir -p %buildroot/%_logdir/%name
mkdir -p %buildroot/%_sysconfdir
mkdir -p %buildroot/%_libdir/%name
mkdir -p %buildroot/%_sbindir
make install DESTDIR=%buildroot

mkdir -p %buildroot/%_sysconfdir/rc.d/init.d
install %SOURCE1 %buildroot/%_sysconfdir/rc.d/init.d/%name

install -pDm644 %SOURCE3 %buildroot/%_unitdir/%name.service

mkdir -p %buildroot/%_sysconfdir/logrotate.d
install %SOURCE2 %buildroot/%_sysconfdir/logrotate.d/%name

mkdir -p %buildroot/%_datadir/%name
install doc/mysql.table %buildroot/%_datadir/%name/
install doc/mysql.table.ipaddr-as-string %buildroot/%_datadir/%name/
install doc/pgsql.table %buildroot/%_datadir/%name/
install doc/sqlite3.table %buildroot/%_datadir/ulogd/
mkdir -p %buildroot/%_localstatedir/ulogd/

mkdir -p %buildroot/%_man8dir
install %name.8 %buildroot/%_man8dir/%name.8

rm -rf %buildroot/%_includedir/libipulog

%pre
%_sbindir/groupadd -r -f %name >/dev/null 2>&1
%_sbindir/useradd -r -n -g %name -d /dev/null -s /dev/null %name >/dev/null 2>&1 ||:

%preun
%preun_service %name

%files
%attr(0755,root,root) %_sbindir/%name
%attr(0640,root,%name) %config(noreplace) %_sysconfdir/%name.conf
%_sysconfdir/rc.d/init.d/%name
%_unitdir/%name.service
%config(noreplace) %_sysconfdir/logrotate.d/%name
%dir %_libdir/%name
%attr(1770,root,ulogd) %_logdir/%name
%_libdir/%name/*.so
%exclude %_libdir/%name/ulogd_MYSQL.so
%exclude %_libdir/%name/ulogd_PGSQL.so
%exclude %_libdir/%name/ulogd_SQLITE3.so
%doc COPYING AUTHORS README
%doc doc/%name.txt doc/%name.a4.ps doc/%name.html
%_man8dir/*
%attr(1770,root,ulogd) %_localstatedir/%name/
%dir %_datadir/%name/

%files mysql
%_libdir/%name/ulogd_MYSQL.so
%_datadir/%name/mysql.table
%_datadir/%name/mysql.table.ipaddr-as-string

%files pgsql
%_libdir/%name/ulogd_PGSQL.so
%_datadir/%name/pgsql.table

%files sqlite3
%_libdir/%name/ulogd_SQLITE3.so
%_datadir/%name/sqlite3.table

%changelog
