Name: unixODBC
Version: 2.2.12
Release: alt6

Summary: Unix ODBC driver manager and database drivers
Summary(ru_RU.UTF-8): Система управления драйверами ODBC для unix 
Group: Databases
License: LGPL
Url: http://www.unixODBC.org

Requires: lib%name = %version-%release
Provides: MyODBC = %version-%release

Source0: http://www.unixodbc.org/%name-%version.tar.gz

Source1: %name-odbcinst.ini
Source2: %name-DataManager.desktop
Source3: %name-ODBCConfig.desktop

Patch1: %name-depcomp.patch
Patch2: %name-parserupdate.patch
Patch3: %name-2.2.11-stricmp.patch
Patch4: %name-2.2.11-symbols.patch
Patch5: %name-2.2.12-alt-ltdl.patch

# Automatically added by buildreq on Mon Feb 14 2011
BuildRequires: flex gcc-c++ libltdl7-devel libqt3-devel libreadline-devel

%description
UnixODBC is a free/open and solution for ODBC. ODBC is an open
specifican for providing application developers with a predictable API
with which to access Data Sources. Data Sources include SQL Servers and
any Data Source with an ODBC Driver.

%description -l ru_RU.UTF-8
UnixODBC - это свободное ODBC решение.
ODBC представляет из себя открытую спецификацию для разработки
приложений с универсальным API для доступа к базам данных.
Базы данных включает в себя сервера SQL и другие источники данных,
поддерживаемые ODBC драйверами.

%package -n lib%name
Summary: Shared libraries for ODBC
Summary(ru_RU.UTF-8): Разделяемые библиотеки для ODBC
Group: Development/Databases
%ifarch x86_64
Provides: libodbc.so()(64bit) libodbcinst.so()(64bit)
%else
Provides: libodbc.so libodbcinst.so
%endif

%description -n lib%name
unixODBC aims to provide a complete ODBC solution for the Linux platform.
This package contains the shared libraries.

%description -n lib%name -l ru_RU.UTF-8
unixODBC представляет из себя полную спецификацию ODBC для Linux платформы.
Этот пакет содержит в себе раделяемые библиотеки.

%package -n lib%name-devel
Summary: Includes for ODBC development
Summary(ru_RU.UTF-8): Заголовочные файлы для разработки с использованием ODBC
Group: Development/Databases
Requires: lib%name = %version-%release

%description -n lib%name-devel
unixODBC aims to provide a complete ODBC solution for the Linux platform.
This package contains the include files for development.

%description -n lib%name-devel -l ru_RU.UTF-8
unixODBC представляет из себя полную спецификацию ODBC для Linux платформы.
Этот пакет содержит заголовочные файлы для разработки с использованием ODBC

%package gui-qt
Summary: ODBC configurator, Data Source browser and ODBC test tool based on Qt
Summary(ru_RU.UTF-8): Система управления ODBC, утилита для просмотра источника данных и тестовые утилиты для ODBC, основанные на Qt
Group: Databases
Requires: %name = %version-%release

%description gui-qt
unixODBC aims to provide a complete ODBC solution for the Linux platform.
This package contains two Qt based GUI programs for unixODBC:
ODBCConfig and DataManager

%description gui-qt -l ru_RU.UTF-8
unixODBC представляет из себя полную спецификацию ODBC для Linux платформы.
Этот пакет содержит основанные на QT утилиты для работы с unixODBC.

%prep
%setup -q
rm -r libltdl
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1

%build
export QTDIR=%_qt3dir
%autoreconf
%configure \
	--with-gnu-ld \
	--enable-threads \
	--enable-gui \
	--enable-drivers \
	--enable-ltdllib \
	--with-qt-libraries=%_qt3dir/lib \
	--disable-static
%make_build

%install
%makeinstall_std

install -pD -m644 %SOURCE1 %buildroot%_sysconfdir/odbcinst.ini
subst "s,@libdir@,%_libdir," %buildroot%_sysconfdir/odbcinst.ini

install -pD -m644 %SOURCE2 %buildroot%_desktopdir/DataManager.desktop
install -pD -m644 %SOURCE3 %buildroot%_desktopdir/ODBCConfig.desktop
install -pD -m644 DataManager/LinuxODBC.xpm %buildroot%_niconsdir/LinuxODBC.xpm
install -pD -m644 DataManager/ODBC.xpm %buildroot%_miconsdir/odbc.xpm

find doc -name Makefile\* -delete

%files
%doc AUTHORS COPYING README doc/AdministratorManual doc/UserManual doc/index.html doc/*.gif
%config(noreplace) %verify(not md5 size mtime) %_sysconfdir/odbc*.ini
%_bindir/dltest
%_bindir/isql
%_bindir/iusql
%_bindir/odbcinst

%files -n lib%name
%_libdir/lib*.so.*
%exclude %_libdir/libodbcinstQ*.so.*
%_libdir/libodbc.so
%_libdir/libodbcinst.so
%_libdir/libodbcpsql.so
%_libdir/libodbcpsqlS.so
%_libdir/libodbcmyS.so

%files -n lib%name-devel
%doc ChangeLog doc/ProgrammerManual doc/lst
%_includedir/*
%_bindir/odbc_config
%_libdir/lib*.so
%exclude %_libdir/libodbc.so
%exclude %_libdir/libodbcinst.so
%exclude %_libdir/libodbcpsql.so
%exclude %_libdir/libodbcpsqlS.so
%exclude %_libdir/libodbcmyS.so
%exclude %_libdir/libodbcinstQ*.so

%files gui-qt
%_bindir/odbctest
%_bindir/ODBCConfig
%_bindir/DataManager
%_bindir/DataManagerII
%_libdir/libodbcinstQ*
%_desktopdir/*.desktop
%_iconsdir/hicolor/*/apps/*.xpm

%changelog
