Name: unzip
Version: 6.0
Release: alt2.qa1

Packager: Victor Forsyuk <force@altlinux.org>

Summary: An utility for unpacking zip archives
License: distributable (BSD-based)
Group: Archiving/Compression

Url: http://www.info-zip.org/
%define src_ver	%(echo %version|sed "s/\\.//"g)
Source: http://downloads.sourceforge.net/infozip/unzip%src_ver.tar.gz
Patch1: unzip-6.0-alt-natspec.patch

# Automatically added by buildreq on Mon Aug 10 2009
BuildRequires: libnatspec-devel

%description
The unzip utility is used to list, test, or extract files from a zip archive.
Zip archives are commonly found on MS-DOS systems. The zip utility, included in
the zip package, creates zip archives. Zip and unzip are both compatible with
archives created by PKWARE(R)'s PKZIP for MS-DOS, but the programs' options and
default behaviors do differ in some respects.

%prep
%setup -n unzip%src_ver
%patch1 -p1
ln -s unix/Makefile .

%__subst 's/1L/1/g' man/*.1

# Let configure emit link flag required for our build instead of useless strip option:
%__subst 's/"-s"/"-lnatspec"/' unix/configure
# Tweak to build with our optimizations and defines:
%define _optlevel 3
%__subst 's/CFLAGS_OPT=.-O3./CFLAGS_OPT="%optflags -DNO_WORKING_ISPRINT -DDATE_FORMAT=DF_YMD"/g' unix/configure
# -DNO_WORKING_ISPRINT fixes ALT bug #21137.

%build
# TODO: build with bzip2 compression method support
#
# We will use `generic' make target instead of ready made `linux' or `linux_noasm`
# This target allows us to use flags and defines produced by unzip's configure
# script at build time instead of hardcoded for linux target.
%make flags
%make_build -e generic
%make test

%install
mkdir -p %buildroot{%_bindir,%_man1dir}
install -p -m755 %name f%name %{name}sfx unix/zipgrep %buildroot%_bindir
install -p -m644 man/*.1 %buildroot%_man1dir/
ln -s unzip %buildroot%_bindir/zipinfo

%files
%_bindir/*
%_man1dir/*
%doc BUGS LICENSE

%changelog
