%define _libexecdir %_prefix/libexec/upower
%define systemdsystemunitdir /lib/systemd/system

Name: upower
Version: 0.9.20
Release: alt2
Summary: Power Management Service
License: GPLv2+
Group: System/Libraries
URL: http://cgit.freedesktop.org/upower/
Packager: Valery Inozemtsev <shrek@altlinux.ru>

Provides: DeviceKit-power = 016
Obsoletes: DeviceKit-power < 016

Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires: gtk-doc intltool libdbus-glib-devel libgio-devel libgudev-devel
BuildRequires: libpolkit1-devel libudev-devel libusb-devel gobject-introspection-devel
BuildRequires: libimobiledevice-devel systemd-devel libsystemd-daemon-devel

%description
UPower provides a daemon, API and command line tools for
managing power devices attached to the system.

%package -n lib%name
Summary: %name libraries
Group: System/Libraries
Provides: libdevkit-power = 016
Obsoletes: libdevkit-power < 016

%description -n lib%name
Libraries for %name

%package -n lib%name-devel
Summary: Development libraries and headers for %name
Group: Development/C
Requires: lib%name = %version-%release
Provides: libdevkit-power-devel = 016
Obsoletes: libdevkit-power-devel < 016

%description -n lib%name-devel
Headers, libraries and API docs for %name

%package -n lib%name-gir
Summary: GObject introspection data for the UPower library
Group: System/Libraries
Requires: lib%name = %version-%release
Provides: libdevkit-power-gir = 016
Obsoletes: libdevkit-power-gir < 016

%description -n lib%name-gir
GObject introspection data for the UPower library

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the UPower library
Group: System/Libraries
BuildArch: noarch
Requires: lib%name-gir = %version-%release lib%name-devel = %version-%release
Provides: libdevkit-power-gir-devel = 016
Obsoletes: libdevkit-power-gir-devel < 016

%description -n lib%name-gir-devel
GObject introspection devel data for the UPower library

%prep
%setup -q
%patch -p1

rm -f acinclude.m4

%build
%autoreconf
%configure \
	--enable-gtk-doc \
	--enable-systemd \
	--with-systemdsystemunitdir=%systemdsystemunitdir \
	--libexecdir=%_libexecdir \
	--localstatedir=%_var \
	--disable-static
#	--enable-deprecated
%make_build

%install
%make DESTDIR=%buildroot install

%find_lang %name

%files -f %name.lang
%doc AUTHORS NEWS README
%dir %_sysconfdir/UPower
%_sysconfdir/UPower/*.conf
%_sysconfdir/dbus-1/system.d/*.conf
%systemdsystemunitdir/*
/lib/udev/rules.d/*.rules
/lib/systemd/system-sleep/notify-upower.sh
%_bindir/*
%_libexecdir
%_datadir/dbus-1/system-services/*.service
%_datadir/polkit-1/actions/*.policy
%_mandir/man?/*
%dir %_var/lib/%name

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc
%_datadir/dbus-1/interfaces/*.xml
%_datadir/gtk-doc/html/*

%files -n lib%name-gir
%_libdir/girepository-1.0/*.typelib

%files -n lib%name-gir-devel
%_datadir/gir-1.0/*.gir

%changelog
