%def_enable shared
%def_enable static
%def_with tcp_wrappers
#----------------------------------------------------------------------
%define subst_with_to() %{expand:%%{?_with_%{1}:--with-%{2}}} %{expand:%%{?_without_%{1}:--without-%{2}}}

%define Name USB/IP
Name: usbip
%define lname lib%name
Summary: Utility for manage %Name devices
Version: 1.1.1
Release: alt1.M70P.1
License: GPLv2+
Group: System/Configuration/Networking
Source: %name-%version.tar
URL: http://www.kernel.org
Obsoletes: %name-common
Obsoletes: %name-client <= %version
Provides: %name-client = %version-%release
%{?_enable_shared:Requires: %lname = %version-%release}

BuildRequires: zlib-devel %{?_with_tcp_wrappers:libwrap-devel} libsysfs-devel >= 2.0.0

%description
Utility for manage %Name devices.


%package -n %{name}d
Summary: %Name server daemon
Group: System/Configuration/Networking
Obsoletes: %name-server <= %version
Provides: %name-server = %version-%release
%{?_enable_shared:Requires: %lname = %version-%release}

%description -n %{name}d
%Name server daemon.


%if_enabled shared
%package -n %lname
Summary: %Name shared library
Group: System/Libraries

%description -n %lname
%Name shared library.
%endif


%package -n %lname-devel
Summary: %Name devel files
Group: Development/C
Requires: %lname%{?_disable_shared:-devel-static} = %version-%release

%description -n %lname-devel
%Name devel files.


%if_enabled shared
%package -n %lname-devel-static
Summary: %Name static library
Group: Development/C
Requires: %lname-devel = %version-%release

%description -n %lname-devel-static
%Name static library.
%endif


%prep
%setup -q


%build
./autogen.sh
%configure \
	%{subst_enable shared} \
	%{subst_enable static} \
	%{subst_with_to tcp_wrappers tcp-wrappers} \
	--with-usbids-dir=%_datadir/hwdatabase
%make_build V=1


%install
%makeinstall_std


%files
%doc AUTHORS README
%_sbindir/%name
%_man8dir/%name.*


%files -n %{name}d
%_sbindir/%{name}d
%_man8dir/%{name}d.*


%if_enabled shared
%files -n %lname
%_libdir/*.so.*
%endif


%files -n %lname-devel
%_includedir/*
%{?_enable_shared:%_libdir/*.so}


%if_enabled static
%files -n %lname-devel-static
%_libdir/*.a
%endif


%changelog
