Name: v4l-utils
Version: 0.8.8
Release: alt2

Summary: Collection of video4linux support libraries and utilities
License: GPLv2+
Group: Video
Url: http://linuxtv.org

Source: %name-%version-%release.tar
BuildRequires: gcc-c++ libjpeg-devel

%package -n ir-keytable
Summary: IR keytable management tool
Group: System/Kernel and hardware
Conflicts: v4l-utils < 0.8.2-alt1

%package -n libv4l
Summary: video4linux supprot libraries
Group: System/Libraries
License: LGPLv2+

%package -n libv4l-devel
Summary: Development files for libv4l
Group: Development/C
License: LGPLv2+
Requires: libv4l-devel = %version-%release

%description
Linux V4L2 and DVB API utilities.

%description -n ir-keytable
ir-keytable  is a tool that lists the Remote Controller devices, allows
to get/set IR keycode/scancode tables, test events generated by IR, and
to adjust other Remote Controller options.

%description -n libv4l
libv4l is a collection of libraries which adds a thin abstraction layer on
top of video4linux2 devices. The purpose of this (thin) layer is to make it
easy for application writers to support a wide variety of devices without
having to write separate code for different devices in the same class. libv4l
consists of 3 different libraries: libv4lconvert, libv4l1 and libv4l2.

libv4lconvert offers functions to convert from any (known) pixelformat
to V4l2_PIX_FMT_BGR24 or V4l2_PIX_FMT_YUV420.

libv4l1 offers the (deprecated) v4l1 API on top of v4l2 devices, independent
of the drivers for those devices supporting v4l1 compatibility (which many
v4l2 drivers do not).

libv4l2 offers the v4l2 API on top of v4l2 devices, while adding for the
application transparent libv4lconvert conversion where necessary.

%description -n libv4l-devel
The libv4l-devel package contains libraries and header files for
developing applications that use libv4l.

%prep
%setup

%build
make CFLAGS="%optflags" LIBDIR=%_libdir

%install
%make_install PREFIX=%prefix LIBDIR=%_libdir DESTDIR=%buildroot install
cp utils/xc3028-firmware/README README.xc3028-firmware

%files
%doc ChangeLog COPYING README README.xc3028-firmware

%_sbindir/*
%_bindir/*
%exclude %_bindir/ir-keytable

%files -n ir-keytable
/lib/udev/rules.d/70-infrared.rules

%config(noreplace) %_sysconfdir/rc_maps.cfg
%dir %_sysconfdir/rc_keymaps
%config(noreplace) %_sysconfdir/rc_keymaps/*

%_bindir/ir-keytable
%_man1dir/ir-keytable.1*

%files -n libv4l
%doc COPYING.LIB ChangeLog README.lib TODO
%_libdir/libv4l*.so.*
%_libdir/libv4l

%files -n libv4l-devel
%doc README.lib-multi-threading
%_includedir/libv4l*.h
%_libdir/libv4l*.so
%_pkgconfigdir/*.pc

%changelog
