%def_with klibc
%def_without debug

Name: v86d
Version: 0.1.10
Release: alt5
Summary: A x86 Emulation Daemon
License: GPLv2
Group: System/Kernel and hardware
URL: http://dev.gentoo.org/~spock/projects/uvesafb/
Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires: kernel-headers >= 2.6.25
%{?_with_klibc:BuildRequires: klibc-devel >= 1.5-alt1.2}

%description
%name provides a backend for kernel drivers that need to execute ?86 BIOS code.
The code is executed in a controlled environment and the results are passed back
to the kernel via the netlink interface.


%if_with klibc
%package initramfs
Summary: A x86 Emulation Daemon (initramfs variant)
Group: System/Kernel and hardware

%description initramfs
%name provides a backend for kernel drivers that need to execute ?86 BIOS code.
The code is executed in a controlled environment and the results are passed back
to the kernel via the netlink interface.

This package contains initramfs variant of %name linked with klibc.
%endif


%prep
%setup
%patch -p1
sed -i '/^[[:blank:]]*LDFLAGS/s/ -static .*$//' Makefile


%build
%define _optlevel s

%ifarch %ix86
%def_without x86emu
%else
%def_with x86emu
%endif

%if_with klibc
export CFLAGS="%optflags -fno-asynchronous-unwind-tables"
export LDFLAGS="-shared"
./configure \
	--without-debug \
	%{subst_with x86emu} \
	--with-klibc
%make_build KDIR=%_includedir/linux-default
mv %name{,.initramfs}
make clean
%endif

export CFLAGS="%optflags"
export LDFLAGS=
./configure \
	%{subst_with debug} \
	%{subst_with x86emu} \
	--default
%make_build KDIR=%_includedir/linux-default


%install
install -pD -m 0755 {,%buildroot/sbin/}%name
%{?_with_klibc:install -pD -m 0755 %name.initramfs %buildroot/lib/mkinitrd/%name}


%files
%doc AUTHORS ChangeLog README TODO
/sbin/*


%if_with klibc
%files initramfs
/lib/mkinitrd/*
%endif


%changelog
