Name: valgrind
Version: 3.8.1
Release: alt2

Summary: Valgrind, an open-source memory debugger for GNU/Linux
License: GPLv2+
Group: Development/Other
URL: http://www.valgrind.org/

%ifdef cvsdate
Source: %name-%cvsdate.tar
%else
Source: http://www.valgrind.org/downloads/%name-%version.tar
%endif

Patch1: valgrind-3.8.1-rh-cachegrind-improvements.patch
Patch2: valgrind-3.8.1-rh-openat.patch
Patch3: valgrind-3.8.1-rh-helgrind-race-supp.patch
Patch4: valgrind-3.8.1-rh-stat_h.patch
Patch5: valgrind-3.8.1-rh-config_h.patch
Patch6: valgrind-3.8.1-rh-capget.patch
Patch7: valgrind-3.8.1-rh-pie.patch
Patch8: valgrind-3.8.1-alt-arm.patch
Patch9: valgrind-3.8.1-rh-ldso-supp.patch
Patch10: valgrind-3.8.1-rh-x86-backtrace.patch
Patch11: valgrind-3.8.1-rh-find-buildid.patch
Patch12: valgrind-3.8.1-rh-abbrev-parsing.patch
Patch13: valgrind-3.8.1-rh-cfi_dw_ops.patch
Patch14: valgrind-3.8.1-rh-gdbserver_tests-mcinvoke-ppc64.patch
Patch15: valgrind-3.8.1-rh-x86_amd64_features-avx.patch
Patch16: valgrind-3.8.1-rh-gdbserver_tests-syscall-template-source.patch
Patch17: valgrind-3.8.1-rh-overlap_memcpy_filter.patch
Patch21: valgrind-3.8.1-rh-avx2-bmi-fma.patch
Patch22: valgrind-3.8.1-rh-bmi-conf-check.patch
Patch23: valgrind-3.8.1-rh-memcheck-mc_translate-Iop_8HLto16.patch
Patch24: valgrind-3.8.1-rh-avx2-prereq.patch
Patch25: valgrind-3.8.1-rh-glibc-2.17.patch

# valgrind needs /proc to work
Requires: /proc
%{?!_disable_check:BuildRequires: /proc}

# Automatically added by buildreq on Fri Dec 12 2008
BuildRequires: gcc-c++ libX11-devel


%description
Valgrind is a GPL'd tool to help you find memory-management problems in
your programs.  When a program is run under Valgrind's supervision, all
reads and writes of memory are checked, and calls to
malloc/new/free/delete are intercepted.  As a result, Valgrind can
detect problems such as:

    * Use of uninitialised memory
    * Reading/writing memory after it has been free'd
    * Reading/writing off the end of malloc'd blocks
    * Reading/writing inappropriate areas on the stack
    * Memory leaks -- where pointers to malloc'd blocks are lost forever
    * Passing of uninitialised and/or unaddressible memory to system calls
    * Mismatched use of malloc/new/new [] vs free/delete/delete []
    * Overlaps of arguments to strcpy() and related functions
    * Some abuses of the POSIX pthread API

%package devel
Summary: Header files for embedding Valgrind calls into other applications
License: BSD-style
Group: Development/Other
Requires: %name = %version-%release

%description devel
The valgrind-devel subpackage contains header files with macros to
manipulate and query Valgrind's execution from within the client
program.  The resulting executables will still run without Valgrind,
just a little bit more slowly than they otherwise would, but otherwise
unchanged.

When run on Valgrind with --client-perms=yes, Valgrind observes these
macro calls and takes appropriate action.  When run on Valgrind with
--client-perms=no (the default), Valgrind observes these macro calls
but does not take any action as a result.

%package tool-devel
Summary: Header files and libraries for compiling Valgrind tools
Group: Development/Other
Requires: %name-devel = %version-%release

%description tool-devel
The valgrind-tool-devel subpackage contains header files and libraries
needed to compile Valgrind tools separately from the Valgrind core.


%prep
%setup %{?cvsdate:-n %name}

%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1
%patch9 -p1
%patch10 -p1
%patch11 -p1
%patch12 -p1
%patch13 -p1
%patch14 -p1
%patch15 -p1
%patch16 -p1
%patch17 -p1
%patch21 -p1
%patch22 -p1
%patch23 -p1
%patch24 -p1
%patch25 -p1

chmod a+x memcheck/tests/filter_memcpy
touch none/tests/amd64/{avx2-1,fma,bmi}.stderr.exp

%build
#%{?cvsdate:./autogen.sh}
autoreconf -vi

# Filter out some flags that cause lots of valgrind test failures.
# Also filter away -O2, valgrind adds it wherever suitable, but
# not for tests which should be -O0, as they aren't meant to be
# compiled with -O2 unless explicitely requested.
%define optflags_optimization %nil

# No need to buildreq gdb just to find out the executable.
export ac_cv_path_GDB=%_bindir/gdb

# Currently there is no usable MPI implementation in Sisyphus.
%configure \
	--without-mpicc

%make_build

%install
%makeinstall_std

mv %buildroot%_docdir/%name{,-%version}
install -m644 -p AUTHORS FAQ.txt NEWS \
	%buildroot%_docdir/%name-%version/

# Most of ELF objects should not be stripped - see README_PACKAGERS
%brp_strip_none %_libdir/%name/*

%check
if [ ! -r /proc/self/exe ]; then
	echo '/proc/self/exe is not available, regression test SKIPPED' >&2
	exit
fi
%make_build check ||:

# Ensure there are no unexpected file descriptors open,
# the testsuite otherwise fails.
cat > close_fds.c <<EOF
#include <stdlib.h>
#include <unistd.h>
int main(int argc, char **argv)
{
	int i, j = sysconf(_SC_OPEN_MAX);
	if (j < 0)
		exit(1);
	for (i = 3; i < j; ++i)
		close(i);
	execvp(argv[1], argv + 1);
	return 1;
}
EOF
%__cc %optflags -o close_fds close_fds.c

echo "===============TESTING==================="
./close_fds make regtest ||:
echo "===============END TESTING==============="

%files
%_bindir/*
%_libdir/%name/
%exclude %_libdir/%name/lib*.a
%_docdir/%name-%version/
%exclude %_docdir/%name-%version/valgrind_manual.ps
%_mandir/*/*

%files devel
%dir %_includedir/%name/
%_includedir/%name/valgrind.h
%_includedir/%name/callgrind.h
%_includedir/%name/helgrind.h
%_includedir/%name/memcheck.h

%files tool-devel
%_includedir/%name/
%exclude %_includedir/%name/valgrind.h
%exclude %_includedir/%name/callgrind.h
%exclude %_includedir/%name/helgrind.h
%exclude %_includedir/%name/memcheck.h
%dir %_libdir/%name/
%_libdir/%name/lib*.a
%_pkgconfigdir/%name.pc


%changelog
