%def_disable static
Summary: Varnish is a high-performance HTTP accelerator
Name: varnish
Version: 2.1.5
Release: alt2
License: BSD-like
Group: System/Servers
Packager: Ilya Mashkin <oddity@altlinux.ru>
URL: http://www.varnish-cache.org/
Source0: http://downloads.sourceforge.net/varnish/varnish-%{version}.tar.gz
Source1: varnish.init
Source2: varnishlog.init
Requires: varnish-libs = %{version}-%{release}
Requires: logrotate
Requires(post): /sbin/chkconfig
Requires(preun): /sbin/chkconfig
Requires(preun): /sbin/service

# Varnish actually needs gcc installed to work. It uses the C compiler 
# at runtime to compile the VCL configuration files. This is by design.
Requires: gcc

# Automatically added by buildreq on Fri Oct 03 2008
BuildRequires: gcc-c++ glibc-devel-static groff-base libncurses-devel tcl xsltproc
BuildRequires: libpcre-devel

%description
This is the Varnish high-performance HTTP accelerator. Documentation
wiki and additional information about Varnish is available on the following
web site: http://www.varnish-cache.org/

%package -n varnish-libs
Summary: Libraries for %{name}
Group: System/Libraries

%description -n varnish-libs
Libraries for %{name}.
Varnish is a high-performance HTTP accelerator.

%if_enabled static
%package -n devel-static
Summary: Static libraries for %{name}
Group: System/Libraries

%description -n devel-static
Static libraries for %{name}.
Varnish is a high-performance HTTP accelerator.
%endif # static

%prep
%setup

%build
%__subst 's/\[trunk\]/\[%{version}-%{release}\]/g' configure.ac
%__aclocal
%__libtoolize --copy --force
%__autoheader
%__automake --add-missing --copy --foreign
%__autoconf


%configure %{subst_enable static}

# We have to remove rpath - not allowed in Fedora
# (This problem only visible on 64 bit arches)
sed -i 's|^hardcode_libdir_flag_spec=.*|hardcode_libdir_flag_spec=""|g' libtool
sed -i 's|^runpath_var=LD_RUN_PATH|runpath_var=DIE_RPATH_DIE|g' libtool

%{__make} %{?_smp_mflags}

sed -e ' s/8080/80/g ' etc/default.vcl > redhat/default.vcl

%install
%brp_strip_none
%set_verify_elf_method textrel=relaxed,rpath=strict,unresolved=relaxed

make install DESTDIR=%{buildroot} INSTALL="install -p"

%if_disabled static
find %{buildroot}%{_libdir}/ -name '*.la' -exec rm -f {} ';'

find %{buildroot}%{_libdir}/ -name '*.so' -type l -exec rm -f {} ';'
%endif # statitc

mkdir -p %{buildroot}/var/lib/varnish
mkdir -p %{buildroot}%{_logdir}/varnish

%{__install} -D -m 0644 redhat/default.vcl %{buildroot}%{_sysconfdir}/varnish/default.vcl
%{__install} -D -m 0644 redhat/varnish.sysconfig %{buildroot}%{_sysconfdir}/sysconfig/varnish
%{__install} -D -m 0644 redhat/varnish.logrotate %{buildroot}%{_sysconfdir}/logrotate.d/varnish
%{__install} -D -m 0755 %SOURCE1 %{buildroot}%{_initdir}/varnish
%{__install} -D -m 0755 %SOURCE2 %{buildroot}%{_initdir}/varnishlog

%files
%{_libdir}/pkgconfig/varnishapi.pc
%{_sbindir}/*
%{_bindir}/*
%{_var}/lib/varnish
%{_logdir}/varnish
%{_includedir}/varnish/*.h
%{_man1dir}/*.1*
%{_man7dir}/*.7*
%doc INSTALL LICENSE README redhat/README.redhat redhat/default.vcl ChangeLog 
%dir %{_sysconfdir}/varnish/
%config(noreplace) %{_sysconfdir}/varnish/default.vcl
%config(noreplace) %{_sysconfdir}/sysconfig/varnish
%config(noreplace) %{_sysconfdir}/logrotate.d/varnish
%config(noreplace) %{_initdir}/varnish
%config(noreplace) %{_initdir}/varnishlog

%files -n varnish-libs
%{_libdir}/*.so.*
%doc LICENSE

%if_enabled static
%files -n devel-static
%{_libdir}/*.so
%{libdir}/*.la
%endif # static

%post
%post_service varnish
%post_service varnishlog

%pre
%_sbindir/groupadd -r -f %name 2>/dev/null ||:
%_sbindir/useradd -r -n -g %name -d %_var/run/%name \
 -s /dev/null -c 'Varnish HTTP accelerator' %name 2>/dev/null ||:

%preun
%preun_service varnish
%preun_service varnishlog

%changelog
