# vim: set ft=spec: -*- rpm-spec -*-
# vim600: set fdm=marker:

# {{{ Perl/Python/Ruby/Tcl/MzScheme support
%def_enable perlinterp
%def_enable pythoninterp
%def_disable python3interp
%def_enable rubyinterp
%def_enable tclinterp
%def_disable mzschemeinterp
%def_enable luainterp
# }}}
# {{{ enable/disable logic
%def_enable gpm

%def_enable selinux

%def_enable minimal

%def_enable devel

%def_disable gui_athena
%def_enable gui_gnome2
%def_enable gui_gtk2
%def_disable gui_motif
%def_enable gui_neXtaw

%global gui %nil
%if_enabled gui_athena
%global gui %gui athena
%endif
%if_enabled gui_gnome2
%global gui %gui gnome2
%endif
%if_enabled gui_gtk2
%global gui %gui gtk2
%endif
%if_enabled gui_motif
%global gui %gui motif
%endif
%if_enabled gui_neXtaw
%global gui %gui neXtaw
%endif

%if "%gui" != "%nil"
%force_enable gui_any
%endif

# Can't move tests to %%check section since multiple targets are built
%if %{disabled check} || %{without check}
%global make_test %nil
%else
%global make_test %make -C src testclean test
%endif
# }}}

# vimspell interface version
%define vimspell_version	50.1

Name: vim
%define branch 7.3
Version: %branch.353
Release: alt2
Epoch: 4

Summary: VIsual editor iMproved
License: Charityware
Group: Editors
Url: http://www.vim.org

%add_findreq_skiplist %_datadir/vim/*

# Avoid rm -rf $DOCDIR...
%define _customdocdir %_defaultdocdir/%name-common-%version

# {{{ RPM macros
%define vim_runtime_dir %_datadir/vim/vimfiles
# }}}

Source: %name-%branch.tar
Patch: %name-%version-%release.patch

# {{{ BuildRequires
# Automatically added by buildreq on Mon Apr 28 2003 and filtered by raorn
# Common requires
BuildPreReq: alternatives >= 0.2.0-alt0.7
BuildPreReq: iconv
BuildPreReq: libacl-devel
BuildPreReq: libattr-devel
%if_enabled gpm
BuildPreReq: libgpm-devel
%endif
%if_enabled selinux
BuildPreReq: libselinux-devel
%endif
BuildPreReq: libtinfo-devel
BuildPreReq: unzip
# man commandline check
BuildPreReq: man
# ctags commandline check
BuildPreReq: ctags
# Common X11
%if_enabled gui_any
BuildPreReq: libICE-devel libSM-devel libX11-devel libXdmcp-devel libXpm-devel libXt-devel xorg-proto-devel
%endif
# Athena
%if_enabled gui_athena
BuildPreReq: libXaw-devel libXext-devel libXmu-devel
%endif
# GNOME2
%if_enabled gui_gnome2
BuildPreReq: ORBit2-devel glib2-devel gnome-vfs2-devel libGConf2-devel libart_lgpl-devel libatk-devel libbonobo2-devel libbonoboui-devel libcairo-devel libgnome-devel libgnomecanvas-devel libgnomeui-devel libgtk+2-devel libpango-devel libpopt-devel libxml2-devel pkg-config zlib-devel
%endif
# gtk+2
%if_enabled gui_gtk2
BuildPreReq: glib2-devel libatk-devel libcairo-devel libgtk+2-devel libpango-devel pkg-config
%endif
# motif
%if_enabled gui_motif
BuildPreReq: libXau-devel libXext-devel libXmu-devel libXp-devel openmotif-devel
%endif
# neXtaw
%if_enabled gui_neXtaw
BuildPreReq: libXext-devel libXmu-devel libneXtaw-devel
%endif
# Perl
%if_enabled perlinterp
BuildPreReq: perl-devel
%endif
# Python
%if_enabled pythoninterp
BuildPreReq: python-devel
BuildConflicts: python-dev < 2.3.4-alt1
BuildConflicts: python-devel-static
%endif
# Python
%if_enabled python3interp
%{error:wtf?}
%endif
# Ruby
%if_enabled rubyinterp
BuildPreReq: libruby-devel >= 1.8.4-alt1
BuildPreReq: ruby >= 1.8
%endif
# Tcl
%if_enabled tclinterp
BuildPreReq: tcl-devel >= 8.4.0-alt1
%endif
# MzScheme
%if_enabled mzschemeinterp
BuildPreReq: plt2
%endif
%if_enabled luainterp
BuildPreReq: liblua5-devel
%endif
# }}}

# {{{ Description
%description
VIM (VIsual editor iMproved) is an updated and improved version of the vi
editor.  Vi was the first real screen-based editor for UNIX, and is still
very popular.  VIM improves on vi by adding new features: multiple windows,
multi-level undo, block highlighting and more.  The vim-common package
contains files which every VIM binary will need in order to run.
# }}}

# {{{ vim-common
%package common
Summary: The common files needed by any version of the VIM editor
Group: Editors
BuildArch: noarch
PreReq: coreutils
PreReq: %name
PreReq: %_bindir/vim
Requires: mktemp >= 1:1.3.1
Requires: xxd = %epoch:%version-%release
Provides: vimspell-interface = %vimspell_version
Provides: %_datadir/vim/vimfiles/after/compiler
Provides: %_datadir/vim/vimfiles/after/ftplugin
Provides: %_datadir/vim/vimfiles/after/indent
Provides: %_datadir/vim/vimfiles/after/plugin
Provides: %_datadir/vim/vimfiles/after/syntax
Provides: %_datadir/vim/vimfiles/after
Provides: %_datadir/vim/vimfiles/autoload
Provides: %_datadir/vim/vimfiles/colors
Provides: %_datadir/vim/vimfiles/compiler
Provides: %_datadir/vim/vimfiles/doc
Provides: %_datadir/vim/vimfiles/ftdetect
Provides: %_datadir/vim/vimfiles/ftplugin
Provides: %_datadir/vim/vimfiles/indent
Provides: %_datadir/vim/vimfiles/keymap
Provides: %_datadir/vim/vimfiles/lang
Provides: %_datadir/vim/vimfiles/plugin
Provides: %_datadir/vim/vimfiles/print
Provides: %_datadir/vim/vimfiles/syntax
Provides: %_datadir/vim/vimfiles
Provides: %_datadir/vim/spell
Provides: %_datadir/vim
# Bundled plugins:
Provides: vim-plugin-getscript = 33.vim
Obsoletes: vim-plugin-getscript < 33.vim
Provides: vim-plugin-netrw = 143.vim
Obsoletes: vim-plugin-netrw < 143.vim
Provides: vim-plugin-tar-ftplugin = 27.vim
Obsoletes: vim-plugin-tar-ftplugin < 27.vim
Provides: vim-plugin-vimball = 34.vim
Obsoletes: vim-plugin-vimball < 34.vim
Provides: vim-plugin-zip-ftplugin = 24.vim
Obsoletes: vim-plugin-zip-ftplugin < 24.vim
Provides: vim-plugin-vimruby = 20070302.vim
Obsoletes: vim-plugin-vimruby < 20070302.vim

%description common
VIM (VIsual editor iMproved) is an updated and improved version of the vi
editor.  Vi was the first real screen-based editor for UNIX, and is still
very popular.  VIM improves on vi by adding new features: multiple windows,
multi-level undo, block highlighting and more.  The vim-common package
contains files which every VIM binary will need in order to run.

If you are installing any version of the VIM editor, you'll also need to
the vim-common package installed.
# }}}
# {{{ vimtutor
%package -n vimtutor
Summary: VIM tutor
Group: Editors
BuildArch: noarch
PreReq: %name-common = %epoch:%version-%release
Requires: %_bindir/vim

%description -n vimtutor
VIM (VIsual editor iMproved) is an updated and improved version of the vi
editor.  Vi was the first real screen-based editor for UNIX, and is still
very popular.  VIM improves on vi by adding new features: multiple windows,
multi-level undo, block highlighting and more.  The vim-common package
contains files which every VIM binary will need in order to run.

This package contains VIM tutor.
# }}}
# {{{ vim-spell
%package spell-source
Summary: vimspell dictionary sources
Group: Development/Other
BuildArch: noarch
Requires: rpm-build-vim = %epoch:%version-%release

%description spell-source
VIM (VIsual editor iMproved) is an updated and improved version of the vi
editor.  Vi was the first real screen-based editor for UNIX, and is still
very popular.  VIM improves on vi by adding new features: multiple windows,
multi-level undo, block highlighting and more.  The vim-common package
contains files which every VIM binary will need in order to run.

This package contains vimspell sources for building additional dictionaries.
# }}}
# {{{ vim-minimal
%package minimal
Summary: A minimal version of the VIM editor
Group: Editors
PreReq: coreutils
Provides: vi = %epoch:%version-%release
Provides: /bin/vi

%description minimal
VIM (VIsual editor iMproved) is an updated and improved version of the vi
editor.  Vi was the first real screen-based editor for UNIX, and is still
very popular.  VIM improves on vi by adding new features: multiple windows,
multi-level undo, block highlighting and more.  The vim-minimal package
includes a minimal version of VIM, which is installed into /bin/vi for use
when only the root partition is present.

Just install it because you'll need it.
# }}}
# {{{ vim-enhanced
%package enhanced
Summary: A terminal-based, full-featured version of the VIM editor
Group: Editors
PreReq: coreutils
PreReq: alternatives >= 0.2.0-alt0.7
Requires: %name-common = %epoch:%version-%release
Provides: %name = %epoch:%version-%release
Provides: %_bindir/vim
Obsoletes: vim-color

%description enhanced
VIM (VIsual editor iMproved) is an updated and improved version of the vi
editor.  Vi was the first real screen-based editor for UNIX, and is still
very popular.  VIM improves on vi by adding new features: multiple windows,
multi-level undo, block highlighting and more.  The vim-enhanced package
contains a version of VIM with extra, recently introduced features like
Python and Perl interpreters.

Install the vim-enhanced package if you'd like to use a full-featured
VIM, but you don't want to use GUI version of VIM.
You'll also need to install the vim-common package.
# }}}
# {{{ vim-console
%package console
Summary: A terminal-based, full-featured version of the VIM editor
Group: Editors
PreReq: coreutils
PreReq: alternatives >= 0.2.0-alt0.7
Requires: %name-common = %epoch:%version-%release
Provides: %name = %epoch:%version-%release
Provides: %_bindir/vim
Obsoletes: vim-color

%description console
VIM (VIsual editor iMproved) is an updated and improved version of the vi
editor.  Vi was the first real screen-based editor for UNIX, and is still
very popular.  VIM improves on vi by adding new features: multiple windows,
multi-level undo, block highlighting and more.  The vim-console package
contains a version of VIM with extra, recently introduced features like
Python and Perl interpreters.

Install the vim-console package if you'd like to use a full-featured
VIM, but you don't use X11 or don't want to use GUI version of VIM nor want
to use perl/python/ruby/tcl interface.  You'll also need to install the
vim-common package.
# }}}
# {{{ vim-X11
%package X11
Summary: A full version of VIM editor, including GUI for the X Window System
Group: Editors
BuildArch: noarch
PreReq: coreutils
PreReq: alternatives >= 0.2.0-alt0.7
PreReq: %name-X11-gui
Requires: menu >= 2.1.25-alt4
Requires: %name-common = %epoch:%version-%release
Provides: %name = %epoch:%version-%release
Provides: %_bindir/vim
Obsoletes: vim-color

%description X11
VIM (VIsual editor iMproved) is an updated and improved version of the vi
editor.  Vi was the first real screen-based editor for UNIX, and is still
very popular.  VIM improves on vi by adding new features: multiple windows,
multi-level undo, block highlighting and more.

VIM-X11 is a full version of the VIM editor, including the GUI. You can run it
either in terminal or within the X Window System. This package supersedes
vim-ehnanced package.

Install the vim-X11 package if you'd like to use a full-featured VIM with both
terminal and X11 interface.  You'll also need to install the vim-common
package.
# }}}
# {{{ vim-X11-athena
%package X11-athena
Summary: A full version of VIM editor, including Xaw GUI for the X Window System
Group: Editors
PreReq: coreutils
PreReq: alternatives >= 0.2.0-alt0.7
Requires: %name-X11 = %epoch:%version-%release
Provides: %name-X11-gui = %epoch:%version-%release
Provides: %_bindir/vim-X11
Obsoletes: vim-color

%description X11-athena
VIM (VIsual editor iMproved) is an updated and improved version of the vi
editor.  Vi was the first real screen-based editor for UNIX, and is still
very popular.  VIM improves on vi by adding new features: multiple windows,
multi-level undo, block highlighting and more.

VIM-X11 is a full version of the VIM editor, including the GUI. You can run it
either in terminal or within the X Window System. This package supersedes
vim-ehnanced package.

Install the vim-X11 package if you'd like to use a full-featured VIM with both
terminal and X11 Xaw interface.  You'll also need to install the vim-X11
package.
# }}}
# {{{ vim-X11-gnome2
%package X11-gnome2
Summary: A full version of VIM editor, including GNOME GUI for the X Window System
Group: Editors
PreReq: coreutils
PreReq: alternatives >= 0.2.0-alt0.7
Requires: %name-X11 = %epoch:%version-%release
Provides: %name-X11-gui = %epoch:%version-%release
Provides: %_bindir/vim-X11
Obsoletes: vim-color

%description X11-gnome2
VIM (VIsual editor iMproved) is an updated and improved version of the vi
editor.  Vi was the first real screen-based editor for UNIX, and is still
very popular.  VIM improves on vi by adding new features: multiple windows,
multi-level undo, block highlighting and more.

VIM-X11 is a full version of the VIM editor, including the GUI. You can run it
either in terminal or within the X Window System. This package supersedes
vim-ehnanced package.

Install the vim-X11 package if you'd like to use a full-featured VIM with both
terminal and X11 GNOME interface.  You'll also need to install the vim-X11
package.
# }}}
# {{{ vim-X11-gtk2
%package X11-gtk2
Summary: A full version of VIM editor, including gtk+2 GUI for the X Window System
Group: Editors
PreReq: coreutils
PreReq: alternatives >= 0.2.0-alt0.7
Requires: libgtk+2 >= 2.0
Requires: %name-X11 = %epoch:%version-%release
Provides: %name-X11-gui = %epoch:%version-%release
Provides: %_bindir/vim-X11
Obsoletes: vim-color

%description X11-gtk2
VIM (VIsual editor iMproved) is an updated and improved version of the vi
editor.  Vi was the first real screen-based editor for UNIX, and is still
very popular.  VIM improves on vi by adding new features: multiple windows,
multi-level undo, block highlighting and more.

VIM-X11 is a full version of the VIM editor, including the GUI. You can run it
either in terminal or within the X Window System. This package supersedes
vim-ehnanced package.

Install the vim-X11 package if you'd like to use a full-featured VIM with both
terminal and X11 gtk+2 interface.  You'll also need to install the vim-X11
package.
# }}}
# {{{ vim-X11-motif
%package X11-motif
Summary: A full version of VIM editor, including Motif GUI for the X Window System
Group: Editors
PreReq: coreutils
PreReq: alternatives >= 0.2.0-alt0.7
Requires: %name-X11 = %epoch:%version-%release
Provides: %name-X11-gui = %epoch:%version-%release
Provides: %_bindir/vim-X11
Obsoletes: vim-color

%description X11-motif
VIM (VIsual editor iMproved) is an updated and improved version of the vi
editor.  Vi was the first real screen-based editor for UNIX, and is still
very popular.  VIM improves on vi by adding new features: multiple windows,
multi-level undo, block highlighting and more.

VIM-X11 is a full version of the VIM editor, including the GUI. You can run it
either in terminal or within the X Window System. This package supersedes
vim-ehnanced package.

Install the vim-X11 package if you'd like to use a full-featured VIM with both
terminal and X11 Motif interface.  You'll also need to install the vim-X11
package.
# }}}
# {{{ vim-X11-neXtaw
%package X11-neXtaw
Summary: A full version of VIM editor, including neXtaw GUI for the X Window System
Group: Editors
PreReq: coreutils
PreReq: alternatives >= 0.2.0-alt0.7
Requires: %name-X11 = %epoch:%version-%release
Provides: %name-X11-gui = %epoch:%version-%release
Provides: %_bindir/vim-X11
Obsoletes: vim-color

%description X11-neXtaw
VIM (VIsual editor iMproved) is an updated and improved version of the vi
editor.  Vi was the first real screen-based editor for UNIX, and is still
very popular.  VIM improves on vi by adding new features: multiple windows,
multi-level undo, block highlighting and more.

VIM-X11 is a full version of the VIM editor, including the GUI. You can run it
either in terminal or within the X Window System. This package supersedes
vim-ehnanced package.

Install the vim-X11 package if you'd like to use a full-featured VIM with both
terminal and X11 neXtaw interface.  You'll also need to install the vim-X11
package.
# }}}
# {{{ vim-devel
%package -n rpm-build-vim
Summary: RPM macros needed to build additional VIM plugin packages
Group: Development/Other
BuildArch: noarch
#Conflicts: %name-common < %epoch:%version-%release
#Conflicts: %name-common > %epoch:%version-%release
Provides: %name-devel = %epoch:%version-%release
Obsoletes: %name-devel < 4:7.2

%description -n rpm-build-vim
VIM (VIsual editor iMproved) is an updated and improved version of the vi
editor.  Vi was the first real screen-based editor for UNIX, and is still
very popular.  VIM improves on vi by adding new features: multiple windows,
multi-level undo, block highlighting and more.  The vim-common package
contains files which every VIM binary will need in order to run.

This package contains RPM macros needed to build additional VIM plugin
packages.
# }}}
# {{{ xxd
%package -n xxd
Summary: Make a hexdump or do the reverse
Group: File tools
Conflicts: %name-common < %epoch:%version-%release
Conflicts: %name-common > %epoch:%version-%release

%description -n xxd
xxd creates a hex dump of a given file or standard input. It can
also convert a hex dump back to its original binary form. Like
uuencode(1) and uudecode(1) it allows the transmission of binary
data in a `mail-safe' ASCII representation, but has the
advantage of decoding to standard output. Moreover, it can be
used to perform binary file patching.
# }}}

# {{{ prep section
%prep
%setup -n vim-%branch
%patch -p1
touch src/auto/*

# Compressed documentation
#__subst 's|^.*#[[:blank:]]*define[[:blank:]]\+DFLT_HELPFILE[[:blank:]]\+.*$|#define DFLT_HELPFILE "$VIMRUNTIME/doc/help.txt.gz"|' src/feature.h

VIMSPELLVERSION=`grep '^[[:blank:]]*#define[[:blank:]]\+VIMSPELLVERSION[[:blank:]]\+[[:digit:]]\+[[:blank:]]*$' src/spell.c | sed -e 's/^[[:blank:]]*#define[[:blank:]]\+VIMSPELLVERSION[[:blank:]]\+\([[:digit:]]\+\)[[:blank:]]*$/\1/'`
VIMSUGVERSION=`grep '^[[:blank:]]*#define[[:blank:]]\+VIMSUGVERSION[[:blank:]]\+[[:digit:]]\+[[:blank:]]*$' src/spell.c | sed -e 's/^[[:blank:]]*#define[[:blank:]]\+VIMSUGVERSION[[:blank:]]\+\([[:digit:]]\+\)[[:blank:]]*$/\1/'`
if [ "$VIMSPELLVERSION.$VIMSUGVERSION" != "%vimspell_version" ]; then
  echo "FATAL: %%vimspell_version (%vimspell_version) does not match source ($VIMSPELLVERSION.$VIMSUGVERSION)"
  exit 1
fi
# }}}
# {{{ build section
%build
# autoreconf
%make -C src autoconf
# SMP-incompatible
%define __nprocs 1
PLTHOME=%_libdir/plt2; export PLTHOME
# {{{ Build CFLAGS
# Load (g)vimrc file(s) from %_sysconfdir
%add_optflags -DSYS_VIMRC_FILE=\\\"%_sysconfdir/vim/vimrc\\\"
%add_optflags -DSYS_GVIMRC_FILE=\\\"%_sysconfdir/vim/gvimrc\\\"
# Largefile support
%add_optflags -D_LARGEFILE_SOURCE -D_FILE_OFFSET_BITS=64 -D_LARGEFILE64_SOURCE=1
# }}}
# {{{ minimal
%if_enabled minimal
%configure \
	--exec-prefix=/ \
	--with-features=tiny \
	--with-x=no \
	--enable-gui=no \
	--disable-gpm \
	--disable-rpath \
	%{subst_enable selinux} \
	--with-tlib=tinfo \
	--with-compiledby="%packager" \
	#

%make_build -C src clean all
%make_test
mv src/vim vim-minimal
%endif
# }}}

common_opts="--with-features=huge \
	--disable-rpath \
	--enable-cscope \
	%{subst_enable gpm} \
	--enable-multibyte \
	%{subst_enable selinux} \
	--with-global-runtime=%vim_runtime_dir \
	--with-tlib=tinfo"

interp_opts="%{subst_enable perlinterp} \
	%{subst_enable pythoninterp} \
	%{subst_enable rubyinterp} \
	%{subst_enable tclinterp} \
	%{subst_enable mzschemeinterp} \
	%{subst_enable luainterp}"

# {{{ full without GUI and interpreters
%configure \
	$common_opts \
	--with-features=big \
	--disable-perlinterp \
	--disable-pythoninterp \
	--disable-rubyinterp \
	--disable-tclinterp \
	--disable-mzschemeinterp \
	--with-x=no \
	--disable-xsmp \
	--enable-gui=no \
	--with-compiledby="%packager" \
	#
%make_build -C src clean all
%make_test
mv src/vim vim-console
# }}}

# {{{ full without GUI
%configure \
	$common_opts \
	$interp_opts \
	--with-x \
	--enable-gui=no \
	--disable-xsmp \
	--with-compiledby="%packager" \
	#
%make_build -C src clean all
%make_test
mv src/vim vim-enhanced
# }}}

# {{{ full version with GUI
%if_enabled gui_any
for gui in %{gui}; do
%configure \
	$common_opts \
	$interp_opts \
	--with-x=yes \
	--enable-gui="$gui" \
	--enable-multibyte \
	--enable-xim \
	--enable-fontset \
	--enable-xsmp \
	--with-compiledby="%packager" \
	#
%make_build -C src clean all
%make_test
mv src/vim "vim-$gui"
done
%endif
# }}}
# STFU make install
touch src/vim
# }}}
# {{{ install section
%install
mkdir -p %buildroot{%_altdir,%_sysconfdir/vim,/bin,%_bindir,%_man1dir,%_datadir/vim/{ftdetect,langmap,langrc},%_customdocdir,%_usrsrc/vimspell,%_rpmmacrosdir}
# {{{2 make install
%makeinstall_std -C src

# Where is our baby?..
rm %buildroot%_bindir/vim

%if_enabled minimal
# Install the minimal version into the /bin
install -p -m755 vim-minimal %buildroot/bin/vi
%endif

# ... Here it is!
for ui in console enhanced %{gui}; do
	install -p -m755 "vim-$ui" "%buildroot%_bindir/vim-$ui"
done
%if_enabled gui_any
for ui in %{gui}; do
	ln -s "vim-$ui" "%buildroot%_bindir/gvim-$ui"
done
%endif
# 2}}}
# {{{2 Set up links for minimal and gui versions
%if_enabled minimal
for i in ex rvi rview ; do
	ln -s -f vi "%buildroot/bin/$i"
done
%endif

%if_enabled gui_any
for i in evim eview gview gvim gvimdiff rgview rgvim ; do
	ln -s -f vim-X11 "%buildroot%_bindir/$i"
done
%endif

# 2}}}
# {{{2 Install documentation
ln -s -f ../../vim/doc %buildroot%_customdocdir/doc
# 2}}}

install -p -m644 vimrc.system %buildroot%_sysconfdir/vim/vimrc
install -p -m644 gvimrc.system %buildroot%_sysconfdir/vim/gvimrc
install -p -m644 vimrc_hebrew %buildroot%_datadir/vim
# ALT-specific filetype
install -p -m644 runtime/ftdetect/* %buildroot%_datadir/vim/ftdetect/

pushd %buildroot%_datadir/vim/tools
    # i need to make a choice :(.
    subst 's|#!/usr/bin/nawk|#!/usr/bin/gawk|' mve.awk
    subst 's,#!/bin/csh.*.*,#!/bin/sh,' vim132
    chmod a-x vimspell* ref*
popd

# {{{2 post-install cleanup
find %buildroot%_datadir/vim \( -name '*.info' -o -name 'README.txt' \) -print0 |
	xargs -r0 rm -f --

for i in autoload colors compiler ftplugin indent keymap lang macros plugin spell syntax tools tutor; do
    cp -f runtime/$i/README.txt README_$i.txt
done
#__cp -f official-patches/README README_patches.txt
# 2}}}

# {{{2 Create RPM macros and runtime dirs in buildroot
mkdir -p %buildroot%vim_runtime_dir
%if_enabled devel
cat <<EOF >%buildroot%_rpmmacrosdir/vim
# Global runtime
%%vim_dir	%_datadir/vim

# Spell files are in vim_dir
%%vim_spell_dir	%%vim_dir/spell
%%vim_spell_source_dir	%_usrsrc/vimspell
%%mkvimspell(L:a)	%%{!-L:%%{!-a:%%{error:mkvimspell: neither language nor -a is specified} }}%%{-L:env LANG="%%{-L*}"} %_bindir/vim-console -E -X -N -n -i NONE -u NONE -U NONE -c 'mkspell! %%{-a:-ascii} %%*' -c q
# VIMSPELLVERSION.VIMSUGVERSION
%%vimspell_version	%vimspell_version

%%vim_runtime_dir	%%vim_dir/vimfiles
# Additional dirs in global runtime
EOF
%endif
for d in after autoload colors compiler doc ftdetect ftplugin indent keymap lang plugin print syntax ; do
    mkdir -p %buildroot%vim_runtime_dir/$d
%if_enabled devel
    cat <<EOF >>%buildroot%_rpmmacrosdir/vim
%%vim_${d}_dir	%%vim_runtime_dir/$d
EOF
%endif
done
%if_enabled devel
cat <<EOF >>%buildroot%_rpmmacrosdir/vim

# "after" dirs in global runtime
EOF
%endif
for d in compiler ftplugin indent plugin syntax ; do
    mkdir -p %buildroot%vim_runtime_dir/after/$d
%if_enabled devel
    cat <<EOF >>%buildroot%_rpmmacrosdir/vim
%%vim_after_${d}_dir	%%vim_after_dir/$d
EOF
%endif
done
%if_enabled devel
cat <<EOF >>%buildroot%_rpmmacrosdir/vim

%%vim_script_url() http://www.vim.org/scripts/script.php?script_id=%%1%%nil

# post-install commands (obsoleted by filetrigger)
%%update_vimhelp	%%{warning %%%%update_vimhelp is obsolete}
%%clean_vimhelp		%%{warning %%%%clean_vimhelp is obsolete}
EOF
%endif
# 2}}}
# {{{2 update-vimhelp script
cat <<EOF >%buildroot%_bindir/update-vimhelp
#! /bin/sh

VIM=%_bindir/vim
DOCDIR=

[ -x "\$VIM" ] || exit 1
[ -z "\$RPM_INSTALL_NAME" ] || exit 0

if [ -n "\$1" ]; then
  if [ -d "\$1" -a -w "\$1" ]; then
    DOCDIR="\$1"
  fi
else
  if [ -d %vim_runtime_dir/doc -a -w %vim_runtime_dir/doc ]; then
    DOCDIR="%vim_runtime_dir/doc"
  elif [ -d "\$HOME/.vim/doc" -a -w "\$HOME/.vim/doc" ]; then
    DOCDIR="\$HOME/.vim/doc"
  fi
fi

[ -n "\$DOCDIR" ] || exit 1

echo ":helptags \$DOCDIR" | \$VIM -E -s -X -N -n -i NONE -u NONE -U NONE ||:
EOF

chmod 755 %buildroot%_bindir/update-vimhelp
# 2}}}
# {{{2 Filetrigger
cat <<EOF >%buildroot%_rpmlibdir/vim.filetrigger
#!/bin/sh -e

grep -qs '^%vim_runtime_dir/doc/' && update-vimhelp ||:
EOF

chmod 755 %buildroot%_rpmlibdir/vim.filetrigger
# 2}}}
# {{{2 files.req
cat <<EOF >%buildroot%_rpmlibdir/vim-files.req.list
%_datadir/vim/vimfiles/after/compiler	vim-common
%_datadir/vim/vimfiles/after/ftplugin	vim-common
%_datadir/vim/vimfiles/after/indent	vim-common
%_datadir/vim/vimfiles/after/plugin	vim-common
%_datadir/vim/vimfiles/after/syntax	vim-common
%_datadir/vim/vimfiles/after	vim-common
%_datadir/vim/vimfiles/autoload	vim-common
%_datadir/vim/vimfiles/colors	vim-common
%_datadir/vim/vimfiles/compiler	vim-common
%_datadir/vim/vimfiles/doc	vim-common
%_datadir/vim/vimfiles/ftdetect	vim-common
%_datadir/vim/vimfiles/ftplugin	vim-common
%_datadir/vim/vimfiles/indent	vim-common
%_datadir/vim/vimfiles/keymap	vim-common
%_datadir/vim/vimfiles/lang	vim-common
%_datadir/vim/vimfiles/plugin	vim-common
%_datadir/vim/vimfiles/print	vim-common
%_datadir/vim/vimfiles/syntax	vim-common
%_datadir/vim/vimfiles	vim-common
%_datadir/vim/spell	vim-common
%_datadir/vim	vim-common
EOF
# 2}}}
# {{{2 spell-source
cp -a runtime/spell/[a-z][a-z] %buildroot%_usrsrc/vimspell
cp -a runtime/spell/[a-z][a-z].vim %buildroot%_usrsrc/vimspell
cp -a runtime/spell/*.aap %buildroot%_usrsrc/vimspell
# 2}}}
# {{{2 Install icons
%if_enabled gui_any
install -p -m644 -D runtime/vim16x16.png %buildroot%_miconsdir/gvim.png
install -p -m644 -D runtime/vim32x32.png %buildroot%_niconsdir/gvim.png
install -p -m644 -D runtime/vim48x48.png %buildroot%_liconsdir/gvim.png
%endif
# 2}}}
# {{{2 Install menu
%if_enabled gui_any
install -p -m644 -D gvim.desktop %buildroot%_desktopdir/gvim.desktop
%endif
# 2}}}
# {{{2 Install alternatives files
install -p -m644 alternatives/vim-enhanced %buildroot%_altdir/vim-enhanced
install -p -m644 alternatives/vim-console %buildroot%_altdir/vim-console
%if_enabled gui_any
install -p -m644 alternatives/vim-X11 %buildroot%_altdir/vim-X11

 %if_enabled gui_athena
install -p -m644 alternatives/vim-X11-athena %buildroot%_altdir/vim-X11-athena
 %endif
 %if_enabled gui_gnome2
install -p -m644 alternatives/vim-X11-gnome2 %buildroot%_altdir/vim-X11-gnome2
 %endif
 %if_enabled gui_gtk2
install -p -m644 alternatives/vim-X11-gtk2 %buildroot%_altdir/vim-X11-gtk2
 %endif
 %if_enabled gui_motif
install -p -m644 alternatives/vim-X11-motif %buildroot%_altdir/vim-X11-motif
 %endif
 %if_enabled gui_neXtaw
install -p -m644 alternatives/vim-X11-neXtaw %buildroot%_altdir/vim-X11-neXtaw
 %endif
%endif
# 2}}}
# {{{2 Language-specific parts
%find_lang --with-man --output vim.lang /vim /ex /rview /rvim /view /vimdiff
%find_lang --with-man --output xxd.lang /xxd
%find_lang --with-man --output vimtutor.lang --custom-file-script 's:\(%_datadir/vim/tutor/tutor\)\(\.\([a-z][a-z]\)\(\..*\)\?\)$:%%lang(\3) \1\2:; s:^\([^%%].*\)::; s:%%lang(en) ::;' /vimtutor
%find_lang --with-man --output vim-X11.lang /evim /eview /gvim /gview /gvimdiff /rgvim /rgview
install -p -m644 runtime/langrc/* %buildroot%_datadir/vim/langrc
install -p -m644 runtime/langmap/*.vim %buildroot%_datadir/vim/langmap

# 2}}}
# }}}

# {{{ triggers
%if_enabled minimal
%triggerpostun minimal -- vim-minimal < 6.0.118
[ $2 -gt 0 ] || exit 0
[ -e %_bindir/vi -a -h %_bindir/vi ] && rm -f %_bindir/vi ||:
%endif
# }}}
# {{{ pre/post install scripts
%pre common
if [ -L "%_datadir/vim/doc" ]; then
  d=$(realpath "%_datadir/vim/doc")
  rm -f -- "%_datadir/vim/doc"
  mv -f -- "$d" "%_datadir/vim/doc"
fi
# }}}

# {{{ vim-common files
%files common -f vim.lang
# Note to self: NEVER try to use %%doc in subpackages
%doc README*.txt runtime/gvimrc_example.vim
%doc runtime/termcap runtime/vimrc_example.vim vimrc_hebrew
%doc README.ALT-ru_RU.KOI8-R

%dir %_sysconfdir/vim
%config(noreplace) %_sysconfdir/vim/vimrc
%config(noreplace) %_sysconfdir/vim/gvimrc
# {{{2 $VIMRUNTIME
%dir %_datadir/vim
%_datadir/vim/autoload
%_datadir/vim/colors
%_datadir/vim/compiler
%dir %_datadir/vim/doc
%doc %_datadir/vim/doc/*.txt
%doc %_datadir/vim/doc/tags
%_datadir/vim/ftdetect
%_datadir/vim/ftplugin
%_datadir/vim/indent
%_datadir/vim/keymap
%_datadir/vim/lang
%_datadir/vim/langmap
%_datadir/vim/langrc
%_datadir/vim/macros
%_datadir/vim/plugin
%_datadir/vim/print
%dir %_datadir/vim/spell
%_datadir/vim/spell/cleanadd.vim
%_datadir/vim/spell/fixdup.vim
%_datadir/vim/syntax
%_datadir/vim/tools
%_datadir/vim/vimfiles
%_datadir/vim/*.vim
%_datadir/vim/vimrc_hebrew
# 2}}}
%_bindir/ex
%_bindir/view
%_bindir/rvim
%_bindir/rview
%_bindir/vimdiff
%_bindir/update-vimhelp
%_rpmlibdir/vim.filetrigger
# }}}
# {{{ vimtutor
%files -n vimtutor -f vimtutor.lang
%_bindir/gvimtutor
%_bindir/vimtutor
%dir %_datadir/vim/tutor
%_datadir/vim/tutor/tutor
%_datadir/vim/tutor/tutor.utf-8
%_datadir/vim/tutor/tutor.vim
%_datadir/vim/tutor/README*
# }}}
# {{{ vim-spell files
%files spell-source
%dir %_usrsrc/vimspell
%_usrsrc/vimspell/[a-z][a-z]
%_usrsrc/vimspell/[a-z][a-z].vim
%_usrsrc/vimspell/*.aap
# }}}
# {{{ vim-devel files
%if_enabled devel
%files -n rpm-build-vim
%_rpmmacrosdir/vim
%_rpmlibdir/vim-files.req.list
%endif
# }}}
# {{{ vim-minimal files
%if_enabled minimal
%files minimal
/bin/*
%endif
# }}}
# {{{ vim-console files
%files console
%_altdir/vim-console
%_bindir/vim-console
# }}}
# {{{ vim-enhanced files
%files enhanced
%_altdir/vim-enhanced
%_bindir/vim-enhanced
# }}}
# {{{ vim-X11 files
%if_enabled gui_any
%files X11 -f vim-X11.lang
%_altdir/vim-X11
%_bindir/evim
%_bindir/eview
%_bindir/gvim
%_bindir/gview
%_bindir/gvimdiff
%_bindir/rgvim
%_bindir/rgview
%_niconsdir/gvim.png
%_miconsdir/gvim.png
%_liconsdir/gvim.png
%_desktopdir/gvim.desktop
%endif
# }}}
# {{{ vim-X11-athena files
%if_enabled gui_athena
%files X11-athena
%_altdir/vim-X11-athena
%_bindir/vim-athena
%_bindir/gvim-athena
%endif
# }}}
# {{{ vim-X11-gnome2 files
%if_enabled gui_gnome2
%files X11-gnome2
%_altdir/vim-X11-gnome2
%_bindir/vim-gnome2
%_bindir/gvim-gnome2
%endif
# }}}
# {{{ vim-X11-gtk2 files
%if_enabled gui_gtk2
%files X11-gtk2
%_altdir/vim-X11-gtk2
%_bindir/vim-gtk2
%_bindir/gvim-gtk2
%endif
# }}}
# {{{ vim-X11-motif files
%if_enabled gui_motif
%files X11-motif
%_altdir/vim-X11-motif
%_bindir/vim-motif
%_bindir/gvim-motif
%endif
# }}}
# {{{ vim-X11-neXtaw files
%if_enabled gui_neXtaw
%files X11-neXtaw
%_altdir/vim-X11-neXtaw
%_bindir/vim-neXtaw
%_bindir/gvim-neXtaw
%endif
# }}}
# {{{ xxd
%files -n xxd -f xxd.lang
%_bindir/xxd
# }}}

# {{{ changelog
%changelog
