%define ver_major 3.8
%define api_ver 3.0
%define panel_api_ver 4.0

%def_enable rdp
%def_enable spice
%def_enable telepathy
%def_enable ssh

Name: vinagre
Version: %ver_major.3
Release: alt1

Summary: VNC client for the GNOME Desktop
License: GPLv2
Group: Networking/Remote access
URL: http://www.gnome.org/projects/vinagre
Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz

Requires: dconf gnome-icon-theme
%{?_enable_rdp:Requires: rdesktop}

BuildPreReq: rpm-build-gnome gnome-common gnome-icon-theme desktop-file-utils
BuildPreReq: intltool >= 0.35 glib2-devel >= 2.28.0
BuildPreReq: libgtk3vnc-devel >= 0.4.3-alt2
BuildRequires: libavahi-gobject-devel libavahi-ui-gtk3-devel libsecret-devel
BuildRequires: yelp-tools itstool xmllint
%{?_enable_ssh:BuildRequires: libvte3-devel libxml2-devel}
%{?_enable_telepathy:BuildRequires: libtelepathy-glib-devel >= 0.11.6 libdbus-glib-devel}
%{?_enable_spice:BuildRequires: libspice-gtk3-devel}
BuildRequires: gcc-c++

%description
This is vinagre, a VNC client for the GNOME Desktop.

%package -n gnome-applets-extra-vinagre
Summary: Vinagre applet for GNOME panel
Group: Graphical desktop/GNOME
Requires: %name = %version-%release

%description -n gnome-applets-extra-vinagre
This package contains panel applet for Vinagre - VNC client for the
GNOME Desktop

%define _libexecdir %gnome_appletsdir

%prep
%setup -q

%build
%autoreconf
# for SSH plugin
export LIBS="$LIBS `pkg-config --libs libxml-2.0`"
export ac_cv_path_RDESKTOP_PROGRAM=%_bindir/rdesktop
%configure \
	--enable-ssh \
	%{subst_enable spice} \
	%{subst_enable ssh} \
	%{subst_enable rdp} \
	%{?_disable_introspection:--enable-introspection=no} \
	--disable-schemas-compile

%make_build

%install
%make_install DESTDIR=%buildroot install

%find_lang --with-gnome %name

rm -rf %buildroot%_datadir/doc

%files -f %name.lang
%_bindir/%name
%_datadir/%name/
%_datadir/telepathy/clients/Vinagre.client
%_datadir/applications/*.desktop
%_datadir/icons/hicolor/*/*/*
%_datadir/mime/packages/vinagre-mime.xml
%_datadir/dbus-1/services/org.freedesktop.Telepathy.Client.Vinagre.service
%config %_datadir/glib-2.0/schemas/org.gnome.Vinagre.gschema.xml
%_datadir/GConf/gsettings/org.gnome.Vinagre.convert
%_man1dir/vinagre.*
%doc AUTHORS NEWS README

%changelog
