%define ver_major 3.8

Name: vino
Version: %ver_major.1
Release: alt2

Summary: A remote desktop system for GNOME
License: GPL
URL: http://www.gnome.org
Group: Networking/Remote access
Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

Source: ftp://ftp.gnome.org/pub/sources/gnome/%name/%ver_major/%name-%version.tar.xz
Patch: vino-3.8.1-fc-allocation.patch

BuildRequires: intltool gnome-common desktop-file-utils NetworkManager-devel
BuildRequires: libgio-devel libgtk+3-devel libsoup-devel libdbus-devel
BuildRequires: libXdamage-devel libXtst-devel libSM-devel xorg-cf-files xorg-inputproto-devel
BuildRequires: libavahi-glib-devel libgcrypt-devel libgnutls-devel libsecret-devel
BuildRequires: libjpeg-devel libnotify-devel >= 0.7 zlib-devel
BuildRequires: libtelepathy-glib-devel >= 0.11.6

%description
Vino is a VNC server for GNOME. It allows remote users to
connect to a running GNOME session using VNC.

%prep
%setup -q
%patch -p1

%build
export LDFLAGS="$LDFLAGS -lgcrypt"
%configure \
	--disable-http-server \
	--disable-schemas-compile
%make_build

%install
%make_install DESTDIR=%buildroot install

%find_lang %name

%files -f %name.lang
%_bindir/*
%_libexecdir/vino-server
%dir %_datadir/vino
%_datadir/vino/*.ui
%_datadir/vino/webservices
%_datadir/applications/*.desktop
%_sysconfdir/xdg/autostart/vino-server.desktop
%_datadir/dbus-1/services/org.freedesktop.Telepathy.Client.Vino.service
%_datadir/telepathy/clients/Vino.client
%config %_datadir/glib-2.0/schemas/*.xml
%_datadir/GConf/gsettings/org.gnome.Vino.convert
%doc AUTHORS NEWS README docs/TODO docs/remote-desktop.txt docs/debugging.txt

%changelog
