Name: violetland
Version: 0.4.3
Release: alt2.1.qa1
Summary: An open source cross-platform game similar to Crimsonland
Group: Games/Arcade
License: GPLv3
Url: http://code.google.com/p/violetland
Source0: http://%name.googlecode.com/files/%name-v%version-src.zip
Patch: violetland-v0.4.3-boost1.51.patch

Requires: %name-data

# Automatically added by buildreq on Tue May 04 2010
BuildRequires: cmake dos2unix gcc-c++ libGL-devel libSDL_image-devel libSDL_mixer-devel libSDL_ttf-devel libXScrnSaver-devel libXau-devel libXcomposite-devel libXcursor-devel libXdmcp-devel libXext-devel libXft-devel libXinerama-devel libXpm-devel libXrandr-devel libXt-devel libXtst-devel libXv-devel libxkbfile-devel unzip ImageMagick-tools boost-devel boost-filesystem-devel

%description
Violetland is an open source cross-platform game similar to Crimsonland.

In this game the player should help a girl by name of Violet to struggle
with hordes of monsters. For this purpose the various weapon, and also the
special abilities of the heroine which are opening with experience can be
used. In game there are elements of RPG in the form of strength-agility-vitality
and derivatives. Also there is an unique feature: dynamic change of day and
night.

%package data
Summary: Data files for Violetland game
Group: Games/Arcade
License: CC-BY-SA
BuildArch: noarch

%description data
Violetland is an open source cross-platform game similar to Crimsonland.

In this game the player should help a girl by name of Violet to struggle
with hordes of monsters. For this purpose the various weapon, and also the
special abilities of the heroine which are opening with experience can be
used. In game there are elements of RPG in the form of strength-agility-vitality
and derivatives. Also there is an unique feature: dynamic change of day and
night.

This package contanis data files required for the game

%prep
%setup -n %name-v%version
dos2unix     README_EN.TXT
%patch -p1
# prevent wrong timestamp unzip
find . -type f -exec touch {} \;

%build
%define warns -Wall -Wno-delete-non-virtual-dtor -Wno-narrowing
install -dm 755 build
pushd build
	#cmake \
	#	-DCMAKE_INSTALL_PREFIX=%buildroot%prefix \
	#	-DDATA_INSTALL_DIR=%_datadir/games/%name \
	#	..
        cmake .. \
            -DCMAKE_SKIP_RPATH:BOOL=yes \
            -DCMAKE_BUILD_TYPE=MinSizeRel \
            -DCMAKE_C_FLAGS:STRING='-pipe %warns -O2' \
            -DCMAKE_CXX_FLAGS:STRING='-pipe %warns -O2' \
            -DCMAKE_INSTALL_PREFIX=%prefix \
            -DDATA_INSTALL_DIR=%_gamesdatadir/%name \
            -DLIB_DESTINATION=lib64 \
            %if "lib64" == "lib64"
            -DLIB_SUFFIX="64" \
            %else
            -DLIB_SUFFIX="" \
            %endif

	%make_build
popd

cat > %name.desktop << EOF
[Desktop Entry]
Type=Application
Name=Violetland
GenericName=Violetland
Categories=Game;ActionGame;
Comment=An open source cross-platform game similar to Crimsonland
Exec=%name
Icon=%name
EOF
#suse_update_desktop_file %name Game ActionGame

for s in 16 24 32 48; do
  convert icon-light.png -resize ${s}x${s} ${s}.png
done

%install
pushd build
	%makeinstall DESTDIR=%buildroot
popd

# icon
install -D icon-light.png %buildroot%_datadir/pixmaps/%name.png
for s in 16 24 32 48; do
  install -D ${s}.png %buildroot%_iconsdir/hicolor/${s}x${s}/apps/%name.png
done

install -D %name.desktop %buildroot%_desktopdir/%name.desktop

#fdupes -s %buildroot

%files
%doc README_*.TXT
%_bindir/%name
%_datadir/pixmaps/%name.png
%_desktopdir/%{name}*.desktop
%_iconsdir/hicolor/*/apps/%name.png

%files data
%dir %_gamesdatadir/%name
%_gamesdatadir/%name/*

%changelog
