%def_disable static

Name: vips
Version: 7.30.7
Release: alt2
%define majorver %(echo %version |cut -d. -f1,2)

Packager: Victor Forsiuk <force@altlinux.org>

Summary: Large image processing library
License: LGPLv2.1
Group: Graphics

Url: http://www.vips.ecs.soton.ac.uk
Source0: %name-%version.tar.gz
Source100: vips.watch

BuildPreReq: libxml2-devel
# Automatically added by buildreq on Sat Oct 08 2011
# optimized out: fontconfig fontconfig-devel glib2-devel ilmbase-devel libX11-devel libfreetype-devel libstdc++-devel libxml2-devel pkg-config python-base python-modules xorg-xproto-devel zlib-devel
BuildRequires: gcc-c++ gtk-doc imake libICE-devel libImageMagick-devel libcfitsio-devel libexif-devel libfftw3-devel libjpeg-devel liblcms-devel libmatio-devel liborc-devel libpango-devel libpng-devel libtiff-devel openexr-devel python-devel xorg-cf-files

%description
VIPS is an image processing library. It is good for very large
images (ie.  larger than the amount of RAM in your machine),
and for working with colour.  It includes a C++ API, complete
man pages, a command-line interface, automatic threading and
an operation database. There are several user interfaces built
on top of VIPS: for example "nip2".

%package -n lib%name
Summary: VIPS development kit
Group: System/Libraries

%package -n lib%name-devel
Summary: VIPS development kit
Group: Development/C
Requires: lib%name = %version-%release
Provides: %name-devel = %version-%release
Obsoletes: %name-devel < 7.16.3-alt3

%package -n lib%name-devel-doc
Summary: VIPS development kit documentation
Group: Development/C
BuildArch: noarch

%if_enabled static
%package -n lib%name-devel-static
Summary: VIPS static libraries
Group: Development/C
Requires: lib%name-devel = %version-%release
Provides: %name-devel-static = %version-%release
Obsoletes: %name-devel-static < 7.16.3-alt3
%endif

%description -n lib%name
Shared libraries for VIPS.

%description -n lib%name-devel
Development libraries and header files for VIPS.

%description -n lib%name-devel-doc
This package contains development documentation for VIPS.

%if_enabled static
%description -n lib%name-devel-static
Static libraries for developing statically linked VIPS applications.
%endif

%prep
%setup

%build
%autoreconf
%configure %{subst_enable static}
%make_build

%install
%makeinstall_std
%find_lang vips7

%files -f vips7.lang
%_bindir/*
%_man1dir/*
%_docdir/vips
%exclude %python_sitelibdir

%files -n lib%name
%_libdir/lib*.so.*

%files -n lib%name-devel
%_includedir/vips/
%_libdir/lib*.so
%_pkgconfigdir/*.pc

%files -n lib%name-devel-doc
%_datadir/gtk-doc/html/*
#_man3dir/*

%if_enabled static
%files -n lib%name-devel-static
%_libdir/lib*.a
%endif

# TODO:
# - OpenSlide, linux/videodev.h
# - package python bindings

%changelog
