%add_python_req_skip guestfs
%define _libexecdir /usr/libexec
%define qemu_user  _libvirt
%define preferred_distros "altlinux,fedora,rhel"
%define kvm_packages "qemu-kvm,qemu-system"
%define libvirt_packages "libvirt"
%define askpass_package "openssh-askpass"

Name: virt-manager
Version: 1.0.0
Release: alt0.M70P.2.git.7dfdbb
Summary: Virtual Machine Manager

Group: Emulators
License: GPLv2+
Url: http://virt-manager.org/
BuildArch: noarch

# git://git.fedorahosted.org/virt-manager.git
Source: %name-%version.tar
Patch: %name-%version-%release.patch

Requires: virt-manager-common = %version-%release
Requires: virt-install = %version-%release
Requires: python-module-pygobject3
Requires: libspice-gtk3-gir
Requires: libgtk3vnc-gir
Requires: libvirt-glib-gir
Requires: python-module-libxml2
Requires: vte3
Requires: dconf
Requires: dbus-tools-gui

BuildRequires: python-devel python-module-distribute
BuildRequires: libgio
BuildRequires: intltool
BuildRequires: /usr/bin/pod2man

%add_python_req_skip virtconv
%add_python_req_skip virtinst
%add_python_req_skip virtcli
%add_python_req_skip virtxml

%description
Virtual Machine Manager provides a graphical tool for administering
virtual machines for KVM, Xen, and QEmu. Start, stop, add or remove
virtual devices, connect to a graphical or serial console, and see
resource usage statistics for existing VMs on local or remote machines.
Uses libvirt as the backend management API.

%package common
Summary: Common files used by the different Virtual Machine Manager interfaces
Group: Emulators
Conflicts: %name < %version-%release

%description common
Common files used by the different virt-manager interfaces, as well as
virt-install related tools.

%package -n virt-install
Summary: Utilities for installing virtual machines
Group: Emulators

Requires: virt-manager-common = %version-%release

Provides: virt-install
Provides: virt-clone
Provides: virt-image
Provides: virt-convert
Provides: virt-xml
Obsoletes: python-module-virtinst

%description -n virt-install
Package includes several command line utilities, including virt-install
(build and install new VMs) and virt-clone (clone an existing virtual
machine).

%prep
%setup
%patch -p1

# Use gtk+ 3.8 for forms
subst 's,requires lib="gtk+" version="3.10",requires lib="gtk+" version="3.8",' ui/*.ui

%build
python setup.py configure \
	--pkgversion="%version" \
	--qemu-user=%qemu_user \
	--libvirt-package-names=%libvirt_packages \
	--kvm-package-names=%kvm_packages \
	--preferred-distros=%preferred_distros \
	--askpass-package-names=%askpass_package

#%%python_build

%install
#%%python_install
python setup.py install --root=%buildroot

%find_lang --with-gnome %name

%files
%_bindir/%name
%_datadir/%name/ui/*.ui
%_datadir/%name/virt-manager
%_datadir/%name/virtManager
%_datadir/%name/icons
%_desktopdir/%name.desktop
%_datadir/appdata/%name.appdata.xml
%_datadir/icons/hicolor/*/apps/%name.png
%_datadir/glib-2.0/schemas/*.gschema.xml
%_man1dir/%name.1*
%doc README COPYING NEWS

%files common -f %name.lang
%dir %_datadir/%name
%_datadir/%name/virtcli
%_datadir/%name/virtconv
%_datadir/%name/virtinst

%files -n virt-install
%_bindir/virt-install
%_bindir/virt-clone
%_bindir/virt-image
%_bindir/virt-convert
%_bindir/virt-xml
%_datadir/%name/virt-install
%_datadir/%name/virt-clone
%_datadir/%name/virt-image
%_datadir/%name/virt-convert
%_datadir/%name/virt-xml
%_man1dir/virt-install.1*
%_man1dir/virt-clone.1*
%_man1dir/virt-convert.1*
%_man1dir/virt-xml.1*
%_man1dir/virt-image.1*
%_man5dir/virt-image.5*

%changelog
