%define oldmodname kernel-source-virtualbox
%define oldmodnamenetflt kernel-source-virtualbox-netfilter
%define oldmodnamenetadp kernel-source-virtualbox-netadaptor
%define oldmodnameadd kernel-source-virtualbox-addition
%define oldmodnameguest kernel-source-virtualbox-guest
%define oldmodnamevfs kernel-source-virtualbox-vfs
%define oldmodnamevideo kernel-source-virtualbox-video

%define modname kernel-source-vboxdrv
%define modnamepci kernel-source-vboxpci
%define modnamenetflt kernel-source-vboxnetflt
%define modnamenetadp kernel-source-vboxnetadp
%define modnameguest kernel-source-vboxguest
%define modnamevfs kernel-source-vboxsf
%define modnamevideo kernel-source-vboxvideo

%define distname VirtualBox
%define distarchive %distname-%{version}_OSE

%def_disable debug

%def_without manual
%def_with additions
%def_with webservice
%def_without java
%def_with vnc
%def_with vde
%def_with libvpx
%def_with python

%ifarch %ix86
%define vbox_platform linux.x86
%endif
%ifarch x86_64
%define vbox_platform linux.amd64
%endif

%if_enabled debug
%define vboxdir %_builddir/%distarchive/out/%vbox_platform/release/bin
%define vboxdbg vbox-debug.sh
%define vboxdbg_file %_builddir/%distarchive/%vboxdbg
%else
%define vboxdir %_libdir/virtualbox
%endif

%if_with webservice
%define vboxwebdir %_localstatedir/vboxwebsrv
%endif

%define vboxdatadir %_datadir/virtualbox
%define vboxadddir %vboxdir/additions

%set_verify_elf_method textrel=relaxed
%add_findprov_lib_path %vboxdir

%define gcc_version 4.5

Name: virtualbox
Version: 4.3.26
Release: alt1.M70P.1

Summary: VM VirtualBox OSE - Virtual Machine for x86 hardware
License: GPL
Group: Emulators
Url: http://www.virtualbox.org/

ExclusiveArch: %ix86 x86_64

Packager: Evgeny Sinelnikov <sin@altlinux.ru>

Source: %distarchive.tar

Source1:	%name.control.in
Source2:	%name.init
Source3:	%name-addition.rules
Source4:	%name.rules
Source5:	60-vboxadd.perms
Source6:	vboxadd-service.sysconfig
Source7:	vboxadd.init
Source8:	vboxadd-service.init
Source9:	vboxweb-service.sysconfig
Source10:	vboxweb-service.init
Source13:	http://download.virtualbox.org/%name/%version/UserManual.pdf
Source15:	os_altlinux.png
Source16:	os_altlinux_64.png
Source17:	http://download.virtualbox.org/%name/%version/%distname.chm
Source20:	http://download.virtualbox.org/%name/%version/SDKRef.pdf
Source21:	%distname-HTML-%{version}_OSE.tar
Source22:	%name.service

%if_enabled debug
Source99:	%vboxdbg.in
%endif

Patch0:		%name-%version-%release.patch

BuildPreReq: dev86 iasl gcc%gcc_version-c++ libstdc++%gcc_version-devel-static
BuildPreReq: libIDL-devel libSDL-devel libpng-devel
BuildPreReq: libXcursor-devel libXext-devel
BuildPreReq: xsltproc
BuildPreReq: rpm-build-kernel
BuildPreReq: libpulseaudio-devel
BuildRequires: libdevmapper-devel
BuildRequires: libxml2-devel libxslt-devel
BuildRequires: libqt4-devel libalsa-devel
BuildRequires: libcap-devel libcurl-devel
BuildRequires: libXmu-devel libGLU-devel
BuildRequires: libXdamage-devel libXcomposite-devel
BuildRequires: xorg-xf86driproto-devel xorg-glproto-devel
BuildRequires: xorg-resourceproto-devel xorg-scrnsaverproto-devel
BuildRequires(pre): xorg-sdk
BuildPreReq: yasm kBuild >= 0.1.9998.r2689
%if_with webservice
BuildRequires: libgsoap-devel-static
%endif
%if_with python
BuildRequires: python-dev
%endif
BuildRequires: libpam-devel
%if_with manual
BuildRequires: texlive-latex-recommended
%endif
%if_with vnc
BuildRequires: libvncserver-devel
%endif
%if_with libvpx
BuildRequires: libvpx-devel
%endif
BuildRequires: rpm-build-xdg rpm-macros-pam
BuildRequires: /proc

PreReq: %name-common = %version-%release

%description
VirtualBox is a powerful PC virtualization solution allowing
you to run a wide range of PC operating systems on your Linux
system. This includes Windows, Linux, FreeBSD, DOS, OpenBSD
and others. VirtualBox comes with a broad feature set and
excellent performance, making it the premier virtualization
software solution on the market.

%package guest-additions
Summary: Full package of additions for VirtualBox OSE guest systems
Group: Emulators
Requires: xorg-drv-vboxvideo
Requires: %name-guest-utils

%description guest-additions
This packages contains full package of additions for VirtualBox OSE
guest systems. It consists basic utils, which allows to share files and
sync time with host system, and intergrates with xorg-server for mouse
and video driver with OpenGL support, copy/paste between guest and host.

%package guest-utils
Summary: Additions for VirtualBox OSE guest systems
Group: Emulators

%description guest-utils
This packages contains basic utils for VirtualBox OSE guest systems.
It allows to share files and sync time with host system.

%package webservice
Summary: VirtualBox Web Service
Group: Emulators
Requires: %name = %version-%release

%description webservice
This packages contains VirtualBox web service API daemon.
It allows to control virtual machines via web interface.

%package -n python-module-vboxapi
Summary: VirtualBox python API
Group: Development/Python
Requires: %name = %version-%release

%description -n python-module-vboxapi
This packages contains VirtualBox python module 'vboxapi'.
It allows to control virtual machines via python scripts.

%package -n %modname
Summary: Sources for VirtualBox module
Group: Development/Kernel
BuildArch: noarch
Provides: %oldmodname = %version-%release

%description -n %modname
Sources for VirtualBox kernel module.

%package -n %modnamepci
Summary: Sources for VirtualBox module for OSE pci
Group: Development/Kernel
BuildArch: noarch

%description -n %modnamepci
Sources for VirtualBox kernel module for OSE pci.

%package -n %modnamenetflt
Summary: Sources for VirtualBox module for OSE netfilter
Group: Development/Kernel
BuildArch: noarch
Provides: %oldmodnamenetflt = %version-%release

%description -n %modnamenetflt
Sources for VirtualBox kernel module for OSE netfilter.

%package -n %modnamenetadp
Summary: Sources for VirtualBox module for OSE netadaptor
Group: Development/Kernel
BuildArch: noarch
Provides: %oldmodnamenetadp = %version-%release

%description -n %modnamenetadp
Sources for VirtualBox kernel module for OSE netadaptor.

%package -n %modnameguest
Summary: Sources for VirtualBox module for OSE guest additions
Group: Development/Kernel
BuildArch: noarch
Provides: %oldmodnameadd = %version-%release
Provides: %oldmodnameguest = %version-%release

%description -n %modnameguest
Sources for VirtualBox kernel module for OSE guest additions.

%package -n %modnamevfs
Summary: Sources for VirtualBox module for OSE VFS
Group: Development/Kernel
BuildArch: noarch
Provides: %oldmodnamevfs = %version-%release

%description -n %modnamevfs
Sources for VirtualBox kernel module for OSE VFS.

%package -n %modnamevideo
Summary: Sources for VirtualBox module for OSE Video DRM
Group: Development/Kernel
BuildArch: noarch
Provides: %oldmodnamevideo = %version-%release

%description -n %modnamevideo
Sources for VirtualBox kernel module for OSE Video DRM.

%package -n xorg-drv-vboxvideo
Summary: The X.org driver for video in VirtualBox guests
Group: System/X11
Provides: xorg-x11-drv-vboxvideo = %version-%release
Obsoletes: xorg-x11-drv-vboxvideo < %version
Requires: XORG_ABI_VIDEODRV = %get_xorg_abi_videodrv

%description -n xorg-drv-vboxvideo
The X.org driver for video in VirtualBox guests

%package common
Summary: VirtualBox module support files
Group: System/Configuration/Other
BuildArch: noarch
# due to new_summary function and is_builtin_mode bugfix
PreReq: control >= 0.7.2-alt1
PreReq: shadow-utils
# due to /bin/mountpoint
PreReq: sysvinit-utils

%description common
This package contains scripts and other support files which are
required to use the vboxdrv kernel module in the ALT Linux system.
The kernel module itself is not included - you need to install the
appropriate kernel-modules-virtualbox-* package for your kernel.

%package doc
Summary: VirtualBox documentation
Group: Documentation
BuildArch: noarch

%description doc
This package contains VirtualBox User Manual.

%package sdk
Summary: VirtualBox SDK
Group: Development/Other
Requires: python-module-vboxapi = %version-%release

%description sdk
This package contains VirtualBox SDK.

%prep
%setup -q -n %distarchive
%patch -p1

cp %SOURCE15 %SOURCE16 src/VBox/Frontends/VirtualBox/images

%build
export GCC_VERSION=%gcc_version
./configure --ose \
--disable-kmods \
%if_with webservice
--enable-webservice \
%endif
%if_without python
--disable-python \
%endif
%if_without java
--disable-java \
%endif
%if_with vnc
--enable-vnc \
%endif
%if_with vde
--enable-vde \
%endif
%if_without libvpx
--disable-libvpx \
%endif
%if_without manual
--disable-docs \
%endif
--with-qt-dir=%_qt4dir \
--with-kbuild=%_bindir
%if_without additions
echo "VBOX_WITH_X11_ADDITIONS    := " >> LocalConfig.kmk
%endif
# don't build testcases to save time, they are not needed for the package
echo "VBOX_WITH_TESTCASES        :=" >> LocalConfig.kmk
echo "VBOX_WITH_TESTSUITE        :=" >> LocalConfig.kmk
# required for VBOX_PATH_APP_PRIVATE_*
echo "VBOX_DOCBOOK_WITH_LATEX    := 1" >> LocalConfig.kmk
echo "KBUILD_MSG_STYLE           := brief" >> LocalConfig.kmk
echo "VBOX_PATH_APP_PRIVATE_ARCH := %vboxdir" >> LocalConfig.kmk
echo "VBOX_PATH_SHARED_LIBS      := \$(VBOX_PATH_APP_PRIVATE_ARCH)" >> LocalConfig.kmk
echo "VBOX_WITH_RUNPATH          := \$(VBOX_PATH_APP_PRIVATE_ARCH)" >> LocalConfig.kmk
echo "VBOX_PATH_APP_PRIVATE      := %vboxdatadir" >> LocalConfig.kmk
echo "VBOX_PATH_APP_DOCS         := %_defaultdocdir/%name-doc-%version" >> LocalConfig.kmk
echo "VBOX_PATH_PACKAGE_DOCS     := \$(VBOX_PATH_APP_DOCS)" >> LocalConfig.kmk
echo "VBOX_VENDOR                := ALT Linux Team" >> LocalConfig.kmk
echo "VBOX_VENDOR_SHORT          := ALT" >> LocalConfig.kmk
echo "VBOX_PRODUCT               := VM VirtualBox OSE" >> LocalConfig.kmk

echo "VBOX_USE_SYSTEM_XORG_HEADERS := 1" >> LocalConfig.kmk

source env.sh
kmk -j1 VBOXDIR=%vboxdir

%if_enabled debug
sed 's|@VBOX_BUILD_DIR@|%vboxdir|g' %SOURCE99 >%vboxdbg_file
chmod u+x %vboxdbg_file
%endif

%install
%if_enabled debug
echo -e "\nVirtualBox not installable due debug build enabled\nRun: %vboxdbg_file\n  or %vboxdbg_file ./VirtualBox\n"
false
%endif

mkdir -p %buildroot{%_bindir,%_sbindir,%vboxdir/ExtensionPacks,%vboxdatadir,%kernel_src,%_initrddir,%_udevrulesdir}

# install common
install -Dp %SOURCE1 %buildroot%_controldir/%name
sed -i -e 's|@udevrulesdir@|%_udevrulesdir|g' %buildroot%_controldir/%name
install -Dp %SOURCE2 %buildroot%_initdir/%name
install -Dp -m644 %SOURCE4 \
%buildroot%_udevrulesdir/90-%name.rules

%if_with additions
# install additions from src
install -Dp %SOURCE7 %buildroot%_initdir/vboxadd
install -Dp %SOURCE8 %buildroot%_initdir/vboxadd-service
install -Dp -m644 %SOURCE3 %buildroot%_udevrulesdir/60-vboxadd.rules

#install -d %buildroot%_sysconfdir/hal/fdi/policy
#install -m644 src/VBox/Additions/linux/installer/90-vboxguest.fdi %buildroot%_sysconfdir/hal/fdi/policy/90-vboxguest.fdi

install -d %buildroot%_sysconfdir/X11/xinit.d
install -m755 src/VBox/Additions/x11/Installer/98vboxadd-xclient %buildroot%_sysconfdir/X11/xinit.d
%endif

# install application
cd out/%vbox_platform/release/bin

#    SUPInstall \
#    SUPUninstall \
#    EfiThunk \
cp -a \
VBoxAutostart \
VBoxBalloonCtrl \
VBoxExtPackHelperApp \
VBoxHeadless \
VBoxManage \
VBoxNetNAT \
VBoxNetAdpCtl \
VBoxNetDHCP \
VBoxSDL \
VBoxSVC \
VBoxTestOGL \
VBoxTunctl \
VBoxVolInfo \
VBoxXPCOMIPCD \
VirtualBox \
iPxeBaseBin \
xpidl \
*.gc \
*.r0 \
*.so \
*.fd \
*.py \
components/ \
sdk/ \
%if_with webservice
vboxwebsrv \
%endif
%buildroot%vboxdir

%if_with python
cd sdk/installer >/dev/null
VBOX_INSTALL_PATH=%vboxdir VBOX_VERSION=%version python vboxapisetup.py install --install-lib=%python_sitelibdir --root=%buildroot
cd -
%endif

cp -a \
VBoxCreateUSBNode.sh \
nls/ \
%buildroot%vboxdatadir

# create links
for n in VBoxAutostart \
 VBoxBalloonCtrl \
 VBoxManage \
 VBoxSDL \
 VBoxTunctl \
 VBoxVolInfo \
 VirtualBox \
%if_with webservice
 vboxwebsrv \
%endif
 xpidl; do
ln -s $(relative %vboxdir/$n %_bindir/$n) %buildroot%_bindir
done

# install kernel sources
cp -a src/vboxdrv %buildroot%kernel_src/%modname-%version
cp -a src/vboxpci %buildroot%kernel_src/%modnamepci-%version
cp -a src/vboxnetflt %buildroot%kernel_src/%modnamenetflt-%version
cp -a src/vboxnetadp %buildroot%kernel_src/%modnamenetadp-%version
tar -C %buildroot%kernel_src -c %modname-%version | bzip2 -c > \
%buildroot%kernel_src/%modname-%version.tar.bz2
rm -rf %buildroot%kernel_src/%modname-%version
tar -C %buildroot%kernel_src -c %modnamepci-%version | bzip2 -c > \
%buildroot%kernel_src/%modnamepci-%version.tar.bz2
rm -rf %buildroot%kernel_src/%modnamepci-%version
tar -C %buildroot%kernel_src -c %modnamenetflt-%version | bzip2 -c > \
%buildroot%kernel_src/%modnamenetflt-%version.tar.bz2
rm -rf %buildroot%kernel_src/%modnamenetflt-%version
tar -C %buildroot%kernel_src -c %modnamenetadp-%version | bzip2 -c > \
%buildroot%kernel_src/%modnamenetadp-%version.tar.bz2
rm -rf %buildroot%kernel_src/%modnamenetadp-%version

cd additions >/dev/null
# install additions kernel sources
cp -a src/vboxguest %buildroot%kernel_src/%modnameguest-%version
tar -C %buildroot%kernel_src -c %modnameguest-%version | bzip2 -c > \
%buildroot%kernel_src/%modnameguest-%version.tar.bz2
rm -rf %buildroot%kernel_src/%modnameguest-%version

# install VFS kernel sources
cp -a src/vboxsf %buildroot%kernel_src/%modnamevfs-%version
tar -C %buildroot%kernel_src -c %modnamevfs-%version | bzip2 -c > \
%buildroot%kernel_src/%modnamevfs-%version.tar.bz2
rm -rf %buildroot%kernel_src/%modnamevfs-%version

# install VFS kernel sources
cp -a src/vboxvideo %buildroot%kernel_src/%modnamevideo-%version
tar -C %buildroot%kernel_src -c %modnamevideo-%version | bzip2 -c > \
%buildroot%kernel_src/%modnamevideo-%version.tar.bz2
rm -rf %buildroot%kernel_src/%modnamevideo-%version

%if_with additions
# install additions
install -d %buildroot/%_bindir
install -m755 VBoxClient VBoxControl VBoxService %buildroot/%_bindir/

install -d %buildroot/%vboxadddir
install -m644 VBoxOGL*.so %buildroot/%vboxadddir/

# create links
ln -s $(relative %_bindir/VBoxService %_sbindir/) %buildroot%_sbindir/vboxadd-service

# install sysconfig for vboxadd-service
mkdir -p %buildroot%_sysconfdir/sysconfig
cp %SOURCE6 %buildroot%_sysconfdir/sysconfig/vboxadd-service

# install mount vbox share folder
install -d %buildroot/sbin
install -m755 mount.vboxsf %buildroot/sbin/mount.vboxsf

install -d %buildroot%_sysconfdir/security/console.perms.d/
install -m644 %SOURCE5 %buildroot%_sysconfdir/security/console.perms.d/

# install x11 drivers
install -d %buildroot%_x11modulesdir/drivers
install vboxvideo_drv_system.so %buildroot%_x11modulesdir/drivers/vboxvideo_drv.so

mkdir -p %buildroot%_x11modulesdir/dri/
ln -s $(relative %vboxadddir/VBoxOGL.so %_x11modulesdir/dri/) %buildroot%_x11modulesdir/dri/vboxvideo_dri.so

mkdir -p %buildroot%_pam_modules_dir/
install -m644 pam_vbox.so %buildroot%_pam_modules_dir/
%endif
cd - >/dev/null

# install icons
mkdir -p %buildroot%_niconsdir
install -m644 icons/32x32/*.png %buildroot%_niconsdir/
mkdir -p %buildroot%_miconsdir
install -m644 icons/16x16/*.png %buildroot%_miconsdir/
mkdir -p %buildroot%_liconsdir
install -m644 icons/48x48/*.png %buildroot%_liconsdir/
mkdir -p %buildroot%_iconsdir/hicolor/64x64/apps
install -m644 icons/64x64/*.png %buildroot%_iconsdir/hicolor/64x64/apps/
mkdir -p %buildroot%_iconsdir/hicolor/128x128/apps
install -m644 icons/128x128/*.png %buildroot%_iconsdir/hicolor/128x128/apps/

# install mime types
mkdir -p %buildroot%_xdgmimedir/packages
install -m644 virtualbox.xml %buildroot%_xdgmimedir/packages/virtualbox.xml

# install menu entries
mkdir -p %buildroot%_desktopdir
install -m644 virtualbox.desktop %buildroot%_desktopdir/

# install docs
mkdir -p %buildroot%_defaultdocdir/%name-doc-%version
cp %SOURCE13 %SOURCE17 %SOURCE20 %buildroot%_defaultdocdir/%name-doc-%version/
tar -xf %SOURCE21 -C %buildroot%_defaultdocdir/%name-doc-%version/

# install unit file
install -pDm644 %SOURCE22 %buildroot%_unitdir/%name.service

%if_with vnc
cp -a ExtensionPacks/VNC %buildroot%vboxdir/ExtensionPacks/
%endif

%if_with webservice
mkdir -p %buildroot%vboxwebdir

# install vboxweb-service initscript
install -Dp %SOURCE10 %buildroot%_initdir/vboxweb-service

# install sysconfig for vboxweb-service
mkdir -p %buildroot%_sysconfdir/sysconfig
cp %SOURCE9 %buildroot%_sysconfdir/sysconfig/vboxweb-service
%endif

%pre
%pre_control %name

%post
%post_control -s vboxusers %name

%pre common
%pre_control %name
/usr/sbin/groupadd -r -f vboxusers

%post common
%post_service %name
%post_control -s vboxusers %name

%preun common
%preun_service %name

%triggerin common -- dev
# If using static /dev, select the same status again to fix permissions
mountpoint -q /dev || {
status="`/usr/sbin/control %name status`" || status=
[ -n "$status" ] && /usr/sbin/control %name "$status" ||:
}

%pre guest-additions
/usr/sbin/groupadd -r -f vboxadd

%if_with webservice
%pre webservice
/usr/sbin/useradd -r -g vboxusers -d %vboxwebdir -c 'VirtualBox Web Service' -n vboxwebsrv -s /bin/sh >/dev/null 2>&1 ||:
%endif

%files
%_bindir/*
%vboxdir/*
%exclude %_bindir/xpidl
%if_with additions
%exclude %_bindir/VBoxClient
%exclude %_bindir/VBoxControl
%exclude %_bindir/VBoxService
%exclude %vboxadddir
%endif
%if_with webservice
%exclude %_bindir/vboxwebsrv
%exclude %vboxdir/vboxwebsrv
%endif
%dir %vboxdir
%dir %vboxdir/ExtensionPacks
%attr(4710,root,vboxusers) %vboxdir/VBoxExtPackHelperApp
%attr(4710,root,vboxusers) %vboxdir/VBoxHeadless
%attr(4710,root,vboxusers) %vboxdir/VBoxNetDHCP
%attr(4710,root,vboxusers) %vboxdir/VBoxNetNAT
%attr(4710,root,vboxusers) %vboxdir/VBoxNetAdpCtl
%attr(4710,root,vboxusers) %vboxdir/VBoxSDL
%attr(4710,root,vboxusers) %vboxdir/VBoxVolInfo
%attr(4710,root,vboxusers) %vboxdir/VirtualBox
%exclude %vboxdir/sdk
%exclude %vboxdir/xpidl
%exclude %vboxdir/VBoxPython*.so
%vboxdatadir/nls
%_niconsdir/*.png
%_miconsdir/*.png
%_liconsdir/*.png
%_iconsdir/hicolor/64x64/apps/*.png
%_iconsdir/hicolor/128x128/apps/*.png
%_xdgmimedir/packages/*.xml
%_desktopdir/*.desktop

%files -n %modname
%kernel_src/%modname-%version.tar.bz2

%files -n %modnamepci
%kernel_src/%modnamepci-%version.tar.bz2

%files -n %modnamenetflt
%kernel_src/%modnamenetflt-%version.tar.bz2

%files -n %modnamenetadp
%kernel_src/%modnamenetadp-%version.tar.bz2

%files -n %modnameguest
%kernel_src/%modnameguest-%version.tar.bz2

%files -n %modnamevfs
%kernel_src/%modnamevfs-%version.tar.bz2

%files -n %modnamevideo
%kernel_src/%modnamevideo-%version.tar.bz2

%if_with additions
%files -n xorg-drv-vboxvideo
%_x11modulesdir/drivers/vboxvideo_drv.so

%files guest-utils
/sbin/mount.vboxsf
%_initrddir/vboxadd
%_initrddir/vboxadd-service
%config(noreplace) %_sysconfdir/sysconfig/vboxadd-service
#_sysconfdir/hal/fdi/policy/90-vboxguest.fdi
%config %_udevrulesdir/60-vboxadd.rules
%_sbindir/vboxadd-service
%_bindir/VBoxControl
%_bindir/VBoxService
%_pam_modules_dir/*.so
%_sysconfdir/security/console.perms.d/60-vboxadd.perms

%files guest-additions
%_sysconfdir/X11/xinit.d/98vboxadd-xclient
%_bindir/VBoxClient
%dir %vboxadddir
%vboxadddir/VBoxOGL*.so
%_x11modulesdir/dri/vboxvideo_dri.so
%endif

%if_with webservice
%files webservice
%_initrddir/vboxweb-service
%config(noreplace) %_sysconfdir/sysconfig/vboxweb-service
%dir %attr(0750,vboxwebsrv,vboxusers) %vboxwebdir
%vboxdir/vboxwebsrv
%_bindir/vboxwebsrv
%endif

%if_with python
%files -n python-module-vboxapi
%vboxdir/VBoxPython*.so
%python_sitelibdir/*
%vboxdir/sdk/bindings/xpcom/python/xpcom
%endif

%files common
%_initdir/%name
%_unitdir/%name.service
%_controldir/%name
%config %_udevrulesdir/90-%name.rules
%dir %vboxdatadir
%vboxdatadir/VBoxCreateUSBNode.sh

%files doc
%_defaultdocdir/%name-doc-%version

%files sdk
%_bindir/xpidl
%vboxdir/xpidl
%vboxdir/sdk
%if_with python
%exclude %vboxdir/sdk/bindings/xpcom/python/xpcom
%endif

%changelog
