Name: vixie-cron
Version: 4.1.20060426
Release: alt9

%def_with selinux

Summary: The Vixie cron daemon for executing specified programs at set times
License: BSD-style
Group: System/Servers

Source0: vixie-cron-%version.tar
Source1: crond.init
Source2: crontab.template
Source3: crond.pamd
Source4: crond.limits
Source5: crond.service

Provides: %_sysconfdir/cron.d, at = %version-%release
Obsoletes: at

PreReq: crontab-control
Requires: vitmp

Patch1:  vixie-cron-4.1.20060426-alt-warnings.patch
Patch2:  vixie-cron-4.1.20060426-owl-alt-linux.patch
Patch3:  vixie-cron-4.1.20040916-owl-vitmp.patch
Patch4:  vixie-cron-4.1.20040916-owl-crond.patch
Patch5:  vixie-cron-4.1.20060426-owl-st_nlink.patch
Patch6:  vixie-cron-4.1.20040916-alt-makefile.patch
Patch7:  vixie-cron-4.1.20040916-alt-progname.patch
Patch8:  vixie-cron-4.1.20040916-alt-crontab-template.patch
Patch9:  vixie-cron-4.1.20040916-alt-sigpipe.patch
Patch10: vixie-cron-4.1.20040916-alt-pam.patch
Patch11: vixie-cron-4.1.20040916-alt-setlocale.patch
Patch12: vixie-cron-4.1.20040916-alt-children.patch
Patch13: vixie-cron-4.1.20060426-owl-tmp.patch
Patch14: vixie-cron-4.1.20040916-alt-setproctitle.patch
Patch15: vixie-cron-4.1.20060426-alt-crontab-list.patch
Patch16: vixie-cron-4.1.20060426-alt-path.patch
Patch17: vixie-cron-4.1.20060426-alt-selinux.patch

BuildRequires: libpam-devel, setproctitle-devel
%{?_with_selinux:BuildRequires: libselinux-devel}

%description
cron is a daemon that runs specified programs at scheduled times.  This
package contains Paul Vixie's implementation of cron, with significant
modifications by the NetBSD, OpenBSD, Red Hat, Owl and ALT teams.

%prep
%setup
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1
%patch9 -p1
%patch10 -p1
%patch11 -p1
%patch12 -p1
%patch13 -p1
%patch14 -p1
%patch15 -p1
%patch16 -p1
%{?_with_selinux:%patch17 -p1}

sed -i 's/^\(static char const rcsid\[\] =\).*/\1 "%name-%version-%release";/' \
	usr.sbin/cron/crontab.c
find -type f -name \*.orig -delete

%build
for i in usr.sbin/cron usr.bin/crontab usr.bin/at; do
%make_build .CURDIR=. -C "$i"
done

%install
mkdir -p %buildroot{%_sysconfdir/cron.d,/var/spool/{cron,at}}

for i in usr.sbin/cron usr.bin/crontab usr.bin/at; do
%makeinstall_std .CURDIR=. -C "$i"
done

for i in atq atrm batch; do
	ln -s at %buildroot%_bindir/$i
done

ln -s at.1 %buildroot%_man1dir/batch.1
ln -s cron.8 %buildroot%_man8dir/crond.8

install -pD -m755 %_sourcedir/crond.init \
	%buildroot%_initdir/crond
install -pD -m644 %_sourcedir/crond.service \
	%buildroot%systemd_unitdir/crond.service
install -pD -m644 %_sourcedir/crontab.template \
	%buildroot%_sysconfdir/crontab.template
install -pD -m600 %_sourcedir/crond.pamd \
	%buildroot%_sysconfdir/pam.d/crond
install -pD -m644 %_sourcedir/crond.limits \
	%buildroot%_sysconfdir/sysconfig/limits.d/crond

touch %buildroot%_sysconfdir/{at,cron}.{allow,deny}

%pre
%pre_control crontab at

%post
%post_control crontab at
%post_service crond

%preun
%preun_service crond

%files
%_sbindir/*
%attr(700,root,root) %_bindir/at
%attr(700,root,root) %_bindir/crontab
%_bindir/atq
%_bindir/atrm
%_bindir/batch
%_mandir/man?/*
%config %_initdir/crond
%systemd_unitdir/crond.service
%attr(640,root,crontab) %ghost %_sysconfdir/at.allow
%attr(640,root,crontab) %ghost %_sysconfdir/cron.allow
%attr(640,root,crontab) %config(noreplace) %_sysconfdir/at.deny
%attr(640,root,crontab) %config(noreplace) %_sysconfdir/cron.deny
%config(noreplace) %_sysconfdir/crontab.template
%config(noreplace) %_sysconfdir/pam.d/crond
%config(noreplace) %_sysconfdir/sysconfig/limits.d/crond
%attr(1770,root,crontab) %dir /var/spool/at
%attr(3730,root,crontab) %dir /var/spool/cron
%attr(700,root,root) %dir %_sysconfdir/cron.d

%changelog
