Name: vlan-utils
Version: 1.9
Release: alt3

Summary: Userspace utilities for controlling VLANs on ethernet devices
License: GPLv2+
Group: System/Kernel and hardware
Url: http://www.candelatech.com/~greear/vlan.html
Packager: Dmitry V. Levin <ldv@altlinux.org>

# http://www.candelatech.com/~greear/vlan/vlan.%version.tar.gz
Source: vlan-%version.tar
Patch: vlan-1.9-deb-alt-fixes.patch

Provides: vlan-utils24 = %version-%release
Obsoletes: vlan-utils24 < %version
Conflicts: vlan-utils22

%description
This package contains the user mode utility required to add and remove
VLAN devices from ethernet devices.

%prep
%setup -q -n vlan-%version
%patch -p1

%build
make clean
%make_build VERSION=%version CCFLAGS='%optflags -D_GNU_SOURCE'
# fix broken refs
sed -i -e 's|<a href="vlan/howto|<a href="howto|' \
	-e 's|<a href="vlan/vlan|<a href="http://www.candelatech.com/~greear/vlan/vlan|' \
	vlan.html

%install
mkdir -p %buildroot{%_bindir,%_man8dir}
install -pm755 vconfig %buildroot%_bindir/
install -pm644 vconfig.8 %buildroot%_man8dir/

%files
%_bindir/*
%_man8dir/*
%doc CHANGELOG README *.html vlan_test.pl

%changelog
