# vim: set ft=spec: -*- rpm-spec -*-

Name:      vtcl
Version:   1.6.0
Release:   alt1
Copyright: GPL
Group:     Development/Tcl
URL:       http://vtcl.sourceforge.net
Source:    http://prdownloads.sourceforge.net/vtcl/vtcl-%version.tar.gz
Requires:  tcl >= 8.3
Requires:  tk  >= 8.3
BuildArchitectures: noarch

Summary:   Visual Tcl is an integrated development environment for Tcl/Tk 8.3 and later.

%description
Visual Tcl is a freely-available, cross-platform application development environment for the Tcl/Tk language.
It generates pure Tcl/Tk code and has support for Itcl megawidgets, Tix and the BLT extension.

Visual Tcl is covered by the GNU General Public License. 
Please read the LICENSE file for more information.

%prep
%setup -q -n vtcl-%version

%install

DIRECTORY=%buildroot%{_datadir}/vtcl-%{version}

mkdir -p %buildroot%_bindir
mkdir -p $DIRECTORY
mkdir -p $DIRECTORY/images
mkdir -p $DIRECTORY/images/edit
mkdir -p $DIRECTORY/lib
mkdir -p $DIRECTORY/lib/bwidget
mkdir -p $DIRECTORY/lib/bwidget/lang
mkdir -p $DIRECTORY/lib/bwidget/images
mkdir -p $DIRECTORY/lib/Help
mkdir -p $DIRECTORY/lib/Widgets
mkdir -p $DIRECTORY/lib/Widgets/blt
mkdir -p $DIRECTORY/lib/Widgets/bwidget/
mkdir -p $DIRECTORY/lib/Widgets/core
mkdir -p $DIRECTORY/lib/Widgets/itcl
mkdir -p $DIRECTORY/lib/Widgets/table
mkdir -p $DIRECTORY/lib/Widgets/tablelist
mkdir -p $DIRECTORY/lib/Widgets/tix
mkdir -p $DIRECTORY/lib/Widgets/user
mkdir -p $DIRECTORY/lib/Widgets/vtcl
mkdir -p $DIRECTORY/lib/ttd

#install -m 755 vtcl.tcl                  $DIRECTORY
#install -m 755 vtsetup.tcl               $DIRECTORY
install -m 644 images/*.*                $DIRECTORY/images
install -m 644 images/edit/*             $DIRECTORY/images/edit
install -m 644 lib/*.*                   $DIRECTORY/lib
install -m 644 lib/Help/*                $DIRECTORY/lib/Help
install -m 644 lib/bwidget/*.tcl         $DIRECTORY/lib/bwidget
install -m 644 lib/bwidget/lang/*        $DIRECTORY/lib/bwidget/lang
install -m 644 lib/bwidget/images/*      $DIRECTORY/lib/bwidget/images
install -m 644 lib/Widgets/blt/*         $DIRECTORY/lib/Widgets/blt
install -m 644 lib/Widgets/bwidget/*     $DIRECTORY/lib/Widgets/bwidget
install -m 644 lib/Widgets/core/*        $DIRECTORY/lib/Widgets/core
install -m 644 lib/Widgets/itcl/*        $DIRECTORY/lib/Widgets/itcl
install -m 644 lib/Widgets/table/*       $DIRECTORY/lib/Widgets/table
install -m 644 lib/Widgets/tablelist/*   $DIRECTORY/lib/Widgets/tablelist
install -m 644 lib/Widgets/tix/*         $DIRECTORY/lib/Widgets/tix
install -m 644 lib/Widgets/vtcl/*        $DIRECTORY/lib/Widgets/vtcl
install -m 644 lib/ttd/*                 $DIRECTORY/lib/ttd

echo "#!/usr/bin/wish" > ./vtcl
echo "set env(PATH_TO_WISH) \"/usr/bin/wish\"" >>  ./vtcl
echo "set env(VTCL_HOME) \"/usr/share/vtcl-1.6.0\"" >>  ./vtcl

cat vtcl.tcl >> ./vtcl

install -m 755 ./vtcl %buildroot%_bindir/vtcl

%files
%doc ChangeLog LICENSE README demo doc sample
%_bindir/*
%_datadir/*


%changelog
