Name: vzctl
Version: 4.1.2
Release: alt1

Summary: OpenVZ Virtual Environments control utility
License: GPL
Group: System/Configuration/Other
Url: http://openvz.org/
Packager: Viacheslav Dubrovskyi <dubrsl@altlinux.org>

# http://download.openvz.org/utils/vzctl/%version/src/vzctl-%version.tar.bz2
Source: %name-%version.tar
Patch: %name-%version-alt.patch

# these reqs are for vz helper scripts
Requires: vzquota ploop >= 1.4
Requires: network-config-subsystem
# vzmigrate
Requires: rsync

BuildRequires: setproctitle-devel ploop libploop-devel libxml2-devel libcgroup-devel

%define _pkgconfdir /etc/vz
%add_findreq_skiplist %_pkgconfdir/dists/scripts/*

%description
OpenVZ is an Operating System-level server virtualization solution, built
on Linux.  OpenVZ creates isolated, secure virtual private servers on a
single physical server enabling better server utilization and ensuring
that applications do not conflict.  Each VE performs and executes exactly
like a stand-alone server; VEs can be rebooted independently and have
root access, users, IP addresses, memory, processes, files, applications,
system libraries and configuration files.

This package contain the control tool to manipulate
OpenVZ Virtual Environments.

%prep
%setup
%patch -p1

%build
%autoreconf
%add_optflags -fno-strict-aliasing
%configure --enable-bashcomp --enable-logrotate --disable-silent-rules vzdir=/var/lib/vz
%make_build

%install
%makeinstall_std install-altlinux
if [ %_initdir != /etc/init.d ]; then
	mkdir -p `dirname %buildroot%_initdir`
	mv %buildroot/etc/init.d %buildroot%_initdir
fi
chmod 700 %buildroot%_pkgconfdir
chmod 710 %buildroot/var/lib/vz
chmod 700 %buildroot/var/lib/vz/*
chmod 710 %buildroot/var/lib/vz/template
chmod 3770 %buildroot/var/lib/vz/template/cache

touch %buildroot/etc/sysconfig/vzeventd

%pre
/usr/sbin/groupadd -r -f _vzctl
if [ -L %_pkgconfdir/conf -a -d %_pkgconfdir/conf -a ! -e %_pkgconfdir/conf.rpmsave ]; then
	mv %_pkgconfdir/conf %_pkgconfdir/conf.rpmsave
	if [ "$(readlink %_pkgconfdir/conf.rpmsave)" = ../sysconfig/vz-scripts ]; then
		mkdir -p %_pkgconfdir/conf &&
		mv %_pkgconfdir/conf.rpmsave/* \
			%_pkgconfdir/conf/
	fi
fi

%post
rm -f /dev/vzctl
mknod -m 600 /dev/vzctl c 126 0
if [ $1 -eq 1 ]; then
	/sbin/chkconfig --add vz ||:
fi

%post_service vzeventd

# (Upgrading from <= vzctl-3.0.24)
# If vz is running and vzeventd is not, start it
if %_initddir/vz status >/dev/null 2>&1; then
	if ! %_initddir/vzeventd status >/dev/null 2>&1; then
		%_initddir/vzeventd start
	fi
fi
exit 0

%preun
%preun_service vz
%preun_service vzeventd

%files
%doc ChangeLog
%defattr(-,root,root,-)
%config %_initdir/*
%config(noreplace) /etc/logrotate.d/*
%_datadir/vzctl
%_sbindir/*
%_libdir/lib*
%_mandir/man?/*
%dir %_pkgconfdir
%dir %_pkgconfdir/names
%config(noreplace) %_pkgconfdir/vz.conf
%config(noreplace) %_pkgconfdir/download.conf
%config(noreplace) %_pkgconfdir/osrelease.conf
%config(noreplace) %_pkgconfdir/oom-groups.conf
%ghost %config(noreplace) /etc/sysconfig/vzeventd
%config %_pkgconfdir/conf
%config %_pkgconfdir/dists
%config /etc/sysconfig/network-scripts/*
%config /etc/net/*/*
%config /etc/udev/rules.d/*
%config /etc/bash_completion.d/*

%defattr(-,root,_vzctl,-)
/var/lib/vz

%changelog
