Name: weechat
Version: 0.3.5
Release: alt3

Summary: fast, light & extensible IRC client
License: GPLv3
Group: Networking/IRC

URL: http://www.weechat.org/
Source: %name-%version.tar

# Automatically added by buildreq on Thu Oct 20 2011
BuildRequires: asciidoc libaspell-devel libgcrypt-devel libgnutls-devel liblua5-devel libncursesw-devel libruby-devel perl-devel python-devel ruby source-highlight tcl-devel

# used only in aclocal
BuildRequires: libgtk+2-devel

%description
WeeChat is a fast, light and extensible chat client. It runs on many
platforms (including Linux, BSD and Mac OS).
WeeChat is:
- modular: a lightweight core with plugins around
- multi-protocols: IRC and Jabber (other soon)
- extensible: C plugins and scripts (Perl, Python, Ruby, Lua and Tcl)
- free software: released under GPLv3 license
- fully documented: user's guide, API, FAQ,.. translated in many languages
Development is very active, and bug fixes are very fast!

%package plugin-aspell
Summary: Aspell plugin for weechat
Group: Networking/IRC
Requires: %name = %version-%release

%description plugin-aspell
This package contains aspell plugin for weechat.

%package plugin-lua
Summary: Lua plugin for weechat
Group: Networking/IRC
Requires: %name = %version-%release

%description plugin-lua
This package contains lua plugin for weechat.

%package plugin-perl
Summary: Perl plugin for weechat
Group: Networking/IRC
Requires: %name = %version-%release

%description plugin-perl
This package contains perl plugin for weechat.

%package plugin-python
Summary: Python plugin for weechat
Group: Networking/IRC
Requires: %name = %version-%release

%description plugin-python
This package contains python plugin for weechat.

%package plugin-ruby
Summary: Ruby plugin for weechat
Group: Networking/IRC
Requires: %name = %version-%release

%description plugin-ruby
This package contains ruby plugin for weechat.

%package plugin-tcl
Summary: Tcl plugin for weechat
Group: Networking/IRC
Requires: %name = %version-%release

%description plugin-tcl
This package contains ruby plugin for weechat.

%prep
%setup

# build plugins as plugins, not libs
find ./src/plugins -name "Makefile*" -print0 | xargs -r0 subst 's,\(\-module\),\1 -avoid-version,' --

%build
./autogen.sh

%configure \
	--enable-perl \
	--enable-python \
	--enable-ruby \
	--enable-lua \
	--enable-gnutls \
	--disable-gtk \
	--disable-qt \
	--enable-aspell \
	--enable-doc

%make_build

%install
%make_install DESTDIR=%buildroot install

ln -s %name-curses %buildroot%_bindir/%name

%find_lang %name

%files -f %name.lang
%_bindir/*
%dir %_libdir/%name
%dir %_libdir/%name/plugins
%_libdir/%name/plugins/charset.so
%_libdir/%name/plugins/alias.so
%_libdir/%name/plugins/fifo.so
%_libdir/%name/plugins/irc.so
%_libdir/%name/plugins/logger.so
%_libdir/%name/plugins/relay.so
%_libdir/%name/plugins/rmodifier.so
%_libdir/%name/plugins/xfer.so
%_mandir/man?/*
%_defaultdocdir/%name

%files plugin-aspell
%_libdir/%name/plugins/aspell.so

%files plugin-lua
%_libdir/%name/plugins/lua.so

%files plugin-perl
%_libdir/%name/plugins/perl.so

%files plugin-python
%_libdir/%name/plugins/python.so

%files plugin-ruby
%_libdir/%name/plugins/ruby.so

%files plugin-tcl
%_libdir/%name/plugins/tcl.so

%changelog
