Name:           weston
Version:        1.2.0
Release:        alt2
Summary:        Reference compositor for Wayland
Group:          Graphical desktop/Other
License:        BSD and CC-BY-SA
URL:            http://wayland.freedesktop.org/
Source0:        %name-%version.tar

Packager: Alexey Gladkov <legion@altlinux.ru>

BuildRequires:  autoconf gcc-c++ pkg-config
BuildRequires:  libcairo-devel
BuildRequires:  libpango-devel
BuildRequires:  glib2-devel
BuildRequires:  libdrm-devel
BuildRequires:  liblcms2-devel
BuildRequires:  libcolord-devel
BuildRequires:  libjpeg-devel
BuildRequires:  libpng-devel
BuildRequires:  librsvg-devel librsvg-utils
BuildRequires:  libtool
BuildRequires:  libudev-devel
BuildRequires:  libwayland-egl-devel
BuildRequires:  libwayland-cursor-devel
BuildRequires:  libwayland-client-devel
BuildRequires:  libwayland-server-devel
BuildRequires:  libxcb-devel
BuildRequires:  libXcursor-devel
BuildRequires:  libxkbcommon-devel
BuildRequires:  libEGL-devel >= 8.1
BuildRequires:  libgbm-devel
BuildRequires:  libGLES-devel
BuildRequires:  libGLU-devel
BuildRequires:  libwayland-egl-devel
BuildRequires:  libmtdev-devel
BuildRequires:  libpam0-devel
BuildRequires:  libpixman-devel
BuildRequires:  libpoppler-devel
BuildRequires:  libpoppler-glib-devel
BuildRequires:  systemd-devel libwebp-devel

%description
Weston is the reference wayland compositor that can run on KMS, under X11
or under another compositor.

%package devel
Summary:          Development libraries for weston
Group:            Development/C
Requires:         %name = %version-%release

%description devel
Header and Library files for doing development with the weston.

%prep
%setup -q

%build
%autoreconf
%configure \
	--libexecdir=%_libdir/weston/clients \
	--disable-static \
	--disable-setuid-install \
	--disable-rpi-compositor \
	--disable-libunwind \
	--enable-xwayland \
	--enable-colord \
	--enable-clients \
	--enable-simple-clients \
	--enable-weston-launch \
	--enable-x11-compositor \
	--enable-drm-compositor \
	--enable-wayland-compositor \
	--enable-headless-compositor \
	--enable-fbdev-compositor \
	--with-cairo-glesv2

%make_build

%install
%make_install install DESTDIR=%buildroot

mkdir -p -- %buildroot/%_xdgconfigdir/weston
sed \
	-e 's,@clientsdir@,%_libdir/weston/clients,g' \
	rpm/weston.ini > %buildroot/%_xdgconfigdir/weston/weston.ini

chmod +s %buildroot/%_bindir/weston-launch

find %buildroot -name \*.la | xargs rm -f

#pre
#groupadd -r -f weston-launch
#useradd -r -g weston-launch -d /dev/null -s /dev/null -n weston-launch >/dev/null 2>&1 ||:

%files
%dir %_xdgconfigdir/weston
%config(noreplace) %_xdgconfigdir/weston/weston.ini
%_bindir/*
%_libdir/weston
%_datadir/weston
%_man1dir/weston*
%_man5dir/weston*
%_man7dir/weston*
%doc README data/COPYING

%files devel
%_includedir/weston
%_pkgconfigdir/weston.pc

%changelog
