Name: whois
Version: 5.0.23
Release: alt1

Summary: Intelligent WHOIS client
License: GPLv2+
Group: Networking/Other
Url: http://www.linux.it/~md/software

# ftp://ftp.debian.org/debian/pool/main/w/whois/whois_%version.tar.xz
Source: whois_%version.tar

Patch: whois-%version-%release.patch

BuildRequires: libidn-devel

%description
This package provides a commandline client for the WHOIS (RFC 3912)
protocol, which queries online servers for information such as contact
details for domains and IP address assignments.

This version of the WHOIS client tries to guess the right server to ask
for the specified object.

%prep
%setup
%patch -p1
sed -n 's/^\([a-z][^:]\+\.h\):.*\.pl.*/\1/p' Makefile |
	xargs -r rm -fv -- # these headers have to be regenerated
bzip2 -9k debian/changelog

%build
%make_build whois pos \
	CFLAGS='%optflags' HAVE_LIBIDN=1 HAVE_ICONV=1 CONFIG_FILE=/etc/whois.conf

%install
%make_install install-whois install-pos BASEDIR=%buildroot prefix=%prefix
install -pDm644 whois.conf %buildroot/etc/whois.conf

%find_lang %name

%files -f %name.lang
%doc README debian/changelog.bz2 debian/copyright
%_bindir/*
%_mandir/man?/*
%config(noreplace) /etc/whois.conf

%changelog
