%define libname libwim

Name: wimlib
Version: 1.6.2
Release: alt2

Summary: Library to extract, create, modify, and mount WIM files
License: GPLv3+
Group: System/Libraries

Url: http://sourceforge.net/projects/wimlib
Source: http://prdownloads.sourceforge.net/wimlib/wimlib-%version.tar

# manually removed: glibc-devel-static  ruby ruby-stdlibs  python3
# Automatically added by buildreq on Tue Apr 15 2014
# optimized out: libcloog-isl4 libntfs-3g pkg-config
BuildRequires: libattr-devel libfuse-devel libntfs-3g-devel libssl-devel libxml2-devel mt-st

%description
wimlib is a C library for creating, extracting, modifying, and mounting
files in the Windows Imaging Format (WIM files).  It is similar to
Microsoft's WIMGAPI but is designed for both UNIX and Windows.

%package -n %libname
Summary: Library to extract, create, modify, and mount WIM files
Group: System/Libraries

%description -n %libname
wimlib is a C library for creating, extracting, modifying, and mounting
files in the Windows Imaging Format (WIM files).  It is similar to
Microsoft's WIMGAPI but is designed for both UNIX and Windows.

%package -n %libname-devel
Summary: Development files for wimlib
Group: Development/Other
Requires: %libname = %version-%release

%description -n %libname-devel
Development files for wimlib.

%package -n wimtools
Summary: Tools to create, extract, modify, and mount WIM files
Group: File tools
Requires: syslinux, %libname = %version-%release

%description -n wimtools
Tools to create, extract, modify, and mount files in the
Windows Imaging Format (WIM files).  These files are normally
created by using the `imagex.exe' utility on Windows,
but this package contains a free implementation of ImageX called
"wimlib-imagex" that is designed to work on both UNIX and Windows.

%prep
%setup

%build
# helps with rpath
%autoreconf

%configure \
           --disable-static		\
           --disable-rpath		\
	   --with-libcrypto		\
	   --with-ntfs-3g		\
	   --with-fuse			\
	   --enable-xattr
%make_build

%install
%makeinstall_std

%check
:>tests/test-imagex-ntfs	# this one fails
make check

%files -n %libname
%doc AUTHORS README
%_libdir/libwim.so.*

%files -n wimtools
%_bindir/*
%_man1dir/*

%files -n %libname-devel
%_libdir/libwim.so
%_includedir/wimlib.h
%_pkgconfigdir/wimlib.pc

%changelog
