# Spec for Wine, enhanced and localized by eterwine project
#
# All source code can be downloaded from ftp://updates.etersoft.ru/pub/Etersoft/WINE@Etersoft
# Please submit bugfixes or comments via wine@etersoft.ru
#
# Build instruction:
# install etersoft-build-utils and rpm-build-altlinux-compat for your system
# run
#    $ rpmbb wine.spec for build rpm package on ALT
# or $ rpmbph wine.spec for other distro
#
%define debug %nil
%define gecko_version 2.44

Name: wine
Version: 1.9.3
Release: alt0.M70P.1
Epoch: 1

Summary: Environment for running Windows applications (Etersoft edition)
Summary(ru_RU.UTF-8): Среда для запуска программ Windows (сборка от Etersoft)

License: LGPL
Group: Emulators
Url: http://winehq.org.ru/

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source tarball from git://git.etersoft.ru/projects/eterwine.git
# (with Etersoft's addons and patches)
Source: ftp://updates.etersoft.ru/pub/Etersoft/Wine-public/%version/sources/tarball/%name-%version.tar

AutoReq: yes, noperl

#==========================================================================

# General dependencies
BuildRequires: rpm-build-intro >= 1.0
BuildRequires: gcc util-linux flex bison
BuildRequires: fontconfig-devel libfreetype-devel
BuildRequires: libncurses-devel libncursesw-devel libtinfo-devel
BuildRequires: zlib-devel libldap-devel libgnutls-devel
BuildRequires: libxslt-devel libxml2-devel
BuildRequires: libjpeg-devel liblcms2-devel libpng-devel libtiff-devel
BuildRequires: libgphoto2-devel libsane-devel libcups-devel
BuildRequires: libalsa-devel jackit-devel libgsm-devel libmpg123-devel libpulseaudio-devel
BuildRequires: libopenal-devel libGLU-devel
BuildRequires: libusb-devel libieee1284-devel
BuildRequires: libv4l-devel
BuildRequires: libunixODBC-devel
#BuildRequires: gstreamer-devel gst-plugins-devel

# udev needed for udev version detect
BuildRequires: libudev-devel udev libdbus-devel

BuildRequires: libICE-devel libSM-devel
BuildRequires: libX11-devel libXau-devel libXaw-devel libXrandr-devel
BuildRequires: libXext-devel libXfixes-devel libXfont-devel libXft-devel libXi-devel
BuildRequires: libXmu-devel libXpm-devel libXrender-devel
BuildRequires: libXres-devel libXScrnSaver-devel libXinerama-devel libXt-devel
BuildRequires: libXxf86dga-devel libXxf86misc-devel libXcomposite-devel
BuildRequires: libXxf86vm-devel libfontenc-devel libXdamage-devel
BuildRequires: libXvMC-devel libXcursor-devel libXevie-devel libXv-devel

BuildRequires: perl-XML-Simple

# with prelink not found, base address of core dlls won't be set correctly
BuildRequires: prelink

# Actually for x86_32
Requires: glibc-pthread glibc-nss
# Runtime linked (via dl_open)
Requires: libcups libncurses libssl fontconfig libfreetype
Requires: libXrender libXi libXext libX11 libICE

# We have not to use it in production (used in winedbg)
#BuildConflicts: valgrind-devel valgrind

%if %_vendor == "alt"
# fix it for ALT Linux
%define _localstatedir /var

#ExclusiveArch:  %{ix86}
Requires: webclient
BuildRequires: desktop-file-utils

# Use fonts-ttf-liberation instead proprietary MS Core Fonts
Requires: fonts-ttf-core

# Comment out due desktop-file-utils is missed in ALD 4.0
# For menu/MIME subsystem
#Requires(post): desktop-file-utils
#Requires(postun): desktop-file-utils
%endif

# We need predownloaded Gecko engine
Requires: wine-gecko = %gecko_version

Requires: lib%name = %epoch:%version-%release
Provides: %name-utils
Obsoletes: %name-utils
Obsoletes: %name-test

Provides: winetricks
Requires: cabextract

#=========================================================================

%description
WINE Is Not Emulator. Wine is an Open Source implementation of the Windows
API on top of X and Unix.  Think of Wine as a compatibility layer for
running Windows programs. Wine does not require Microsoft Windows,
as it is a completely free alternative implementation of the Windows
API consisting of 100 percent LGPL code, however Wine can optionally
use native Windows DLLs if they are available. Wine provides both a
development toolkit for porting Windows source code to Unix as well as
a program loader, allowing many unmodified Windows programs to run on
x86-based Unixes, including Linux, FreeBSD, and Solaris.

It is still alpha level code; don't expect everything to work.

It is modified Wine build with some patches from Etersoft.
Check http://winehq.org.ru for an additional information.
Bug tracker: http://bugs.etersoft.ru

%description -l ru_RU.UTF-8
WINE Не Является Эмулятором. Это альтернативная реализация API Windows
3.x и Win32. Wine предоставляет как инструментарий разработки (Winelib)
для переноса унаследованных исходных кодов из среды Windows в среду
Unix, так и программный загрузчик, позволяющий исполнять двоичный код, разработанный
для Windows 3.1/95/NT, в среде разных вариантов
Unix на платформе Intel. Wine не требует наличия Microsoft Windows,
поскольку это полностью альтернативная реализация, состоящая из полностью
свободного кода.

WINE всё ещё находится в стадии разработки, поэтому
не ожидайте, что всё будет работать.

Это сборка Wine, содержащая дополнительные изменения по отношению к официальной версии.
Обращайтесь за дополнительной информацией на сайт http://winehq.org.ru
Система регистрации ошибок: http://bugs.etersoft.ru

%package -n %name-test
Summary: WinAPI test for Wine
Summary(ru_RU.UTF-8): Тест WinAPI для Wine
Group: Emulators
Requires: %name = %epoch:%version-%release

%description -n %name-test
WinAPI test for Wine (unneeded for usual work).
Warning: it may kill your X server suddenly.

%package full
Summary: Wine meta package
Summary(ru_RU.UTF-8): Мета пакет Wine
Group: Emulators
Requires: %name = %version-%release
Requires: lib%name-gl = %version-%release

Requires: wine-mono >= 4.5.6

%description full
Wine meta package

%package -n lib%name
Summary: Main library for Wine
Group: System/Libraries

# Load with dl_open
Requires: libssl

%description -n lib%name
This package contains the library needed to run programs dynamically
linked with Wine.

%description -n lib%name -l ru_RU.UTF-8
Этот пакет состоит из библиотек, которые реализуют Windows API.

########## separate libraries
%package -n lib%name-gl
Summary: DirectX/OpenGL support libraries for Wine
Group: System/Libraries
Requires: lib%name = %epoch:%version-%release
Requires: libGL

%description -n lib%name-gl
This package contains the libraries for DirectX/OpenGL support in Wine.

%package -n lib%name-twain
Summary: Twain support library for Wine
Group: System/Libraries
Requires: lib%name = %epoch:%version-%release

%description -n lib%name-twain
This package contains the library for Twain support.

##########################################################################
%package -n lib%name-devel
Summary: Headers for lib%name-devel
Group: Development/C
Requires: lib%name = %epoch:%version-%release
Obsoletes: wine-devel
Provides: wine-devel
Conflicts: libwine-vanilla-devel-static

%description -n lib%name-devel
lib%name-devel contains the header files and some utilities needed to
develop programs using lib%name.

%description -n lib%name-devel -l ru_RU.UTF-8
lib%name-devel содержит файлы для разработки программ, использующих Wine:
заголовочные файлы и утилиты, предназначенные
для компилирования программ с lib%name.

%package -n lib%name-devel-static
Summary: Static libraries for lib%name
Group: Development/C
Requires: lib%name = %epoch:%version-%release

%description -n lib%name-devel-static
lib%name-devel-static contains the static libraries needed to
develop programs which make use of Wine.

##########################################################################

%prep
%setup

%build
%remove_optflags -fomit-frame-pointer
%remove_optflags -D_FORTIFY_SOURCE=2

# Workaround for https://bugzilla.altlinux.org/show_bug.cgi?id=31834
%ifarch x86_64
%add_optflags -fno-omit-frame-pointer
%endif

%configure --with-x \
%ifarch x86_64
	--enable-win64 \
%endif
	--disable-tests \
	--without-gstreamer

make depend
%make_build


%install
%makeinstall_std
%__make -C etersoft initdir=%_initdir sysconfdir=%_sysconfdir localstatedir=%_localstatedir DESTDIR=%buildroot install-etersoft

# Do not pack non english man pages yet
rm -rf %buildroot%_mandir/*.UTF-8


%pre
%groupadd wine || :
%groupadd wineadmin || :

%post
%post_service wine
# start service during first time install (not for ALT), see rpm-build-intro
%start_service wine

%preun
%preun_service wine


%files
%doc ANNOUNCE AUTHORS LICENSE README
%lang(de) %doc documentation/README.de
%lang(es) %doc documentation/README.es
%lang(fr) %doc documentation/README.fr
%lang(hu) %doc documentation/README.hu
%lang(it) %doc documentation/README.it
%lang(ko) %doc documentation/README.ko
%lang(nb) %doc documentation/README.no
%lang(pt) %doc documentation/README.pt
%lang(pt_BR) %doc documentation/README.pt_br
%lang(tr) %doc documentation/README.tr

%_bindir/wine
%_bindir/wine-glibc
%ifnarch x86_64
%_bindir/wine-preloader
%else
%_bindir/wine64-preloader
%endif

%_bindir/regsvr32
%_bindir/winecfg

# link to wine for backward compatibility
%_bindir/wineprefixcreate
%_bindir/ieinstall
%_bindir/winetricks
%_bindir/wineregdiff
%_bindir/setnethasp
%_bindir/winelog
%_bindir/winesplash
%_bindir/winefar

%_bindir/wineconsole
%_bindir/wineserver

%_bindir/msiexec
%_bindir/notepad
%_bindir/regedit
%_bindir/winedbg
%_bindir/wineboot
%_bindir/winefile
%_bindir/winemine
%_bindir/winepath
%_libdir/wine/*.exe.so

%_initdir/wine
%_initdir/wine.outformat
# _localstatedir is broken on some systems as ALT Linux
%attr(0775 root wineadmin) %dir %_localstatedir/lib/wine/
# rules for fix permissions on protection keys
%_sysconfdir/udev/rules.d/99-winekeys.rules
#%_sysconfdir/sysctl.d/wine.conf
%dir %_sysconfdir/wine/
%dir %_sysconfdir/wine/reg.d/
%dir %_sysconfdir/wine/script.d/
%_sysconfdir/wine/reg.d/*.reg*
%_sysconfdir/wine/reg.d/foxpro.manual
%_sysconfdir/wine/script.d/*.sh*
%config(noreplace) %_sysconfdir/wine/config
%_desktopdir/*
%_datadir/desktop-directories/wine.directory
%_iconsdir/*
%dir %_datadir/wine/
%_datadir/wine/skel/
%_datadir/wine/menu.directory
%_datadir/wine/winesplash.xpm
%_datadir/wine/winesplash.xpm.conf
%_datadir/wine/winesplash.png
%_datadir/wine/winesplash.png.conf
%ifnarch x86_64
%_man1dir/wine.1*
%endif
%_man1dir/wineserver.1*
%_man1dir/winedbg.1.*


%files -n lib%name
%doc LICENSE AUTHORS COPYING.LIB
%_libdir/libwine*.so.*
%dir %_libdir/wine/
%_libdir/wine/fakedlls/

%ifnarch x86_64
%_libdir/wine/*.dll16.so
%_libdir/wine/*.drv16.so
%_libdir/wine/*.exe16.so
%_libdir/wine/winoldap.mod16.so
%_libdir/wine/*.vxd.so
%endif

%_libdir/wine/*.cpl.so
%_libdir/wine/*.drv.so
%_libdir/wine/*.dll.so
%_libdir/wine/*.acm.so
%_libdir/wine/*.ocx.so
%_libdir/wine/*.tlb.so
%_libdir/wine/*.sys.so
%_datadir/wine/wine.inf
%_datadir/wine/l_intl.nls
%_datadir/wine/fonts/

# move to separate packages
%exclude %_libdir/wine/twain*
%exclude %_libdir/wine/d3d10.dll.so
%exclude %_libdir/wine/d3d8.dll.so
%exclude %_libdir/wine/d3d9.dll.so
%exclude %_libdir/wine/d3dxof.dll.so
%exclude %_libdir/wine/opengl32.dll.so
%exclude %_libdir/wine/glu32.dll.so
%exclude %_libdir/wine/wined3d.dll.so

%files full

%files -n lib%name-twain
%_libdir/wine/twain*
%_libdir/wine/gphoto2.ds.so
%_libdir/wine/sane.ds.so


%files -n lib%name-gl
%_libdir/wine/d3d10.dll.so
%_libdir/wine/d3d8.dll.so
%_libdir/wine/d3d9.dll.so
%_libdir/wine/d3dxof.dll.so
%_libdir/wine/opengl32.dll.so
%_libdir/wine/glu32.dll.so
%_libdir/wine/wined3d.dll.so


%files -n lib%name-devel
%doc LICENSE LICENSE.OLD README.winedump
%_bindir/winebuild
%_bindir/wmc
%_bindir/wrc
%_bindir/widl
%_bindir/wineg++
%_bindir/winegcc
%_bindir/winecpp
%_bindir/winedump
%_bindir/winemaker

%_includedir/wine/
%_libdir/lib*.so
%_libdir/wine/lib*.def
%_libdir/wine/libwinecrt0.a
%_libdir/wine/libadsiid.a
%_libdir/wine/libdinput.def.a
%_libdir/wine/libdxerr8.a
%_libdir/wine/libdxerr9.a
%_libdir/wine/libdxguid.a
%_libdir/wine/libstrmiids.a
%_libdir/wine/libstrmbase.a
%_libdir/wine/libuuid.a

%_man1dir/wmc.1*
%_man1dir/wrc.1*
%_man1dir/widl.1*
%_man1dir/winebuild*
%_man1dir/winedump.1.*
%_man1dir/wineg++.1.*
%_man1dir/winegcc.1.*
%_man1dir/winecpp.1.*
%_man1dir/winemaker.1.*
%_man1dir/msiexec.1.*
%_man1dir/notepad.1.*
%_man1dir/regedit.1.*
%_man1dir/regsvr32.1.*
%_man1dir/wineboot.1.*
%_man1dir/winecfg.1.*
%_man1dir/wineconsole.1.*
%_man1dir/winefile.1.*
%_man1dir/winemine.1.*
%_man1dir/winepath.1.*


%changelog
