# This spec is backported to ALTLinux p7 automatically by rpmbph script from etersoft-build-utils.
#
%define gecko_version 2.44
%define mono_version 4.6.3

Name: wine-vanilla
Version: 1.9.12
Release: alt0.M70P.1

Summary: Wine - environment for running Windows 16/32/64 bit applications

License: LGPL
Group: Emulators
Url: http://winehq.org

Packager: Vitaly Lipatov <lav@altlinux.ru>

# See http://git.etersoft.ru/people/lav/packages/?p=wine.git;a=shortlog;h=refs/heads/vanilla
# Source tarball from git.etersoft.ru, branch vanilla (pulled from wine's git)
Source: ftp://updates.etersoft.ru/pub/Etersoft/Wine-vanilla/%version/sources/tarball/%name-%version.tar
Source1: etersoft/winetricks
Source2: %name-%version-desktop.tar

AutoReq: yes, noperl

# try build wine64 only on ALT
%if %_vendor == "alt"
%ifarch x86_64
	%def_with build64
%else
    %def_without build64
%endif
%else
   %def_without build64
%endif

# General dependencies
BuildRequires: rpm-build-intro >= 1.0
BuildRequires: gcc util-linux flex bison
BuildRequires: fontconfig-devel libfreetype-devel
BuildRequires: libncurses-devel libncursesw-devel libtinfo-devel
BuildRequires: zlib-devel libldap-devel libgnutls-devel
BuildRequires: libxslt-devel libxml2-devel
BuildRequires: libjpeg-devel liblcms2-devel libpng-devel libtiff-devel
BuildRequires: libgphoto2-devel libsane-devel libcups-devel
BuildRequires: libalsa-devel jackit-devel libgsm-devel libmpg123-devel libpulseaudio-devel
BuildRequires: libopenal-devel libGLU-devel
BuildRequires: libusb-devel libieee1284-devel
BuildRequires: libv4l-devel
BuildRequires: libunixODBC-devel
#BuildRequires: gstreamer-devel gst-plugins-devel

# udev needed for udev version detect
BuildRequires: libudev-devel udev libdbus-devel

BuildRequires: libICE-devel libSM-devel
BuildRequires: libX11-devel libXau-devel libXaw-devel libXrandr-devel
BuildRequires: libXext-devel libXfixes-devel libXfont-devel libXft-devel libXi-devel
BuildRequires: libXmu-devel libXpm-devel libXrender-devel
BuildRequires: libXres-devel libXScrnSaver-devel libXinerama-devel libXt-devel
BuildRequires: libXxf86dga-devel libXxf86misc-devel libXcomposite-devel
BuildRequires: libXxf86vm-devel libfontenc-devel libXdamage-devel
BuildRequires: libXvMC-devel libXcursor-devel libXevie-devel libXv-devel

BuildRequires: perl-XML-Simple

# with prelink not found, base address of core dlls won't be set correctly
BuildRequires: prelink

# Actually for x86_32
Requires: glibc-pthread glibc-nss

# Enable with can build on x86_64
# GCC v4.4 is needed for build wine64
#ExclusiveArch:  %{ix86}
Requires: webclient

Requires: wine-gecko = %gecko_version

BuildRequires: desktop-file-utils
# Use it instead proprietary MS Core Fonts
# Requires: fonts-ttf-liberation

# not linked directly
Requires: libncurses

# For menu/MIME subsystem
Requires: desktop-file-utils

Requires: lib%name = %version-%release
Conflicts: wine

Provides: winetricks
Requires: cabextract

#=========================================================================

%description
While Wine is usually thought of as a Windows(TM) emulator, the Wine
developers would prefer that users thought of Wine as a Windows
compatibility layer for UNIX. This package includes a program loader,
which allows unmodified Windows 3.x/9x/NT binaries to run on x86 and x86_64
Unixes. Wine does not require MS Windows, but it can use native system
.dll files if they are available.

%package test
Summary: WinAPI test for Wine
Summary(ru_RU.UTF-8): Тест WinAPI для Wine
Group: Emulators
Requires: %name = %version-%release

%description test
WinAPI test for Wine (unneeded for usual work).
Warning: it may kill your X server suddenly.

%package full
Summary: Wine meta package
Summary(ru_RU.UTF-8): Мета пакет Wine
Group: Emulators
BuildArch: noarch
Requires: %name = %version-%release
Requires: lib%name-gl = %version-%release

Requires: wine-mono >= %mono_version
Requires: wine-gecko = %gecko_version

%description full
Wine meta package

%package -n lib%name
Summary: Main library for Wine
Group: System/Libraries
Conflicts: libwine

# Actually for x86_32
Requires: glibc-pthread glibc-nss

# Runtime linked
Requires: libcups libncurses
Requires: libXrender libXi libXext libX11 libICE
Requires: libssl
Requires: fontconfig libfreetype

%description -n lib%name
This package contains the library needed to run programs dynamically
linked with Wine.

%description -n lib%name -l ru_RU.UTF-8
Этот пакет состоит из библиотек, которые реализуют Windows API.


%package -n lib%name-gl
Summary: DirectX/OpenGL support libraries for Wine
Group: System/Libraries
Requires: lib%name = %version-%release
Conflicts: libwine-gl

Requires: libGL

%description -n lib%name-gl
This package contains the libraries for DirectX/OpenGL support in Wine.

%package -n lib%name-twain
Summary: Twain support library for Wine
Group: System/Libraries
Requires: lib%name = %version-%release
Conflicts: libwine-twain

%description -n lib%name-twain
This package contains the library for Twain support.


%package -n lib%name-devel
Summary: Headers for lib%name-devel
Group: Development/C
Requires: lib%name = %version-%release
Obsoletes: wine-devel
Provides: wine-devel
Conflicts: libwine-devel

%description -n lib%name-devel
lib%name-devel contains the header files and some utilities needed to
develop programs using lib%name.

%description -n lib%name-devel -l ru_RU.UTF-8
lib%name-devel содержит файлы для разработки программ, использующих Wine:
заголовочные файлы и утилиты, предназначенные
для компилирования программ с lib%name.

%package -n lib%name-devel-static
Summary: Static libraries for lib%name
Group: Development/C
Requires: lib%name = %version-%release
Conflicts: libwine-devel-static
Conflicts: libwine-devel

%description -n lib%name-devel-static
lib%name-devel-static contains the static libraries needed to
develop programs which make use of Wine.


%prep
%setup

%build
# Workaround for https://bugzilla.altlinux.org/show_bug.cgi?id=31834
%if_with build64
%remove_optflags -fomit-frame-pointer
%add_optflags -fno-omit-frame-pointer
%endif

%configure --with-x \
%if_with build64
	--enable-win64 \
%endif
	--disable-tests \
	--without-gstreamer

%__make depend
%make_build


%install
%makeinstall_std
install -m755 %SOURCE1 %buildroot%_bindir/winetricks
# unpack desktop files
cd %buildroot%_desktopdir
tar xvf %SOURCE2

# Do not pack non english man pages yet
rm -rf %buildroot%_mandir/*.UTF-8


%files
%doc ANNOUNCE AUTHORS LICENSE README
%lang(de) %doc documentation/README.de
%lang(es) %doc documentation/README.es
%lang(fr) %doc documentation/README.fr
%lang(hu) %doc documentation/README.hu
%lang(it) %doc documentation/README.it
%lang(ko) %doc documentation/README.ko
%lang(nb) %doc documentation/README.no
%lang(pt) %doc documentation/README.pt
%lang(pt_BR) %doc documentation/README.pt_br
%lang(tr) %doc documentation/README.tr

%if_without build64
%_bindir/wine
%_bindir/wine-preloader
%else
%_bindir/wine64
%_bindir/wine64-preloader
%endif

%_bindir/regsvr32
%_bindir/winecfg

%_bindir/winetricks
%_bindir/wineconsole
%_bindir/wineserver

%_bindir/msiexec
%_bindir/notepad
%_bindir/regedit
%_bindir/winedbg
%_bindir/wineboot
%_bindir/winefile
%_bindir/winemine
%_bindir/winepath
%_libdir/wine/*.exe.so

#%_initdir/wine
#%_initdir/wine.outformat
%_desktopdir/*

%if_without build64
%_man1dir/wine.*
%endif
%_man1dir/msiexec.*
%_man1dir/notepad.*
%_man1dir/regedit.*
%_man1dir/regsvr32.*
%_man1dir/wineboot.*
%_man1dir/winecfg.*
%_man1dir/wineconsole.*
%_man1dir/winefile.*
%_man1dir/winemine.*
%_man1dir/winepath.*
%_man1dir/wineserver.*
%_man1dir/winedbg.*

%files -n lib%name
%doc LICENSE AUTHORS COPYING.LIB
%_libdir/libwine*.so.*
%dir %_libdir/wine/
%_libdir/wine/fakedlls/

%if_without build64
%_libdir/wine/*.dll16.so
%_libdir/wine/*.drv16.so
%_libdir/wine/*.exe16.so
%_libdir/wine/winoldap.mod16.so
%_libdir/wine/*.vxd.so
%endif

%_libdir/wine/*.cpl.so
%_libdir/wine/*.drv.so
%_libdir/wine/*.dll.so
%_libdir/wine/*.acm.so
%_libdir/wine/*.ocx.so
%_libdir/wine/*.tlb.so
%_libdir/wine/*.sys.so

%dir %_datadir/wine/
%_datadir/wine/wine.inf
%_datadir/wine/l_intl.nls
%_datadir/wine/fonts/

# move to separate packages
%exclude %_libdir/wine/twain*
%exclude %_libdir/wine/d3d10.dll.so
%exclude %_libdir/wine/d3d8.dll.so
%exclude %_libdir/wine/d3d9.dll.so
%exclude %_libdir/wine/d3dxof.dll.so
%exclude %_libdir/wine/opengl32.dll.so
%exclude %_libdir/wine/glu32.dll.so
%exclude %_libdir/wine/wined3d.dll.so

%files full

%files -n lib%name-twain
%_libdir/wine/twain*
%_libdir/wine/gphoto2.ds.so
%_libdir/wine/sane.ds.so

%files -n lib%name-gl
%_libdir/wine/d3d10.dll.so
%_libdir/wine/d3d8.dll.so
%_libdir/wine/d3d9.dll.so
%_libdir/wine/d3dxof.dll.so
%_libdir/wine/opengl32.dll.so
%_libdir/wine/glu32.dll.so
%_libdir/wine/wined3d.dll.so

%files -n lib%name-devel
%doc LICENSE LICENSE.OLD
%_bindir/function_grep.pl
%_bindir/winebuild
%_bindir/wmc
%_bindir/wrc
%_bindir/widl
%_bindir/wineg++
%_bindir/winegcc
%_bindir/winecpp
%_bindir/winedump
%_bindir/winemaker

%_includedir/wine/
%_libdir/lib*.so
%_libdir/wine/lib*.def
%_libdir/wine/libwinecrt0.a
#%_aclocaldir/wine.m4

%_man1dir/wmc.*
%_man1dir/wrc.*
%_man1dir/widl.*
%_man1dir/winebuild.*
%_man1dir/winedump.*
%_man1dir/wineg++.*
%_man1dir/winegcc.*
%_man1dir/winecpp.*
%_man1dir/winemaker.*


%files -n lib%name-devel-static
%_libdir/wine/lib*.a
%exclude %_libdir/wine/libwinecrt0.a

%changelog
