# vim: set ft=spec: -*- rpm-spec -*-

# Wireshark has huge number of plugins that are not linked against most of the external libraries
# as they are loaded into wireshark/tshark processes which guarantee that linkage
%set_verify_elf_method unresolved=relaxed

Name: wireshark
Version: 2.2.7
Release: alt1%ubt

Summary: The BugTraq Award Winning Network Traffic Analyzer
Group: Monitoring
License: GPL
Url: http://www.wireshark.org/

Source: http://www.wireshark.org/download/src/%name-%version.tar
Source2: %name.control
Source3: %name.watch

Patch: %name-%version-alt.patch

# Automatically added by buildreq on Sun Dec 23 2007
BuildRequires: control doxygen flex gcc-c++ libadns-devel libcap-devel libcom_err-devel libgnutls-openssl-devel libgcrypt-devel zlib-devel
BuildRequires: libkrb5-devel libpcap-devel libpcre-devel libportaudio2-devel libssl-devel python unzip xml-utils xsltproc perl-Pod-Parser perl-devel
BuildRequires: liblua5-devel < 5.3.0
BuildRequires: libgtk+3-devel
BuildRequires: qt5-base-devel qt5-tools
BuildRequires(pre):rpm-build-ubt

%package base
Summary: Wireshark base package
Group: Monitoring
Obsoletes: ethereal-libs < 0.10.10
Obsoletes: ethereal-base
Conflicts: libwiretap < %version-%release
Conflicts: libwiretap > %version-%release

%package gtk+
Summary: GTK+ GUI for Wireshark package
Group: Monitoring
Requires: %name-base = %version-%release
Provides: %name = %version-%release
Requires: url_handler
Obsoletes: ethereal
Obsoletes: ethereal-gtk+

%package qt5
Summary: QT5 GUI for Wireshark package
Group: Monitoring
Requires: %name-base = %version-%release
Provides: %name = %version-%release
Requires: url_handler
Obsoletes: ethereal

%package -n tshark
Summary: Console GUI for Wireshark package
Group: Monitoring
Requires: %name-base = %version-%release
Obsoletes: tethereal

%package doc
Summary: Wireshark User's Guide
Group: Documentation
License: FDL
BuildArch: noarch
Conflicts: %name-base < %version-%release
Conflicts: %name-base > %version-%release
Obsoletes: ethereal-doc

%package -n libwiretap
Summary: A future replacement for libpcap
Group: System/Libraries

%package -n libwiretap-devel
Summary: Development environment for Wiretap library
Group: Development/C
Requires: libwiretap = %version-%release
Obsoletes: %name-devel

%description
Wireshark (formerly Ethereal) is a network protocol analyzer, or
"packet sniffer", that lets you capture and interactively browse
the contents of network frames. The goal of the project is to
create a commercial-quality packet analyzer for Unix, and the
most useful packet analyzer on any platform.

%description base
Wireshark (formerly Ethereal) is a network protocol analyzer, or
"packet sniffer", that lets you capture and interactively browse
the contents of network frames. The goal of the project is to
create a commercial-quality packet analyzer for Unix, and the
most useful packet analyzer on any platform.

This package lays base for libpcap, a packet capture and filtering
library, contains command-line utilities, plugins and documentation
for wireshark. A graphical user interface is packaged separately to
GTK+/QT5 packages.

%description gtk+
This package contains GTK+ GUI ie. the wireshark -- application.

%description qt5
This package contains QT5 GUI ie. the wireshark -- application.

%description -n tshark
This package contains console wireshark application.

%description doc
Wireshark is one of those programs that many network managers
would love to be able to use, but they are often prevented from
getting what they would like from Wireshark because of the lack
of documentation.

This document is part of an effort by the Wireshark team to
improve the usability of Wireshark. 

%description -n libwiretap
Wiretap is a library that is being developed as a future replacement for
libpcap, the current standard Unix library for packet capturing.

%description -n libwiretap-devel
Wiretap is a library that is being developed as a future replacement for
libpcap, the current standard Unix library for packet capturing.

This package contains development files needed to develop wiretap-based
applications.

%prep
%setup
%patch -p1

%build
%add_optflags -I%_includedir/pcre
./autogen.sh

export ac_cv_path_HTML_VIEWER=url_handler.sh
# Workaround for Lua 5.1 detection
export ac_cv_lib_lualib_luaL_openlib=no

chmod ugo+rx configure
%configure \
   --sysconfdir=%_sysconfdir/%name \
   --disable-static \
   --enable-shared \
   --disable-warnings-as-errors \
   --with-qt=5 \
   --with-gtk3=yes \
   --enable-wireshark \
   --enable-tshark \
   --enable-editcap \
   --enable-capinfos \
   --enable-mergecap \
   --enable-text2pcap \
   --enable-dftest \
   --enable-randpkt \
   --enable-dumpcap \
   --enable-rawshark \
   --disable-androiddump \
   --enable-ipv6 \
   --disable-setuid-install \
   \
   --with-gnu-ld \
   --with-pic \
   --with-gnutls \
   --with-gcrypt \
   --without-libsmi \
   --with-pcap \
   --with-pcap-remote \
   --with-zlib \
   --with-lua \
   --with-portaudio \
   --with-libcap \
   --with-ssl \
   --with-krb5 \
   --with-adns \
   --with-plugins=%_libdir/%name/plugins/%version \
   \
   CPPFLAGS="$CPPFLAGS -I%_includedir/pcre"
%make_build

%install
%make_install install DESTDIR=%buildroot
rm -f %buildroot%_libdir/%name/plugins/%version/*.la

mkdir -p %buildroot{%_controldir,%_menudir,%_datadir/applications,%_niconsdir,%_liconsdir,%_miconsdir}
cp -p wireshark.desktop %buildroot%_datadir/applications/%name-qt5.desktop
cp -p image/hi16-app-wireshark.png %buildroot%_miconsdir/wireshark.png
cp -p image/hi32-app-wireshark.png %buildroot%_niconsdir/wireshark.png
cp -p image/hi48-app-wireshark.png %buildroot%_liconsdir/wireshark.png

mkdir -p %buildroot%_includedir/wiretap
install -p -m644 wiretap/wtap.h %buildroot%_includedir/wiretap/wtap.h

install -p -m755 %_sourcedir/%name.control %buildroot%_controldir/%name-capture

# Rename qt5 binary:
mv -v %buildroot%_bindir/%name %buildroot%_bindir/%name-qt5

# Make alternatives:
mkdir -p %buildroot%_altdir
cat <<'_EOF'_ > %buildroot%_altdir/%name-gtk
%_bindir/%name	%_bindir/%name-gtk	10
_EOF_

cat <<'_EOF'_ > %buildroot%_altdir/%name-qt5
%_bindir/%name	%_bindir/%name-qt5	20
_EOF_

%pre base
%pre_control %name-capture

%post base
%post_control -s relaxed %name-capture

%files base
%doc AUTHORS COPYING ChangeLog INSTALL NEWS README* doc/README.*
%config %_controldir/%name-capture
%_bindir/capinfos
%_bindir/captype
%_bindir/dftest
%attr(700,root,root) %verify(not mode,group) %_bindir/dumpcap
%_bindir/editcap
%_bindir/mergecap
%_bindir/randpkt
%_bindir/rawshark
%_bindir/text2pcap
%_bindir/reordercap
%_man1dir/capinfos.*
%_man1dir/randpkt.*
%_man1dir/randpktdump.*
%_man1dir/dftest.*
%_man1dir/dumpcap.*
%_man1dir/editcap.*
%_man1dir/mergecap.*
%_man1dir/rawshark.*
%_man1dir/text2pcap.*
%_man1dir/reordercap.*
%_man4dir/wireshark-filter.*
%_man4dir/extcap.*
%_datadir/%name
%dir %_libdir/%name
%dir %_libdir/%name/plugins
%dir %_libdir/%name/plugins/%version/
%dir %_libdir/%name/extcap
%_libdir/%name/extcap/*
%_libdir/%name/plugins/%version/*
%_libdir/lib%name.so.*
%_libdir/libwsutil.so.*
%_libdir/libwscodecs.so.*
%_man1dir/wireshark.*
%_miconsdir/wireshark.png
%_niconsdir/wireshark.png
%_liconsdir/wireshark.png
%_xdgmimedir/packages/%name.xml

%files gtk+
%_altdir/%name-gtk
%_bindir/wireshark-gtk
%_datadir/applications/%name-gtk.desktop
%_datadir/appdata/%name.appdata.xml

%files qt5
%_altdir/%name-qt5
%_bindir/wireshark-qt5
%_datadir/applications/%name-qt5.desktop

%files -n tshark
%_bindir/tshark
%_man1dir/tshark.*

%files doc
%doc wsug_html_chunked/*

%files -n libwiretap
%_libdir/libwiretap.so.*

%files -n libwiretap-devel
%_includedir/wiretap
%_libdir/libwiretap.so

%changelog
