%define wxbranch 2.9
%define ucode u
%def_disable debug
%def_enable unicode

%if_disabled unicode
%define ucode %{-E}
%endif

Name: wxGTK2.9
Version: %wxbranch.5
Release: alt3.svn20120816
Epoch: 2

Summary: The GTK+ port of the wxWidgets library
License: wxWidgets License
Group: System/Libraries
Url: http://wxwidgets.org

Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

Source: %name-%version.tar
Source2: ld_shared_wrapper.pl

# Automatically added by buildreq on Wed Dec 10 2008
BuildRequires: gcc-c++ libGL-devel libSDL-devel libSM-devel
BuildRequires: libXinerama-devel libesd-devel libexpat-devel
BuildRequires: libjpeg-devel libtiff-devel libgtk+2-devel

BuildPreReq: xorg-xextproto-devel xorg-inputproto-devel libXtst-devel
BuildPreReq: rpm-build-java libXxf86vm-devel libbfd-devel
BuildPreReq: libstdc++-devel gstreamer-devel gst-plugins-devel
BuildPreReq: libGConf-devel gst-plugins-devel libpng-devel

%description
wxWidgets is a free C++ library for cross-platform GUI development.
With wxWidgets, you can create applications for different GUIs
(GTK+, Motif/LessTif, MS Windows, Mac) from the same source code.

This is a GTK+ port.

%package -n lib%name
Summary: The GTK+ port of the wxWidgets library
Group: System/Libraries

%description -n lib%name
Header files for wxGTK, the GTK+ port of the wxWidgets library.

%package -n lib%name-devel
Summary: Development files for wxGTK library
Group: Development/C++
Requires: lib%name = %epoch:%version-%release
Requires: python-module-PyDSTool
%add_python_req_skip utils
Conflicts: wxGTK2-devel
Conflicts: wxGTK-devel
Conflicts: libwxGTK-devel
Conflicts: wxGTK2u-devel

%description -n lib%name-devel
Header files for wxGTK, the GTK+ port of the wxWidgets library.

%package -n lib%name-devel-static
Summary: The GTK+ port of the wxWidgets library
Group: Development/C++
Requires: lib%name-devel = %epoch:%version-%release

%description -n lib%name-devel-static
Header files for wxGTK, the GTK+ port of the wxWidgets library.

%if_enabled debug
%package -n lib%name-debug
Summary: The GTK+ port of the wxWidgets library build with debug
Group: System/Libraries

%description -n lib%name-debug
Debug library for wxGTK, the GTK+ port of the wxWidgets library.

%package -n lib%name-debug-devel
Summary: Development files for wxGTK library
Group: Development/C++
Requires: lib%name-debug = %epoch:%version-%release
Requires: lib%name = %epoch:%version-%release

%description -n lib%name-debug-devel
Development files for wxGTK, the GTK+ port of the wxWidgets library.

%package -n lib%name-debug-devel-static
Summary: The GTK+ port of the wxWidgets library
Group: Development/C++
Requires: lib%name-debug-devel = %epoch:%version-%release

%description -n lib%name-debug-devel-static
Static library for wxGTK, the GTK+ port of the wxWidgets library.
%endif

%package examples
Summary: wxGTK example programs
Group: Development/C++
BuildArch: noarch
Requires: lib%name-devel = %epoch:%version-%release

%description examples
wxGTK example programs.

%prep
%setup
subst "s,bakefile/presets,bakefile/presets-\$(WX_RELEASE),g" Makefile.in

%build
%if_enabled debug
DIRS="shared_release shared_debug static_release static_debug"
%else
DIRS="shared_release static_release"
%endif
for dist in $DIRS ; do
    case $dist in
	shared_release)
	    CONF_FLAG="--enable-shared --without-debug_flag --without-debug_info"
	;;
	shared_debug)
	    CONF_FLAG="--enable-shared --enable-debug"
	;;
	static_release)
	    CONF_FLAG="--disable-shared --without-debug_flag --without-debug_info"
	;;
	static_debug)
	    CONF_FLAG="--disable-shared --enable-debug"
	;;
    esac

./autogen.sh
mkdir $dist && cd $dist
%define _configure_script ../configure
GST_CFLAGS="$(pkg-config --cflags gstreamer-0.10)"
export LIBS="-lX11"
DEFS="-DUNICODE=1 -DwxUSE_UNICODE=1"
%add_optflags -fno-strict-aliasing $GST_CFLAGS $DEFS
%configure $CONF_FLAG \
	--with-sdl \
	--enable-unicode \
	--enable-optimise \
	--with-regex=yes \
	--disable-rpath \
	--without-subdirs \
	--without-odbc \
	--with-opengl \
	--disable-joystick \
	--enable-plugins \
	--enable-precomp-headers=yes \
	--enable-compat26 \
	--enable-gtk2=yes \
	--enable-sound \
	--enable-soname \
	--enable-mediactrl \
	--enable-stc \
	--enable-gui \
	--with-xresources \
	--without-gnomeprint \
	--enable-graphics_ctx \
	--enable-utf8=yes \
	--enable-utf8only=no

%make_build SHARED_LD_CXX='perl %SOURCE2 $(CXX) -shared -fPIC -g -o'
cd ..
done

%install
%if_enabled debug
DIRS="shared_debug static_release static_debug shared_release"
%else
DIRS="static_release shared_release"
%endif
for dist in $DIRS ; do
  %makeinstall_std -C $dist
done
mkdir -p %buildroot%_datadir/wx/examples/src
cp -a demos samples %buildroot%_datadir/wx/examples

wx_config_filename=$(basename %buildroot%_libdir/wx/config/*-unicode-[0-9]*)
ln -sf ../..%_libdir/wx/config/$wx_config_filename %buildroot%_bindir/wx-config

%files -n lib%name
%_libdir/libwx_base%ucode-%wxbranch.so.*
%_libdir/libwx_base%{ucode}_net-%wxbranch.so.*
%_libdir/libwx_gtk2%{ucode}_adv-%wxbranch.so.*
%_libdir/libwx_gtk2%{ucode}_aui-%wxbranch.so.*
%_libdir/libwx_gtk2%{ucode}_richtext-%wxbranch.so.*
%_libdir/libwx_gtk2%{ucode}_core-%wxbranch.so.*
%_libdir/libwx_gtk2%{ucode}_html-%wxbranch.so.*
%_libdir/libwx_gtk2%{ucode}_xrc-%wxbranch.so.*
%_libdir/libwx_gtk2%{ucode}_qa-%wxbranch.so.*
%_libdir/libwx_gtk2%{ucode}_gl-%wxbranch.so.*
%_libdir/libwx_base%{ucode}_xml-%wxbranch.so.*
%_libdir/libwx_gtk2%{ucode}_stc-%wxbranch.so.*
%_libdir/libwx_gtk2%{ucode}_propgrid-%wxbranch.so.*
%_libdir/libwx_gtk2%{ucode}_ribbon-%wxbranch.so.*
%_libdir/libwx_gtk2%{ucode}_media-%wxbranch.so.*

%files -n lib%name-devel
%_libdir/wx/config/gtk2-unicode-%wxbranch
%dir %_libdir/wx/include/gtk2-unicode-%wxbranch
%_libdir/wx/include/gtk2-unicode-%wxbranch/wx
%doc docs/*
%dir %_datadir/bakefile
%_datadir/bakefile/*
%_bindir/*
%_libdir/wx/%version/sound_sdl%ucode-%version.so
%_datadir/aclocal/*.m4
%dir %_includedir/wx-%wxbranch
%dir %_includedir/wx-%wxbranch/wx
%_includedir/wx-%wxbranch/wx/generic
%_includedir/wx-%wxbranch/wx/gtk
%_includedir/wx-%wxbranch/wx/html
%_includedir/wx-%wxbranch/wx/protocol
%_includedir/wx-%wxbranch/wx/unix
%_includedir/wx-%wxbranch/wx/xrc
%_includedir/wx-%wxbranch/wx/propgrid
%_includedir/wx-%wxbranch/wx/persist
%_includedir/wx-%wxbranch/wx/meta
%_includedir/wx-%wxbranch/wx/*.h
%_includedir/wx-%wxbranch/wx/*.cpp
%_includedir/wx-%wxbranch/wx/aui
%_includedir/wx-%wxbranch/wx/richtext
%_includedir/wx-%wxbranch/wx/xml
%_includedir/wx-%wxbranch/wx/stc
%_includedir/wx-%wxbranch/wx/ribbon
%_libdir/libwx_base%{ucode}-%wxbranch.so
%_libdir/libwx_base%{ucode}_net-%wxbranch.so
%_libdir/libwx_gtk2%{ucode}_adv-%wxbranch.so
%_libdir/libwx_gtk2%{ucode}_core-%wxbranch.so
%_libdir/libwx_gtk2%{ucode}_html-%wxbranch.so
%_libdir/libwx_gtk2%{ucode}_aui-%wxbranch.so
%_libdir/libwx_gtk2%{ucode}_richtext-%wxbranch.so
%_libdir/libwx_gtk2%{ucode}_gl-%wxbranch.so
%_libdir/libwx_gtk2%{ucode}_xrc-%wxbranch.so
%_libdir/libwx_gtk2%{ucode}_qa-%wxbranch.so
%_libdir/libwx_base%{ucode}_xml-%wxbranch.so
%_libdir/libwx_gtk2%{ucode}_stc-%wxbranch.so
%_libdir/libwx_gtk2%{ucode}_propgrid-%wxbranch.so
%_libdir/libwx_gtk2%{ucode}_ribbon-%wxbranch.so
%_libdir/libwx_gtk2%{ucode}_media-%wxbranch.so

%files -n lib%name-devel-static
%_libdir/wx/config/gtk2-unicode-static-%wxbranch
%dir %_libdir/wx/include/gtk2-unicode-static-%wxbranch
%_libdir/wx/include/gtk2-unicode-static-%wxbranch/wx
%_libdir/libwx_base%{ucode}-%wxbranch.a
%_libdir/libwx_base%{ucode}_net-%wxbranch.a
%_libdir/libwx_gtk2%{ucode}_adv-%wxbranch.a
%_libdir/libwx_gtk2%{ucode}_core-%wxbranch.a
%_libdir/libwx_gtk2%{ucode}_html-%wxbranch.a
%_libdir/libwx_gtk2%{ucode}_aui-%wxbranch.a
%_libdir/libwx_gtk2%{ucode}_richtext-%wxbranch.a
%_libdir/libwx_gtk2%{ucode}_gl-%wxbranch.a
%_libdir/libwx_gtk2%{ucode}_xrc-%wxbranch.a
%_libdir/libwx_gtk2%{ucode}_qa-%wxbranch.a
%_libdir/libwx_base%{ucode}_xml-%wxbranch.a
%_libdir/libwx_gtk2%{ucode}_stc-%wxbranch.a
%_libdir/libwx_gtk2%{ucode}_propgrid-%wxbranch.a
%_libdir/libwx_gtk2%{ucode}_ribbon-%wxbranch.a
%_libdir/libwx_gtk2%{ucode}_media-%wxbranch.a
%_libdir/libwxregex%{ucode}-%wxbranch.a
%_libdir/libwxscintilla-%wxbranch.a

%if_enabled debug
%files -n lib%name-debug
%_libdir/libwx_base%{ucode}d-%wxbranch.so.*
%_libdir/libwx_base%{ucode}d_net-%wxbranch.so.*
%_libdir/libwx_gtk2%{ucode}d_adv-%wxbranch.so.*
%_libdir/libwx_gtk2%{ucode}d_aui-%wxbranch.so.*
%_libdir/libwx_gtk2%{ucode}d_richtext-%wxbranch.so.*
%_libdir/libwx_gtk2%{ucode}d_core-%wxbranch.so.*
%_libdir/libwx_gtk2%{ucode}d_html-%wxbranch.so.*
%_libdir/libwx_gtk2%{ucode}d_xrc-%wxbranch.so.*
%_libdir/libwx_gtk2%{ucode}d_qa-%wxbranch.so.*
%_libdir/libwx_gtk2%{ucode}d_gl-%wxbranch.so.*
%_libdir/libwx_base%{ucode}d_xml-%wxbranch.so.*
%_libdir/libwx_gtk2%{ucode}d_stc-%wxbranch.so.*
%_libdir/libwx_gtk2%{ucode}d_propgrid-%wxbranch.so.*
%_libdir/libwx_gtk2%{ucode}d_ribbon-%wxbranch.so.*

%files -n lib%name-debug-devel
%_libdir/wx/%version/sound_sdl%{ucode}d-%version.so
%_libdir/libwx_base%{ucode}d-%wxbranch.so
%_libdir/libwx_base%{ucode}d_net-%wxbranch.so
%_libdir/libwx_gtk2%{ucode}d_adv-%wxbranch.so
%_libdir/libwx_gtk2%{ucode}d_core-%wxbranch.so
%_libdir/libwx_gtk2%{ucode}d_html-%wxbranch.so
%_libdir/libwx_gtk2%{ucode}d_aui-%wxbranch.so
%_libdir/libwx_gtk2%{ucode}d_richtext-%wxbranch.so
%_libdir/libwx_gtk2%{ucode}d_gl-%wxbranch.so
%_libdir/libwx_gtk2%{ucode}d_xrc-%wxbranch.so
%_libdir/libwx_gtk2%{ucode}d_qa-%wxbranch.so
%_libdir/libwx_base%{ucode}d_xml-%wxbranch.so
%_libdir/libwx_gtk2%{ucode}d_stc-%wxbranch.so
%_libdir/libwx_gtk2%{ucode}d_propgrid-%wxbranch.so
%_libdir/libwx_gtk2%{ucode}d_ribbon-%wxbranch.so

%files -n lib%name-debug-devel-static
%_libdir/libwx_base%{ucode}d-%wxbranch.a
%_libdir/libwx_base%{ucode}d_net-%wxbranch.a
%_libdir/libwx_gtk2%{ucode}d_adv-%wxbranch.a
%_libdir/libwx_gtk2%{ucode}d_core-%wxbranch.a
%_libdir/libwx_gtk2%{ucode}d_html-%wxbranch.a
%_libdir/libwx_gtk2%{ucode}d_aui-%wxbranch.a
%_libdir/libwx_gtk2%{ucode}d_richtext-%wxbranch.a
%_libdir/libwx_gtk2%{ucode}d_gl-%wxbranch.a
%_libdir/libwx_gtk2%{ucode}d_xrc-%wxbranch.a
%_libdir/libwx_gtk2%{ucode}d_qa-%wxbranch.a
%_libdir/libwx_base%{ucode}d_xml-%wxbranch.a
%_libdir/libwx_gtk2%{ucode}d_stc-%wxbranch.a
%_libdir/libwx_gtk2%{ucode}d_ribbon-%wxbranch.a
%_libdir/libwx_gtk2%{ucode}d_propgrid-%wxbranch.a
%_libdir/libwxregex%{ucode}d-%wxbranch.a
#_libdir/libwxscintillad-%wxbranch.a
%endif

%files examples
%_datadir/wx/examples

%changelog
