Name: x11vnc
Version: 0.9.12
Release: alt3

%def_without avahi

Summary: VNC server for real X displays
License: GPL
Group: Networking/Remote access
Url: http://www.karlrunge.com/x11vnc/
Packager: Maxim Ivanov <redbaron@altlinux.org>

Source: %name-%version.tar
Patch: libvncserver-c656b381fd8158aa73173c157b1492d1014e13f0.patch

BuildRequires: libjpeg-devel zlib-devel libssl-devel libXdamage-devel libXinerama-devel libXrandr-devel libXtst-devel libXt-devel
%if_with avahi
BuildRequires: libavahi-devel
%endif

%description
x11vnc allows one to remotely view and interact with real X displays
(i.e. a display corresponding to a physical monitor, keyboard, and mouse)
with any VNC viewer. In this way it plays the role for Unix/X11 that
WinVNC plays for Windows.

%prep
%setup
%patch -p1

# rfb carries around an ancient keysym.h from year 98. When included together
# with the current keysymdef.h, it generates loads of warnings.
# However, a careful comparison of the headers shows that replacing
# the old one with the new one will only introduce new macros, without
# changing or removing old ones. Therefore it should be safe to do this:
rm rfb/keysym.h
echo '#include <X11/keysym.h>' >rfb/keysym.h

%build
%configure --without-uinput
%make_build

%install
%makeinstall

%files
%_bindir/%name
%_man1dir/%name.*
%_datadir/%name
%_desktopdir/*
%doc README NEWS

%changelog
