Name: xbmc
Version: 13.2
Release: alt0.M70P.1

Summary: XBMC Media Center
License: GPL
Group: Video
Url: http://xbmc.org

Requires: xbmc-data = %version-%release

Source0: %name-%version-%release.tar
Source1: pvr-addons.tar
Source2: xvdr.tar

BuildRequires: cmake gcc-c++ doxygen swig gperf nasm unzip zip
BuildRequires: boost-devel bzlib-devel libmysqlclient-devel libSDL_image-devel libSDL_mixer-devel
BuildRequires: libXScrnSaver-devel libXau-devel libXcomposite-devel libXcursor-devel
BuildRequires: libXdmcp-devel libXext-devel libXft-devel libXinerama-devel libXmu-devel
BuildRequires: libXpm-devel libXrandr-devel libXt-devel libXtst-devel libSM-devel libxkbfile-devel
BuildRequires: libX11-devel libXfixes-devel libXrender-devel xorg-xproto-devel
BuildRequires: libalsa-devel libass-devel libavahi-devel libbluray-devel libcap-devel
BuildRequires: libcec-devel libcdio-devel libcurl-devel libdbus-devel libenca-devel
BuildRequires: libexpat-devel libfaad-devel libflac-devel libfreetype-devel libfribidi-devel
BuildRequires: libjasper-devel libjpeg-devel liblzo2-devel libyajl-devel libmad-devel
BuildRequires: libmicrohttpd-devel libmms-devel libmodplug-devel libmpeg2-devel
BuildRequires: libpcrecpp-devel libpng-devel libsamplerate-devel libsmbclient-devel
BuildRequires: libsqlite3-devel libtiff-devel libvorbis-devel libwavpack-devel
BuildRequires: libplist-devel libpulseaudio-devel libssh-devel librtmp-devel python-devel
BuildRequires: libbluez-devel libtag-devel tinyxml-devel libudev-devel
BuildRequires: fontconfig-devel libgcrypt-devel liblame-devel libxml2-devel libxslt-devel
BuildRequires: java-1.7.0-openjdk-devel /proc zlib-devel

%ifarch %ix86 x86_64
BuildRequires: libva-devel libvdpau-devel libGL-devel libGLU-devel libglew-devel
%endif
%ifarch %arm
BuildRequires: libEGL-devel libGLES-devel
%endif

%package data
Summary: XBMC architecture-independent data
Group: Video
BuildArch: noarch

%description
XBMC Media Center is an media-player and entertainment hub for all your digital media.

%description data
XBMC Media Center is an media-player and entertainment hub for all your digital media.
This package contains all architecture-independent data requried for XBMC.

%define docdir %_defaultdocdir/%name-%version

%prep
%setup -a1 -a2
touch xvdr/{NEWS,AUTHORS,ChangeLog}
sed -i s,build_addons_with_dependencies=no,build_addons_with_dependencies=yes, pvr-addons/configure.ac

%build
[ ! -x bootstrap ] || sh bootstrap
%configure --disable-non-free \
	--enable-external-libraries \
	--enable-pulse \
	--with-lirc-device=/var/run/lirc/lircd \
%ifarch %arm
	--enable-gles \
	--disable-projectm \
%endif
	--enable-addons-with-dependencies \
	#

%make_build

%install
make \
    DESTDIR=%buildroot \
    bindir=%_bindir \
    libdir=%_libdir \
    datadir=%_datadir install

cd %buildroot%_datadir/xbmc/addons && find pvr.vdr.xvdr -type f -name \*.pvr |\
	cpio -pmd %buildroot%_libdir/xbmc/addons/
rm -f %buildroot%_datadir/xbmc/addons/pvr.vdr.xvdr/*.pvr

rm -rf \
    %buildroot%_datadir/xbmc/addons/library.xbmc.* \
    %buildroot%_datadir/xbmc/system/players/dvdplayer/etc \
    %buildroot%_datadir/xbmc/system/players/paplayer

mv %buildroot%_datadir/doc/xbmc %buildroot%docdir

mkdir -p \
    %buildroot%_sysconfdir/sysconfig \
    %buildroot%_sysconfdir/X11/wmsession.d \
    %buildroot%_libdir/xbmc/system/players/paplayer/timidity

cat >%buildroot%_libdir/xbmc/system/players/paplayer/timidity/timidity.cfg << 'E_O_F'
dir /usr/share/timidity
source midia.cfg
E_O_F

cat >%buildroot%_sysconfdir/X11/wmsession.d/20XBMC << 'E_O_F'
NAME=XBMC
ICON=/usr/share/xbmc/media/icon32x32.png
DESC=XBMC Media Center
EXEC=/usr/bin/xbmc-standalone
SCRIPT:
exec /usr/bin/xbmc-standalone
E_O_F

cat >%buildroot%_bindir/xbmc << 'E_O_F'
#!/bin/sh
FEH="%_datadir/xbmc/FEH.py"

[ ! -f "$FEX" ] || {
    python "$FEH" "$@"
    [ $? -eq 0 ] || exit $?
}

exec %_libdir/xbmc/xbmc.bin "$@"
E_O_F

cat >%buildroot%_bindir/xbmc-standalone << 'E_O_F'
#!/bin/sh
while ! %_libdir/xbmc/xbmc.bin -fs --standalone; do :; done
E_O_F

%add_python_req_skip xbmc
%add_python_req_skip xbmcgui
%add_python_req_skip xbmcaddon
%add_python_req_skip xbmcvfs

%set_verify_elf_method textrel=relaxed

%files
%docdir

%config(noreplace) %_sysconfdir/X11/wmsession.d/20XBMC

%_bindir/xbmc
%_bindir/xbmc-standalone

%_datadir/xsessions/XBMC.desktop
%_desktopdir/xbmc.desktop
%_iconsdir/hicolor/*/apps/xbmc.png

%dir %_libdir/xbmc

%_libdir/xbmc/system
%_libdir/xbmc/addons

%_libdir/xbmc/xbmc.bin
%_libdir/xbmc/xbmc-xrandr

%files data
%dir %_datadir/xbmc
%_datadir/xbmc/FEH.py
%_datadir/xbmc/addons
%_datadir/xbmc/language
%_datadir/xbmc/media
%_datadir/xbmc/sounds
%_datadir/xbmc/system
%_datadir/xbmc/userdata

%changelog
