%define ver_major 2.8

Name: xchat
Version: %ver_major.6
Release: alt3.1

Summary: Graphical IRC client
Summary(ru_RU.UTF-8): Графический IRC клиент

Group: Networking/IRC

License: %gpl2plus
URL: http://www.xchat.org/

Packager: Egor Vyscrebentsov <evyscr@altlinux.org>

Source: http://www.xchat.org/files/source/%ver_major/%name-%version.tar

Provides: xchat2 = %version-%release
Obsoletes: xchat2

# Upstream patches
Patch0: %name-2.8.6-alt1.patch
Patch1: %name-2.8.6-sf-gtk.patch
Patch2: %name-2.8.6-alt-desktop.patch
Patch3: %name-2.8.6-enable_deprecated.patch
Patch4: %name-2.8.6-alt-glib2-2.32.3.patch

Source2: %name.xpm
Source4: %name-wmconfig
Source5: %name-16.png
Source6: %name-32.png
Source7: %name-48.png

Source9: xchat-README.ALT.utf-8

%define xchatlibdir %_libdir/%name
%define xchatpluginsdir %xchatlibdir/plugins

BuildRequires(pre): rpm-build-licenses

# Automatically added by buildreq on Tue Oct 11 2011
BuildRequires: GConf libXext-devel libsexy-devel libssl-devel perl-devel python-devel tcl-devel

%description
X-Chat is yet another IRC client for the X Window System, using the Gtk2+
toolkit. It is pretty easy to use compared to the other Gtk2+ IRC clients and
the interface is quite nicely designed.

%description -l ru_RU.UTF-8
X-Chat - это отличный IRC клиент для системы X Window, использующий набор
инструментов GTK2+. Прекрасный дизайн интерфейса, удобные функции и легкие
настройки являются отличительной особенностью этого приложения для общения.

%prep
%setup -n %name-%version

%patch0 -p1
%patch1 -p1
%patch2 -p2
%patch3 -p2
%patch4 -p2

touch NEWS
touch ABOUT-NLS

%autoreconf

%build
export GUI_LIBS="-lgmodule-2.0"
%configure \
    --disable-gnome \
    --disable-dbus \
    --enable-tcl=%_libdir \
    --enable-shm \
    --enable-spell=libsexy \
    xchatlibdir=%xchatlibdir
%make

%install
%makeinstall

# plugins
mkdir -p %buildroot%xchatpluginsdir
for i in python.so perl.so tcl.so; do
	mv %buildroot%_libdir/$i %buildroot%xchatpluginsdir/
done
rm -f %buildroot%_libdir/*.la

# wmconfig
mkdir -p %buildroot/etc/X11/wmconfig
install -m 644 %SOURCE4 %buildroot/etc/X11/wmconfig/%name

# icons
mkdir -p %buildroot{%_miconsdir,%_niconsdir,%_liconsdir}/
install -m 644 %SOURCE5 %buildroot%_miconsdir/%name.png
install -m 644 %SOURCE6 %buildroot%_niconsdir/%name.png
install -m 644 %SOURCE7 %buildroot%_liconsdir/%name.png

cp -a %SOURCE9 ./README.ALT.utf-8

%find_lang %name

%files -f %name.lang
%doc README ChangeLog HACKING INSTALL faq.html README.ALT.utf-8 plugins/plugin20.html
%_bindir/%name
/etc/X11/wmconfig/xchat
%_datadir/pixmaps/%name.*
%_desktopdir/*.desktop
%_niconsdir/%name.png
%_miconsdir/%name.png
%_liconsdir/%name.png
%dir %xchatlibdir
%dir %xchatpluginsdir
%xchatpluginsdir/*.so

%changelog
