Name: xdg-utils
Version: 1.1.0
Release: alt11

Summary: A set of command line tools that assist applications with a variety of desktop integration tasks
License: MIT
Group: System/Base

Url: http://portland.freedesktop.org/wiki/XdgUtils
Source: %name-%version.tar
Patch0: added-xdg-su-1.1.0rc1-alt.patch
Patch1: xdg-open-opera.patch
Patch2: xdg-su-added-lxde-and-gksu-support.patch
Patch3: detect-mate.patch
Patch4: mate-screensaver.patch
Patch5: xdg-open-generic-mimeapps.patch
Patch6: xdg-su-use-gnomesu-for-xfce-if-available.patch
Patch7: xdg-open-fix-ifs-use.patch

BuildArch: noarch

# Automatically added by buildreq on Wed Apr 25 2007
BuildRequires: xmlto w3m

AutoReq: no
Requires: coreutils, file, gawk, grep, procps, sed, sh, which, xprop, xset

%description
Xdg-utils is a set of command line tools that assist applications with
a variety of desktop integration tasks. About half of the tools focus on
tasks commonly required during the installation of a desktop application
and the other half focuses on integration with the desktop environment
while the application is running. Even if the desktop components of your
application are limited to an installer, configuration or management tool,
Xdg-utils provides you with an easy way to enhance the usage experience
of your customers by improving the integration of these components in
the user's environment.

The following scripts are provided at this time:
* xdg-desktop-menu      Install desktop menu items
* xdg-desktop-icon      Install icons to the desktop
* xdg-icon-resource     Install icon resources
* xdg-mime              Query information about file type handling and
                        install descriptions for new file types
* xdg-open              Open a file or URL in the user's preferred application
* xdg-email             Send mail using the user's preferred e-mail composer
* xdg-screensaver       Control the screensaver
* xdg-su                Run as root

Testsuite for xdg-utils is available from
http://portland.freedesktop.org/wiki/TestSuite

%prep
%setup
pushd scripts
# we should _never_ patch generated files
ls *.in | sed -e 's,\(.*\)\.in$,\1,' | xargs rm -f
popd
%patch0 -p2
%patch1 -p1
%patch2 -p2
%patch3 -p2
%patch4 -p2
%patch5 -p1
%patch6 -p2
%patch7 -p2

%build
%autoreconf
%configure
%make_build
%make_build -C scripts scripts

%install
%makeinstall_std

%files
%_bindir/xdg-desktop-icon
%_bindir/xdg-desktop-menu
%_bindir/xdg-email
%_bindir/xdg-icon-resource
%_bindir/xdg-mime
%_bindir/xdg-open
%_bindir/xdg-screensaver
%_bindir/xdg-settings
%_bindir/xdg-su
%_man1dir/*
%doc ChangeLog README LICENSE RELEASE_NOTES TODO

%changelog
