%define xorg xorg-x11
%define xf86 XFree86

Name: xdm
Version: 1.1.10
Release: alt1.1
Serial: 2
Summary: X Display Manager with support for XDMCP, host chooser
License: MIT/X11
Group: System/X11
Url: http://xorg.freedesktop.org

Source: %name-%version.tar
Patch: %name-%version-%release.patch

Requires: pam-ck-connector >= 0.3.0-alt5.M51.1
Obsoletes: %xf86-%name %xorg-%name < %serial:%version-%release
Provides: %xf86-%name = 4.4 %xorg-%name = %serial:%version-%release

# Automatically added by buildreq on Wed Jun 23 2010
BuildRequires: libXau-devel libXaw-devel libXdmcp-devel libXext-devel libXft-devel libXinerama-devel libXpm-devel libpam-devel xorg-util-macros xorg-xtrans-devel

%description
Xdm  manages a collection of X displays, which may be on the local host
or remote servers.  The design of xdm was guided by the needs of X ter-
minals  as well as The Open Group standard XDMCP, the X Display Manager
Control Protocol.  Xdm provides services similar to those  provided  by
init,  getty and login on character terminals: prompting for login name
and password, authenticating the user, and running a ``session.''

%prep
%setup
%patch -p1

%build
%autoreconf
%configure \
	--with-xdmlibdir=%_libdir/X11/xdm \
	--with-xdmconfigdir=%_sysconfdir/X11/xdm \
	--with-xdmscriptdir=%_sysconfdir/X11/xdm \
	--with-pixmapdir=%_datadir/X11/xdm/pixmaps \
	--with-xft \
	--enable-xdm-auth \
	--enable-xdmshell \
	--disable-static

%make_build

%install
%makeinstall_std
find %buildroot -type f -name 'lib*.la' -delete

install -pD -m644 xdm.pamd %buildroot%_sysconfdir/pam.d/xdm
install -pD -m640 xdm.logrotate %buildroot%_sysconfdir/logrotate.d/xdm

# explicitly create X authdir
mkdir -p %buildroot%_localstatedir/xdm
ln -snf ../../..%_localstatedir/xdm %buildroot%_sysconfdir/X11/xdm/authdir

%files
%config(noreplace) %_sysconfdir/X11/app-defaults/*
%dir %_sysconfdir/X11/xdm/
%_sysconfdir/X11/xdm/authdir
%config(noreplace) %_sysconfdir/logrotate.d/xdm
%config(noreplace) %_sysconfdir/pam.d/xdm
%_bindir/*
%_libdir/X11/xdm
%_datadir/X11/xdm
%dir %attr(700,root,root) %_localstatedir/xdm/
%_man1dir/*

%changelog
