##############################################################################
# $Id: xdtv.spec.in,v 1.26 2006/01/27 20:38:14 pingus77 Exp $
##############################################################################
# Minimum required is: X11 & XPM & Xaw from X.org + Xterm
#
# Optional:
# To have a better GUI:
# neXtaw (0.15.1) from http://siag.nu/neXtaw/
# or XawM from http://sourceforge.net/projects/xawm/
# or Xaw95 & Xaw3d (not advised)
#
# To Record with a lot of audio/video codecs:
# FFMpeg (50.0.0+) from http://ffmpeg.sourceforge.net/ read README.ffmpeg for more infos
# Lame (3.96+)from http://lame.sourceforge.net/
# XviD (1.x+) from http://www.xvid.org/
# DivX (5.0.1alpha only) from http://www.divx.com/divx/linux/
# Ogg (1.1.2+) & Theora (1.0alpha5) & Vorbis (1.1.0+) from http://www.xiph.org/
#
# Other options:
# Zvbi (0.2.15+) from http://zapping.sourceforge.net/ (Scanning channels and get their names
# Alsa (1.x) from http://www.alsa-project.org/ (Better sound architecture than OSS)
# Lirc (0.7.x+) from http://www.lirc.org/ (If you have a remote and want to use it)
# libpng & libjpeg (For capturing AleVT & XdTV snapshots)
##############################################################################

%define date 20080708
%define cvsversion cvs%date
%define new_name xawdecode

%define branch_point alt11.%cvsversion
%define revision 12.3

Name: xdtv
Summary: XdTV is a software to record & watch TV
Version: 2.4.1
Release: %branch_point.%revision

License: GPL
Url: http://xawdecode.sourceforge.net/
Packager: Hihin Ruslan <ruslandh@altlinux.ru>
Source: xawdecode-%date.tar.bz2

Source1: %name.desktop
Source2: xdtv_russian_addons.tar
Patch: xawdecode-cvs20080708-tvdebug.patch
Patch1: xawdecode-cvs20080708.4-long.patch
Patch2: xawdecode-20080708-xterm.patch
Patch3: xawdecode-20080708-divx-fix.patch
Patch4: xawdecode-20080708-rm_oss_fix.patch
Patch5: xawdecode-20080708-dvb1.patch
Patch6: xawdecode-20080708-autotools0.patch
Patch7: xawdecode-20080708-autotools1.patch
Patch8: xawdecode-20080708-device.1.patch
Patch9: xawdecode-20101011-video4linux2.patch
Patch10: xawdecode-20080708-ffmpeg.patch
Patch11: xdtv-2.4.1-alt-libpng15.patch

Group: Video

%def_enable optimization
%def_disable cpu-detection

%def_disable debug
%def_enable mmx

# Defaults :
%def_enable nls
%def_enable pixmaps
%def_enable xinerama

%def_enable nextaw
%def_enable xawm
%def_enable xaw95
%def_enable xaw3d
%def_enable ogg
%def_enable xvid
%def_enable ffmpeg
%def_enable ffmpeg_swscale
%def_enable dvb
%def_enable divx4linux
%def_enable lame
%def_enable dvb
%def_enable zvbi
%def_enable lirc
%def_enable alsa
%def_enable png
%def_enable jpeg
%def_disable faac
%def_enable mowitz
%def_enable xvtv
%def_enable x264
%def_enable xosd

%define Name			XdTV
%define summary1		%name is a software to record & watch TV.
%define tvtuner_launcher	%_desktopdir

BuildPreReq: rpm-build-fonts
BuildPreReq: linux-libc-headers
BuildPreReq: libavformat-devel liblirc-devel
BuildPreReq: xset libXext-devel

%if_enabled x264
BuildPreReq: libx264-devel
%endif

%if_enabled ogg
BuildPreReq: libogg-devel libtheora-devel libvorbis-devel
%endif

%if_enabled xvid
BuildPreReq: libxvid-devel
%endif

%if_enabled ffmpeg
BuildPreReq: libavformat-devel libpostproc-devel libswscale-devel
BuildPreReq: libavdevice-devel libavfilter-devel
%endif

%if_enabled divx
BuildPreReq: libavifile-devel
%endif

%if_enabled lame
BuildPreReq: liblame-devel
%endif

%if_enabled dvb
BuildPreReq: libdvbpsi-devel
%endif

%if_enabled zvbi
BuildPreReq: libzvbi-devel
%endif

%if_enabled lirc
BuildPreReq: liblirc-devel
%endif

%if_enabled alsa
BuildPreReq: libalsa-devel
%endif

%if_enabled png
BuildPreReq: libpng-devel
%endif

%if_enabled jpeg
BuildPreReq: libjpeg-devel
%endif

%if_enabled faac
BuildPreReq: libfaac-devel
%endif

%if_enabled xosd
BuildPreReq: libxosd-devel
%endif

# Automatically added by buildreq on Tue Mar 29 2011
BuildRequires: bdftopcf imake libSDL-devel libXaw-devel 
BuildRequires: libXaw3d-devel libXaw95-devel libXawM1-devel
BuildRequires: libXinerama-devel libXpm-devel libXv-devel 
BuildRequires: libXxf86dga-devel libXxf86vm-devel
BuildRequires: libavformat-devel libcurl-devel libdbus-glib-devel 
BuildRequires: liblame-devel liblirc-devel libneXtaw-devel 
BuildRequires: libswscale-devel
BuildRequires: libzvbi-devel mkfontdir xorg-cf-files xset



%description
XdTV is a software that allows you to to record & watch TV.
It interacts with Nxtvepg for NextView,
and uses the video4linux API. It can use some deinterlacing filters
and can record video files in various containers (AVI, MPEG, OGG, etc.)
with many codecs (FFMpeg(>=0.4.6), XviD(0.9 & 1.x),
Ogg Theora (>=1.0alpha5) & Vorbis and DivX4/5).
For AleVT for Teletext install libalevt
It has also some plugin capabilities.

%description -l ru_RU.CP1251
XdTV (  X11   xawtv)    
TV.     AleVT  Teletext   Nxtvepg  NextView,
 video4linux API.      
    : FFMpeg(>=0.4.6), XviD(0.9 & 1.x),
Ogg Theora (>=1.0alpha5) & Vorbis, DivX4/5.    
 .     
 libalevt

%description -l ru_RU.UTF8
XdTV (программа под X11 основанная на xawtv) это софт для просмотра
TV.  Она взаимодействует с AleVT для Teletext и с Nxtvepg для NextView,
использует video4linux API.  Может использовать деинтерлейс фильтры и
записывать видео с помощью кодеков: FFMpeg(>=0.4.6), XviD(0.9 & 1.x),
Ogg Theora (>=1.0alpha5) & Vorbis, DivX4/5.  Имеются возможности по
подключению плагинов. Для использования телетекста необходимо установить
пакет libalevt.

%package -n libalevt
Summary: Developpement files for XdTV
Group: Development/C

%if_enabled nextaw
BuildPreReq: libneXtaw-devel
%endif

%if_enabled xawm
BuildPreReq: libXawM1-devel
%endif

%if_enabled xaw95
BuildPreReq: libXaw95-devel
%endif

%if_enabled xaw3d
BuildPreReq: libXaw3d-devel
%endif

%if_enabled xinerama
BuildPreReq: libXinerama-devel
%endif

%package -n libalevt-devel
Summary: Developpement files for XdTV
Group: Development/C
Requires: libalevt = %version-%release

%description -n libalevt
Teletext decoder and browser for the bttv driver.

%description -n libalevt-devel
Headers and tool for development with libalevt.

%description -n libalevt -l ru_RU.UTF8
X11 библиотка для декодирования телетекста.

%description -n libalevt -l ru_RU.CP1251
X11    .

%package -n fonts-bitmap-xdtv-OSD
Summary: Font used by XdTV OSD function
Group: Video
Conflicts: xdtv-OSD-font
Obsoletes: xdtv-OSD-font

%description -n fonts-bitmap-xdtv-OSD
Font used by XdTV OSD function.

%prep
%setup -n %new_name-%date -q -a2
mkdir m4
%patch -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch8 -p1

%patch6 -p1
%patch7 -p1

%patch9 -p1
%patch10 -p1
%patch11 -p2

%build
%autoreconf

export FLAGS="%optflags -DNDEBUG -DNO_DEBUG -D_GNU_SOURCE "
%configure \
%if_enabled optimization
	--enable-cpu-detection \
%else
	--disable-cpu-detection \
%endif
	--with-gnu-ld  \
	--with-pic   \
	--with-x   \
        --enable-smallfont \
	--with-external-ffmpeg \
	--enable-x11-ext-checking \
        --with-fontdir=%buildroot%_bitmapfontsdir/%name \
	--with-appdefaultsdir=%_x11appconfdir \
	%{subst_enable mmx}  \
	%{subst_enable nls} \
	%{subst_enable pixmaps} \
	%{subst_enable debug} \
	%{subst_enable xinerama} \
	%{subst_enable ogg} \
	%{subst_enable x264} \
	%{subst_enable xvtv} \
	%{subst_enable divx} \
	%{subst_enable xvid} \
	%{subst_enable ffmpeg} \
	%{subst_enable ffmpeg_swscale} \
	%{subst_enable lame} \
	%{subst_enable zvbi} \
	%{subst_enable lirc} \
	%{subst_enable dvb} \
	%{subst_enable alsa} \
	%{subst_enable jpeg} \
	%{subst_enable png} \
	%{subst_enable nextaw} \
	%{subst_enable xawm} \
	%{subst_enable faac} \
	%{subst_enable xaw95} \
	%{subst_enable xaw3d} \
	%{subst_enable mowitz} \
export ROOT=%buildroot/usr
%make_build

%install
%makeinstall ROOT=%buildroot \
	     SUID_ROOT="" \
	     libdir=%buildroot/%_libdir

install -d -m755 %buildroot%_fontpathdir/

pushd %buildroot%_fontpathdir
ln -s ../../..%_bitmapfontsdir/%name bitmap-xdtv:unscaled:pri=20
popd

# Cure man path if needed
install -d -m 755 %buildroot%_includedir/libalevt
install -m 644 alevt/*.h %buildroot%_includedir/libalevt
install -d -m 755 %buildroot%_man1dir
install -m 644 man/%name.1 %buildroot%_man1dir
install -m 644 man/%{name}_cmd.1 %buildroot%_man1dir
install -m 644 man/%{name}_alevt-cap.1 %buildroot%_man1dir
install -m 644 man/%{name}_alevt-date.1 %buildroot%_man1dir
install -m 644 man/%{name}_alevt.1 %buildroot%_man1dir

# Dynamic desktop support
mkdir -p %buildroot/%tvtuner_launcher
cp %SOURCE1 %buildroot/%tvtuner_launcher/

cat > %buildroot%_desktopdir/xdtv_wizard.desktop << EOF
[Desktop Entry]
Name=xdtv_wizard
GenericName[ru]=Наладка параметров xdtv
Comment=xdtv is a software to record & watch TV.
Categories=AudioVideo;Video;TV;
TryExec=%_bindir/xdtv_wizard
Exec=%_bindir/xdtv_wizard
Terminal=true
Icon=xdtv.png
Type=Application
EOF

cat > %buildroot%_desktopdir/scan_xdtv.desktop << EOF
[Desktop Entry]
Name=xdtv_scantv.sh
GenericName[ru]=Настройка каналов xdtv
Comment=xdtv is a software to record & watch TV.
Categories=AudioVideo;Video;TV;
TryExec=%_bindir/xdtv_scan.sh
Exec=%_bindir/xdtv_scan.sh
Terminal=true
Icon=xdtv.png
Type=Application
EOF

cat > %buildroot%_desktopdir/xdtv_make_dvb.desktop << EOF
[Desktop Entry]
Name=xdtv_scantv.sh
GenericName[ru]=xdtv Скрипт работы с DVB
Comment=xdtv is a software to record & watch TV.
Categories=AudioVideo;Video;TV;
TryExec=%_bindir/xdtv_makedvb.sh
Exec=%_bindir/xdtv_makedvb.sh
Terminal=true
Icon=xdtv.png
Type=Application
EOF

# menu
install -pD -m 644 %name-16.png %buildroot/%_miconsdir/%name.png
install -pD -m 644 %name-32.png %buildroot/%_niconsdir/%name.png
install -pD -m 644 %name-48.png %buildroot/%_liconsdir/%name.png

%files
%docdir %_docdir/xdtv-%version
%doc AUTHORS COPYING INSTALL FAQfr-xdtv TODO ChangeLog
%doc lisez-moi
%doc README README.*
%doc *.sample

%dir %_sysconfdir/%name
%_sysconfdir/%name/%{name}_wizard-en.conf
%_sysconfdir/%name/%{name}_wizard-en-UTF8.conf
%_bindir/%name
%_bindir/%{name}_cmd
%_bindir/%{name}_wizard
%_bindir/%{name}_scantv
%_bindir/%{name}_alevt-cap
%_bindir/%{name}_alevt-capall
%_bindir/%{name}_alevt-date
%attr(4711,root,root) %_bindir/%{name}_v4l-conf
%_bindir/%{name}_scan.sh
%_bindir/%{name}_record.sh
%_bindir/%{name}_makedvd.sh
%_man1dir/*
%_datadir/%name/icons/*
%_x11appconfdir/*

#_menudir/%name
#_menudir/%{name}_wizard
%_niconsdir/%name.png
%_miconsdir/%name.png
%_liconsdir/%name.png
%_desktopdir/*.desktop

%files -n libalevt
%_libdir/*.so.*
#exclude  %_libdir/libalevt.la
#exclude  %_libdir/libalevt.a

%files -n libalevt-devel
%_includedir/*
%_libdir/*.so

%files -n fonts-bitmap-xdtv-OSD
%dir %_bitmapfontsdir/xdtv
%exclude %_bitmapfontsdir/xdtv/fonts.scale
%_bitmapfontsdir/xdtv/*
%_fontpathdir/*

%changelog
