%define oldname xerces-j2
Packager: Igor Vlasenko <viy@altlinux.ru>
BuildRequires: xml-commons-resolver
AutoReq: yes,noosgi
BuildRequires: rpm-build-java-osgi
BuildRequires: /proc
BuildRequires: jpackage-1.6.0-compat
# Copyright (c) 2000-2009, JPackage Project
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the
#    distribution.
# 3. Neither the name of the JPackage Project nor the names of its
#    contributors may be used to endorse or promote products derived
#    from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

%define with()          %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()       %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
%define bcond_with()    %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}

#def_with manual
%bcond_with             manual

%define cvs_version        2_9_1
%define gcj_support        %{?_with_gcj_support:1}%{!?_with_gcj_support:%{?_without_gcj_support:0}%{!?_without_gcj_support:%{?_gcj_support:%{_gcj_support}}%{!?_gcj_support:0}}}

Name:           xerces-j29
Version:        2.9.1
Release:        alt5_2jpp6
Epoch:          0
Summary:        Java XML parser
License:        ASL 2.0
URL:            http://xerces.apache.org/xerces2-j/
Group:          Development/Java
# svn export https://svn.apache.org/repos/asf/xerces/java/tags/Xerces-J_2_9_1/
Source0:        http://www.apache.org/dist/xml/xerces-j/Xerces-J-src.%{version}.tar.bz2
Source3:        %{oldname}-version.sh
Source4:        %{oldname}-constants.sh
Source5:        %{oldname}-component-info.xml
Patch0:         %{oldname}-build.patch
Patch1:         %{oldname}-libgcj.patch
Requires: xalan-j2
Requires: xml-commons-jaxp-1.3-apis
Requires: xml-commons-resolver12 >= 0:1.1
Requires(post): alternatives >= 0:0.4
Requires(preun): alternatives >= 0:0.4
BuildRequires: ant >= 0:1.5
#BuildRequires: jaxp_parser_impl
BuildRequires: xalan-j2
BuildRequires: xml-commons-jaxp-1.3-apis
BuildRequires: xml-commons-resolver12 >= 0:1.3
BuildRequires: xml-stylebook
%if %{gcj_support}
BuildRequires: java-gcj-compat-devel
%else
BuildArch:      noarch
%endif
Source44: import.info
Source45: xerces-j2-2.9.0.jar-OSGi-MANIFEST.MF
Source9: JPP-xerces-j2.pom

%description
Welcome to the future! Xerces2 is the next generation of high
performance, fully compliant XML parsers in the Apache Xerces family.
This new version of Xerces introduces the Xerces Native Interface (XNI),
a complete framework for building parser components and configurations
that is extremely modular and easy to program.

The Apache Xerces2 parser is the reference implementation of XNI but
other parser components, configurations, and parsers can be written
using the Xerces Native Interface. For complete design and
implementation documents, refer to the XNI Manual.

Xerces 2 is a fully conforming XML Schema processor. For more
information, refer to the XML Schema page.

Xerces 2 also provides a partial implementation of Document Object Model
Level 3 Core, Load and Save and Abstract Schemas [deprecated] Working
Drafts. For more information, refer to the DOM Level 3 Implementation
page.

%package javadoc-impl
Summary:        Javadoc for %{name} implementation
Group:          Development/Documentation

%description javadoc-impl
Javadoc for %{name} implementation.

%package javadoc-apis
Summary:        Javadoc for %{name} apis
Group:          Development/Documentation

%description javadoc-apis
Javadoc for %{name} apis.

%package javadoc-xni
Summary:        Javadoc for %{name} xni
Group:          Development/Documentation

%description javadoc-xni
Javadoc for %{name} xni.

%package javadoc-other
Summary:        Javadoc for other %{name} components
Group:          Development/Documentation

%description javadoc-other
Javadoc for other %{name} components.

%if %with manual
%package manual
Summary:        Documents for %{name}
Group:          Development/Documentation
BuildArch: noarch

%description manual
%{summary}.
%endif

%package demo
Summary:        Demo for %{name}
Group:          Development/Java
Requires: %{name} = %{epoch}:%{version}-%{release}

%description demo
Demonstrations and samples for %{name}.

%package scripts
Summary:        Additional utility scripts for %{name}
Group:          Development/Java
Requires: %{name} = %{epoch}:%{version}-%{release}
Requires: jpackage-utils >= 0:1.6

%description scripts
Additional utility scripts for %{name}.

%prep
%setup -q -n Xerces-J_%{cvs_version}

%{_bindir}/find -name '*.jar' -o -name '*.class' | %{_bindir}/xargs -t rm

mkdir -p tools/org/apache/xerces/util
cp -p tools/src/XJavac.java tools/org/apache/xerces/util/XJavac.java
cp -p tools/src/ExperimentalTaglet.java tools/org/apache/xerces/util/ExperimentalTaglet.java
cp -p tools/src/InternalTaglet.java tools/org/apache/xerces/util/InternalTaglet.java

mkdir -p tools/bin

%patch0 -p1 -b .build
%patch1 -p0 -b .libgcj

%build
pushd tools
%{javac} -classpath $(build-classpath ant) org/apache/xerces/util/XJavac.java
%{jar} cf bin/xjavac.jar org/apache/xerces/util/XJavac.class
%{javac} -classpath %{java_home}/lib/tools.jar org/apache/xerces/util/ExperimentalTaglet.java org/apache/xerces/util/InternalTaglet.java
%{jar} cf bin/xerces2taglets.jar org/apache/xerces/util/ExperimentalTaglet.class org/apache/xerces/util/InternalTaglet.class
popd

export ANT_OPTS="-Djava.awt.headless=true"
export CLASSPATH=$(build-classpath xalan-j2-serializer):%{java_home}/jre/lib/rt.jar
export OPT_JAR_LIST=:
ant -Dant.build.javac.source=1.5 -Dant.build.javac.target=1.5 \
        -Dbuild.compiler=modern \
        -Dtools.dir=%{_javadir} \
        -Djar.apis=xml-commons-jaxp-1.3-apis.jar \
        -Djar.resolver=xml-commons-resolver12.jar \
        -Djar.serializer=xalan-j2-serializer.jar \
        clean jars javadocs \
%if %with manual
docs
%else

%endif

%install

# jars
mkdir -p $RPM_BUILD_ROOT%{_javadir}
cp -p build/xercesImpl.jar $RPM_BUILD_ROOT%{_javadir}/%{name}.jar
ln -s %{name}.jar $RPM_BUILD_ROOT%{_javadir}/dom3-%{name}.jar

# javadoc
mkdir -p $RPM_BUILD_ROOT%{_javadocdir}/%{name}-impl
cp -pr build/docs/javadocs/xerces2/* \
  $RPM_BUILD_ROOT%{_javadocdir}/%{name}-impl

mkdir -p $RPM_BUILD_ROOT%{_javadocdir}/%{name}-apis
cp -pr build/docs/javadocs/api/* \
  $RPM_BUILD_ROOT%{_javadocdir}/%{name}-apis

mkdir -p $RPM_BUILD_ROOT%{_javadocdir}/%{name}-xni
cp -pr build/docs/javadocs/xni/* \
  $RPM_BUILD_ROOT%{_javadocdir}/%{name}-xni

mkdir -p $RPM_BUILD_ROOT%{_javadocdir}/%{name}-other
cp -pr build/docs/javadocs/other/* \
  $RPM_BUILD_ROOT%{_javadocdir}/%{name}-other

# FIXME: (dwalluck): breaks -bi --short-circuit
rm -rf build/docs/javadocs

%if %with manual
# manual
mkdir -p $RPM_BUILD_ROOT%{_docdir}/%{name}
%if !%{gcj_support}
cp -pr build/docs/* $RPM_BUILD_ROOT%{_docdir}/%{name}
%endif
%endif

# scripts
mkdir -p $RPM_BUILD_ROOT%{_bindir}
cp -p %{SOURCE3} $RPM_BUILD_ROOT%{_bindir}/%{name}-version
cp -p %{SOURCE4} $RPM_BUILD_ROOT%{_bindir}/%{name}-constants

# demo
mkdir -p $RPM_BUILD_ROOT%{_datadir}/%{name}
cp -p build/xercesSamples.jar \
  $RPM_BUILD_ROOT%{_datadir}/%{name}/%{name}-samples.jar
cp -pr data $RPM_BUILD_ROOT%{_datadir}/%{name}

%if %{gcj_support}
%{_bindir}/aot-compile-rpm
%endif
chmod 755 $RPM_BUILD_ROOT%{_bindir}/*

# inject OSGi manifest xerces-j2-2.9.0.jar-OSGi-MANIFEST.MF
rm -rf META-INF
mkdir -p META-INF
cp %{SOURCE45} META-INF/MANIFEST.MF
zip -u %buildroot/usr/share/java/xerces-j29.jar META-INF/MANIFEST.MF

mkdir -p %buildroot/%_mavenpomdir
install -m644 %{SOURCE9} %buildroot/%_mavenpomdir/JPP-%{name}.pom
%add_to_maven_depmap xerces xmlParserAPIs %{version} JPP %{name}
%add_to_maven_depmap xerces xercesImpl %{version} JPP %{name}

%files
%doc LICENSE LICENSE-SAX.html LICENSE.DOM-documentation.html
%doc LICENSE.DOM-software.html LICENSE.resolver.txt
%doc LICENSE.serializer.txt NOTICE NOTICE.resolver.txt
%doc NOTICE.serializer.txt README Readme.html
%{_javadir}/%{name}.jar
%{_javadir}/dom3-%{name}.jar
%if %{gcj_support}
%dir %{_libdir}/gcj/%{name}
%{_libdir}/gcj/%{name}/xercesImpl.jar.db
%{_libdir}/gcj/%{name}/xercesImpl.jar.so
%endif
%_mavenpomdir/JPP-%{name}.pom
%_mavendepmapfragdir/*

%files javadoc-impl
%{_javadocdir}/%{name}-impl

%files javadoc-apis
%{_javadocdir}/%{name}-apis

%files javadoc-other
%{_javadocdir}/%{name}-other

%files javadoc-xni
%{_javadocdir}/%{name}-xni

%if %with manual
%files manual
%doc %{_docdir}/%{name}/
%endif

%files demo
%{_datadir}/%{name}
%if %{gcj_support}
%{_libdir}/gcj/%{name}/%{name}-samples.jar.db
%{_libdir}/gcj/%{name}/%{name}-samples.jar.so
%endif

%files scripts
#%defattr(0755,root,root,0755)
%{_bindir}/xerces-j29-constants
%{_bindir}//xerces-j29-version

%changelog
