%define xfce_ver 4.10

Name: xfce4-panel
Version: 4.10.1
Release: alt0.M70P.1

Summary: Panel for XFce
Summary(ru_RU.UTF-8): Панель для окружения рабочего стола Xfce
License: %gpl2plus
Group: Graphical desktop/XFce
Url: http://www.xfce.org/

# Upstream: git://git.xfce.org/xfce/xfce4-panel
Source: %name-%version.tar
Patch: %name-%version-%release.patch
Packager: XFCE Team <xfce@packages.altlinux.org>

BuildRequires(pre): rpm-build-licenses

BuildPreReq: rpm-build-xfce4 >= 0.1.0 xfce4-dev-tools
BuildPreReq: libxfce4ui-devel >= %xfce_ver libexo-devel >= 0.6.0 libgarcon-devel
BuildRequires: gtk-doc libwnck-devel libICE-devel libXext-devel libSM-devel

Requires: libxfce4panel = %version-%release
Requires: xfce4-common

Obsoletes: xfce4-showdesktop-plugin, xfce4-windowlist-plugin

%description
%name is the panel for the XFce desktop environment.

%description -l ru_RU.UTF-8
Данный пакет содержит в себе панель для окружения рабочего стола Xfce.

%package -n libxfce4panel
Summary: Library for XFce panel
License: %lgpl2plus
Group: Development/C

%description -n libxfce4panel
This package contains library for XFce panel plugins.

%package -n libxfce4panel-devel
Summary: Development files to build XFce panel plugins
License: %lgpl2plus
Group: Development/C
PreReq: libxfce4panel = %version-%release
Provides: %name-devel = %version-%release
Obsoletes: %name-devel < 4.8.0

%description -n libxfce4panel-devel
This package contains files to develop plugins for XFce panel.

%package -n libxfce4panel-devel-doc
Summary: Documentation files to build XFce panel plugins
Group: Development/Documentation
PreReq: libxfce4panel-devel = %version-%release
Provides: %name-devel-doc = %version-%release
Obsoletes: %name-devel-doc < 4.8.0
BuildArch: noarch

%description -n libxfce4panel-devel-doc
This package contains files to develop plugins for XFce panel.

%prep
%setup
%patch -p1

%build
%xfce4reconf
%configure \
	--disable-static \
	--enable-maintainer-mode \
	--enable-gtk-doc \
	--enable-gen-doc \
	--enable-debug=no
%make_build

%install
%makeinstall_std
%find_lang %name

# FIXME: We need to own these dirs until all plugins are ported to Xfce 4.8
mkdir -p %buildroot/%_libexecdir/xfce4/panel-plugins
mkdir -p %buildroot/%_libdir/xfce4/panel-plugins
mkdir -p %buildroot/%_datadir/xfce4/panel-plugins

%files -f %name.lang
%doc AUTHORS NEWS README
%config(noreplace) %_sysconfdir/xdg/xfce4/*
%_bindir/*
%_libdir/xfce4/panel/
%_iconsdir/hicolor/*/*/*
%_datadir/xfce4/panel/
%_desktopdir/*.desktop
%exclude %_libdir/xfce4/panel/plugins/*.la
# FIXME: Remove these when no longer needed
%dir %_libexecdir/xfce4/
%dir %_libexecdir/xfce4/panel-plugins/
%dir %_libdir/xfce4/panel-plugins

%files -n libxfce4panel
%_libdir/libxfce4panel-*.so.*

%files -n libxfce4panel-devel
%_libdir/pkgconfig/*
%_libdir/libxfce4panel-*.so
%_includedir/xfce4/libxfce4panel-*/

%files -n libxfce4panel-devel-doc
%doc %_datadir/gtk-doc/html/libxfce4panel-*/

%changelog
