Name: xfce4-power-manager
Version: 1.2.0
Release: alt6
Summary: Power management for the Xfce desktop environment
Summary (ru_RU.UTF8): Утилита расширенного управления питанием для Xfce

Group: Graphical desktop/XFce
License: %gpl2plus
Url: http://goodies.xfce.org/projects/applications/%name
Packager: XFCE Team <xfce@packages.altlinux.org>

# Upstream: git://git.xfce.org/xfce/xfce4-power-manager
Source0: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires(pre): rpm-build-licenses

BuildPreReq: rpm-build-xfce4 xfce4-dev-tools
BuildPreReq: libxfconf-devel libxfce4panel-devel libxfce4ui-devel
BuildRequires: libXext-devel
BuildRequires: libXrandr-devel
BuildRequires: libnotify-devel >= 0.4.1
BuildRequires: libglade-devel > 2.0.0
BuildRequires: gettext intltool desktop-file-utils
# For exo-csource (needed in maintainer mode)
BuildPreReq: libexo-devel

Requires: xfce4-panel
Requires: polkit
Requires: upower

%description
xfce4-power-manager is a tool for the Xfce desktop environment for
managing profiles of policies which affect power consumption, such as
the display brightness level, display sleep times, or CPU frequency
scaling.

%prep
%setup
%patch -p1

%build
%xfce4reconf
%configure \
	--enable-maintainer-mode \
	--enable-polkit \
	--enable-dpms \
	--enable-network-manager \
	--with-sleep-manager=systemd \
	--enable-debug=no
%make_build

%install
%makeinstall_std
%find_lang %name

%files -f %name.lang
%doc AUTHORS NEWS README
%config %_sysconfdir/xdg/autostart/%name.desktop
%_bindir/*
%_sbindir/xfpm-power-backlight-helper
%_libdir/xfce4/panel-plugins/xfce4-*
%_desktopdir/*.desktop
%_iconsdir/hicolor/*/*/*.*
%_datadir/xfce4/panel/plugins/*.desktop
%_datadir/polkit-1/actions/*.policy
%_mandir/man?/*

%changelog
