%def_disable static

Name: xfsprogs
Version: 3.1.11
Release: alt0.M70P.1

Summary: Utilities for managing the XFS filesystem
License: LGPL v2.1 (libhandle), GPL v2 (the rest)
Group: System/Kernel and hardware

Url: http://xfs.org
Source: %name-%version-%release.tar

Requires: libxfs = %version-%release
Conflicts: xfsdump < 3.0.0-alt1

%set_libtool_version 1.5

BuildPreReq: rpm-build >= 4.0.4-alt96.11

# makefiles are buggy
BuildConflicts: libxfs-devel

# Automatically added by buildreq on Wed May 27 2009 (-bi)
BuildRequires: libuuid-devel

%description
XFS is a high performance journaling filesystem which originated
on the SGI IRIX platform.  It is completely multi-threaded, can
support large files and large filesystems, extended attributes,
variable block sizes, is extent based, and makes extensive use of
Btrees (directories, extents, free space) to aid both performance
and scalability.

Refer to the documentation at http://oss.sgi.com/projects/xfs/
for complete details.  This implementation is on-disk compatible
with the IRIX version of XFS.

This package contains a set of commands to use the XFS filesystem,
including mkfs.xfs.

%package -n libxfs
Summary: XFS filesystem-specific libraries
Group: System/Libraries

%description -n libxfs
This package contains the library needed to run programs dynamically
linked with libxfs.

%package -n libxfs-devel
Summary: XFS filesystem-specific devel libraries and headers
Group: Development/C
Requires: libxfs = %version-%release

%description -n libxfs-devel
libxfs-devel contains the libraries and header files needed to
develop XFS filesystem-specific programs.

You should install libxfs-devel if you want to develop XFS
filesystem-specific programs, If you install libxfs-devel, you'll
also want to install xfsprogs.

%package -n libxfs-qa-devel
Summary: XFS QA filesystem-specific headers
Group: Development/C
Requires: libxfs-devel = %version-%release

%description -n libxfs-qa-devel
libxfs-qa-devel contains headers needed to build the xfstests
QA suite.

You should install xfsprogs-qa-devel only if you are interested
in building or running the xfstests QA suite.

%if_enabled static
%package -n libxfs-devel-static
Summary: XFS filesystem-specific static libraries
Group: Development/C
Requires: libxfs-devel = %version-%release

%description -n libxfs-devel-static
libxfs-devel-static contains the static libraries needed to
develop XFS filesystem-specific programs.

You should install libxfs-devel-static if you want to develop XFS
filesystem-specific programs.

If you install libxfs-devel-static, you'll also want to install xfsprogs.
%endif

%prep
%setup
sed 's|^\(hardcode_into_libs\)=.*$|\1=no|' < %_bindir/libtool-default > libtool
install -pm755 include/install-sh install-sh

%build
libtoolize --copy --force
aclocal -I m4
autoconf
%configure \
	--libdir=/%_lib \
	--libexecdir=%_libdir
make DEBUG=-DNDEBUG LIBTOOL="`pwd`/libtool"

%install
make DIST_ROOT=%buildroot install install-dev install-qa
mkdir -p %buildroot%_libdir

for f in %buildroot/%_lib/*.so; do
	t=`objdump -p "$f" |awk '/SONAME/ {print $2}'`
	[ -n "$t" ]
	ln -nsf ../../%_lib/"$t" "%buildroot%_libdir/${f##*/}"
done

# Workaround bug in makefiles
rm -f %buildroot/%_lib/*.{so,*a}
rm -rf %buildroot%_datadir/doc/%name

%find_lang %name

%files -f %name.lang
/sbin/*
%_sbindir/*
%_mandir/man[85]/*
%doc doc/CHANGES.gz doc/CREDITS README

%files -n libxfs
/%_lib/*.so.*

%files -n libxfs-devel
%_libdir/*.so
%dir %_includedir/xfs
%_includedir/xfs/handle.h
%_includedir/xfs/jdm.h
%_includedir/xfs/linux.h
%_includedir/xfs/platform_defs.h
%_includedir/xfs/xfs.h
%_includedir/xfs/xfs_fs.h
%_includedir/xfs/xqm.h
%_man3dir/*

%files -n libxfs-qa-devel
%_includedir/xfs/atomic.h
%_includedir/xfs/bitops.h
%_includedir/xfs/cache.h
%_includedir/xfs/hlist.h
%_includedir/xfs/kmem.h
%_includedir/xfs/libxfs.h
%_includedir/xfs/libxlog.h
%_includedir/xfs/list.h
%_includedir/xfs/parent.h
%_includedir/xfs/radix-tree.h
%_includedir/xfs/swab.h
%_includedir/xfs/xfs_ag.h
%_includedir/xfs/xfs_alloc.h
%_includedir/xfs/xfs_alloc_btree.h
%_includedir/xfs/xfs_arch.h
%_includedir/xfs/xfs_attr_leaf.h
%_includedir/xfs/xfs_attr_sf.h
%_includedir/xfs/xfs_bit.h
%_includedir/xfs/xfs_bmap.h
%_includedir/xfs/xfs_bmap_btree.h
%_includedir/xfs/xfs_btree.h
%_includedir/xfs/xfs_btree_trace.h
%_includedir/xfs/xfs_buf_item.h
%_includedir/xfs/xfs_da_btree.h
%_includedir/xfs/xfs_dfrag.h
%_includedir/xfs/xfs_dinode.h
%_includedir/xfs/xfs_dir2.h
%_includedir/xfs/xfs_dir2_block.h
%_includedir/xfs/xfs_dir2_data.h
%_includedir/xfs/xfs_dir2_leaf.h
%_includedir/xfs/xfs_dir2_node.h
%_includedir/xfs/xfs_dir2_sf.h
%_includedir/xfs/xfs_dir_leaf.h
%_includedir/xfs/xfs_dir_sf.h
%_includedir/xfs/xfs_extfree_item.h
%_includedir/xfs/xfs_ialloc.h
%_includedir/xfs/xfs_ialloc_btree.h
%_includedir/xfs/xfs_inode.h
%_includedir/xfs/xfs_inode_item.h
%_includedir/xfs/xfs_inum.h
%_includedir/xfs/xfs_log.h
%_includedir/xfs/xfs_log_priv.h
%_includedir/xfs/xfs_log_recover.h
%_includedir/xfs/xfs_metadump.h
%_includedir/xfs/xfs_mount.h
%_includedir/xfs/xfs_quota.h
%_includedir/xfs/xfs_rtalloc.h
%_includedir/xfs/xfs_sb.h
%_includedir/xfs/xfs_trace.h
%_includedir/xfs/xfs_trans.h
%_includedir/xfs/xfs_trans_space.h
%_includedir/xfs/xfs_types.h

%if_enabled static
%files -n libxfs-devel-static
%_libdir/*.a
%endif

%changelog
