%def_disable static
%def_enable shared

%def_enable shm
%def_enable shm_default
%def_enable mbs
%def_enable xft
%def_enable lirc
%def_enable vdr_keys

%def_with readline
%def_with ncurses
%def_with curl
%def_with aa
%def_with caca
%def_with fb
%def_with X11

%define lirclib shared
#----------------------------------------------------------------------
%define subst_enable_to() %{expand:%%{?_enable_%{1}:--enable-%{2}}} %{expand:%%{?_disable_%{1}:--disable-%{2}}}
%define subst_with_to() %{expand:%%{?_with_%{1}:--with-%{2}}} %{expand:%%{?_without_%{1}:--without-%{2}}}
%define set_disable() %{expand:%%force_disable %{1}} %{expand:%%undefine _enable_%{1}}
%define set_enable() %{expand:%%force_enable %{1}} %{expand:%%undefine _disable_%{1}}
%define subst_test_to() %{expand:%%{?_with_%{1}:--enable-%{2}test}} %{expand:%%{?_without_%{1}:--disable-%{2}test}}
%define subst_test() %{expand:%%{?_with_%{1}:--enable-%{1}test}} %{expand:%%{?_without_%{1}:--disable-%{1}test}}

%{?_disable_shm:%set_disable shm}
%{?_disable_X11:%set_disable xft}
%{?_disable_mbs:%set_disable xft}
%{?_enable_aa:%set_enable ncurses}
%{?_enable_caca:%set_enable ncurses}
%{?_enable_fb:%set_enable ncurses}
%if_without X11
%if_with caca
%define xinebin caca
%else
%if_with aa
%define xinebin aa
%else
%if_with fb
%define xinebin fb
%else
%set_with aa
%define xinebin aa
%endif
%endif
%endif
%endif

%define Name Xine
Name: xine-ui
Version: 0.99.6
Release: alt1.1
Summary: Video Player
License: %gpl2plus
Group: Video
URL: http://xine.sourceforge.net
Source0: http://xine.sourceforge.net/files/%name-%version.tar
Source1: %name.desktop
Patch: xine-ui-0.99.6-alt-libpng15.patch
%{?_without_X11:Requires: xine-%xinebin = %version-%release}
Packager: Led <led@altlinux.ru>

BuildRequires(pre): rpm-build-licenses
BuildRequires: gcc-c++ pkg-config
BuildRequires: libxine-devel >= 1.1.7-alt3
BuildRequires: libpng-devel >= 1.2.8
BuildRequires: libXinerama-devel libXtst-devel libXv-devel
BuildRequires: libXxf86vm-devel xorg-sdk imake

%{?_with_aa:BuildRequires: aalib-devel >= 1.2.0}
%{?_with_caca:BuildRequires: libcaca-devel >= 0.99}
%{?_with_curl:BuildRequires: libcurl-devel >= 7.10.2}
%{?_with_ncurses:BuildRequires: libncurses-devel libgpm-devel libslang-devel}
%{?_with_readline:BuildRequires: libreadline-devel}
%{?_enable_xft:BuildRequires: libXft-devel}
%{?_with_X11:BuildRequires: libXext-devel libXt-devel xorg-cf-files xorg-inputproto-devel desktop-file-utils}
%if_enabled lirc
%if %lirclib == shared
BuildRequires: liblirc-devel
%else
BuildRequires: liblirc-devel-static
%endif
%endif

%description
%Name is a free gpl-licensed video player for unix-like systems. It
support mpeg-2 and mpeg-1 system (audio + video multiplexed + DVD)
streams, eventually mpeg-4 and other formats might be added.


%package -n xine-utils
Summary: Utils for xine Video Player
Group: Video

%description -n xine-utils
%Name is a free gpl-licensed video player for unix-like systems. It
support mpeg-2 and mpeg-1 system (audio + video multiplexed + DVD)
streams, eventually mpeg-4 and other formats might be added.
This package provide utils for xine video player.


%if_with aa
%package -n xine-ui-aa
Summary: Console version of a Video Player
Group: Video
Provides: aaxine = %version-%release
Provides: xine-aa = %version-%release
Requires: aalib >= 1.2.0

%description -n xine-ui-aa
%Name is a free gpl-licensed video player for unix-like systems. It
support mpeg-2 and mpeg-1 system (audio + video multiplexed + DVD)
streams, eventually mpeg-4 and other formats might be added.
This package provide text version of the video player.
%endif

%if_with caca
%package -n xine-ui-caca
Summary: Color console version of a Video Player
Group: Video
Provides: cacaxine = %version-%release
Provides: xine-caca = %version-%release

%description -n xine-ui-caca
%Name is a free gpl-licensed video player for unix-like systems. It
support mpeg-2 and mpeg-1 system (audio + video multiplexed + DVD)
streams, eventually mpeg-4 and other formats might be added.
This package provide color text version of the video player.
%endif

%if_with fb
%package -n xine-ui-fb
Summary: Framebuffer version of a Video Player
Group: Video
Provides: fbxine = %version-%release
Provides: xine-fb = %version-%release

%description -n xine-ui-fb
%Name is a free gpl-licensed video player for unix-like systems. It
support mpeg-2 and mpeg-1 system (audio + video multiplexed + DVD)
streams, eventually mpeg-4 and other formats might be added.
This package provide framebuffer version of the video player.
%endif

%prep
%setup
%patch -p1
subst 's/cbreak/delch/g' configure.ac
subst 's|/usr/lib|%_libdir|' m4/_xine.m4
%if %lirclib == shared
subst 's/\(liblirc_client\.\)a/\1so/g' m4/_xine.m4
%endif


%build
%add_optflags "-DHAVE_ICONV"
./autogen.sh noconfig
%configure --with-pic \
    %{subst_enable static} \
    %{subst_enable shared} \
    %{subst_enable shm} \
    %{subst_enable_to shm_default shm-default} \
    %{subst_enable mbs} \
    %{subst_enable xft} \
    %{subst_enable lirc} \
    %{subst_enable_to vdr_keys vdr-keys} \
    %{subst_with readline} \
    %{subst_with ncurses} \
    %{subst_with curl} %{subst_test curl} \
    %{subst_with_to aa aalib} %{subst_test_to aa aalib} \
    %{subst_with_to caca libcaca} %{subst_test caca} \
    %{subst_with_to X11 x} \
    --enable-xinetest

%make_build


%install
make DESTDIR=%buildroot docsdir=%_docdir/%name-%version desktopdir=%_desktopdir install
install -m 0644 %SOURCE1 %buildroot%_desktopdir/xine.desktop
echo -n "MimeType=" >> %buildroot%_desktopdir/xine.desktop
cat %_libdir/xine/plugins/*/mime.types | sed 's/;.*//'|tr '\n' ';' >> %buildroot%_desktopdir/xine.desktop
echo >> %buildroot%_desktopdir/xine.desktop
mv %buildroot%_docdir/%name-%version/README %buildroot%_docdir/%name-%version/README.xitk
bzip2 --best --force --stdout ChangeLog > %buildroot%_docdir/%name-%version/ChangeLog.bz2
ln -sf xine-check %buildroot%_bindir/xine-bugreport
%{?_without_X11:ln -s %{xinebin}xine %buildroot%_bindir/xine}
%{?_without_X11:find %buildroot%_mandir -type f -name 'xine.1' -delete}
%{?_without_aa:find %buildroot%_mandir -type f -name 'aaxine.1' -delete}
%{?_without_caca:find %buildroot%_mandir -type f -name 'cacaxine.1' -delete}
%{?_without_aa:find %buildroot%_mandir -type f -name 'fbxine.1' -delete}
find %buildroot%_mandir -type f -name 'xine-bugreport.1' -print0 -exec ln -sf xine-check.1 \{} \;
%{?_without_X11:rm -rf %buildroot{%_desktopdir,%_pixmapsdir}}

%find_lang --with-man --output=xine.lang %name xine xitk
grep -v 'aaxine' xine.lang > %name.lang
for i in aa caca fb dfb; do
    %find_lang --with-man --output=xine-ui-$i.lang ${i}xine
done
%find_lang --with-man --output=xine-utils.lang xine-bugreport xine-check xine-remote


%files -f %name.lang
%_docdir/%name-%version
%_bindir/xine
%_datadir/xine/*
%if_with X11
%_desktopdir/*
%_pixmapsdir/*
%_iconsdir/hicolor/*/apps/*
%endif


%files -n xine-utils -f xine-utils.lang
%_bindir/xine-*


%if_with aa
%files -n xine-ui-aa -f xine-ui-aa.lang
%_bindir/aaxine
%endif


%if_with caca
%files -n xine-ui-caca -f xine-ui-caca.lang
%_bindir/cacaxine
%endif


%if_with fb
%files -n xine-ui-fb -f xine-ui-fb.lang
%_bindir/fbxine
%endif


%changelog
