Name: xli
Version: 1.17.0
Release: alt8.1

Summary: X11 Image Loading Utility
License: MIT
Group: Graphics

Url: http://pantransit.reptiles.org/prog
# had to repackage
Source: %url/%name-%version.tar.bz2
Patch1: xli_1.17.0-18.diff.bz2
Patch2: xli-1.17.0-mdk-path.patch
Packager: Michael Shigorin <mike@altlinux.org>

Provides: xloadimage
Obsoletes: xloadimage

# Automatically added by buildreq on Mon Dec 01 2008
BuildRequires: gccmakedep imake libX11-devel libXext-devel libjpeg-devel libpng-devel xorg-cf-files

%description
This utility will view several types of images under X11, or load images
onto the X11 root window.
Can view the following image types under X11:
FBM Image, Sun Rasterfile, CMU WM Raster, Portable Bit Map (PBM, PGM,
PPM), Portable Network Graphics (PNG), Faces Project, GIF Image, JFIF
style jpeg Image, Utah RLE Image, Windows, OS/2 RLE Image, Photograph
on CD Image, X Window Dump, Targa Image, McIDAS areafile, G3 FAX Image,
PC Paintbrush Image, GEM Bit Image, MacPaint Image, X Pixmap, X Bitmap.

%prep
%setup -q
%patch1 -p1
%patch2 -p1

%build
xmkmf -a
%make_build CFLAGS="%optflags"
for i in xli xlito; do
	install -pm644 $i.man $i.1
done
install -pm644 xliguide.man xliguide.5
install -pm644 mit.cpyrght COPYRIGHT

%install
mkdir -p %buildroot{%_x11bindir,%_x11mandir/man{1,5},%_sysconfdir/X11/app-defaults}
%make_install install \
	SYSPATHFILE="%buildroot%_sysconfdir/X11/app-defaults/Xli" \
	BINDIR="%buildroot%_x11bindir"

for n in 1 5; do
	for i in *.$n; do
		install -pm644 "$i" "%buildroot%_x11mandir/man$n/$i"
	done
done

ln -snf xli %buildroot%_x11bindir/xsetbg
ln -snf xli %buildroot%_x11bindir/xview

chmod 644 README*

%files
%config(noreplace) %_sysconfdir/X11/app-defaults/*
%_x11bindir/*
%_x11mandir/man?/*
%doc chkgamma.jpg README* ABOUTGAMMA COPYRIGHT

# TODO:
# - look at 2006-11-10 snapshot?

%changelog
