%define libname libxmlrpc

Name: xmlrpc-c
Version: 1.27.0
Release: alt1.svn2145

Summary: XML-RPC C library - an implementation of the xmlrpc protocol
License: BSD-style
Group: System/Libraries

Url: http://xmlrpc-c.sourceforge.net/
Source: %name-%version.tar
Patch0: %name-cmake.patch
Patch1: %name-1.12.00-alt-configure-fixes.patch
Patch2: %name-30x-redirect.patch
Patch3: %name-uninit-curl.patch
Patch4: %name-curl-types.h.patch
Patch5: %name-longlong.patch
Patch6: %name-check-vasprintf-return-value.patch
Patch7: %name-include-string_int.h.patch
Patch8: %name-printf-size_t.patch

BuildRequires: libcurl-devel libxml2-devel gcc-c++ cmake
BuildRequires: libncurses-devel libncursesxx-devel
BuildRequires: libssl-devel zlib-devel

%description
XML-RPC for C/C++ is programming libraries and related tools to help you
write an XML-RPC server or client in C or C++.

%package -n %libname
Summary: XML-RPC C library - an implementation of the xmlrpc protocol
Group: System/Libraries

%description -n %libname
XML-RPC for C/C++ is programming libraries and related tools to help you
write an XML-RPC server or client in C or C++.


%package -n %libname-devel
Summary: Files for developing applications that use %libname
Requires: %libname = %version-%release
Requires: libcurl-devel libexpat-devel libssl-devel w3c-libwww-devel libxml2-devel
Group: Development/C

%description -n %libname-devel
The header file for developing applications that use
%name.


%package -n %libname++
Summary: XML-RPC C++ library - an implementation of the xmlrpc protocol
Group: System/Libraries
Requires: %libname = %version-%release

%description -n %libname++
XML-RPC for C/C++ is programming libraries and related tools to help you
write an XML-RPC server or client in C or C++.

This package contains C++ bindings for %libname.


%package -n %libname++-devel
Summary: Files for developing applications that use %libname++
Requires: %libname++ = %version-%release
Requires: %libname-devel = %version-%release
Group: Development/C++

%description -n %libname++-devel
The header file for developing applications that use
%libname++.


%prep
%setup
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1

%build
mkdir -p build
cd build
export CFLAGS="$RPM_OPT_FLAGS -Wno-uninitialized -Wno-unknown-pragmas"
export CXXFLAGS="$RPM_OPT_FLAGS"
cmake .. \
	-D_lib:STRING=%_libdir \
	-DMUST_BUILD_CURL_CLIENT:BOOL=ON \
	-DMUST_BUILD_LIBWWW_CLIENT:BOOL=OFF \
	-DCMAKE_INSTALL_PREFIX:PATH=%prefix \
	-DBUILD_SHARED_LIBS:BOOL=ON \
	-DENABLE_TOOLS:BOOL=ON
%make_build VERBOSE=1

%install
cd build
%makeinstall_std
rm -f %buildroot%_libdir/*.a
mkdir -p %buildroot%_pkgconfigdir
mv %buildroot%prefix%_pkgconfigdir/*.pc %buildroot%_pkgconfigdir

%files
%doc README doc/*
%doc tools/xmlrpc/xmlrpc.html
%doc tools/xmlrpc_transport/xmlrpc_transport.html
%_man1dir/*
%_bindir/xmlrpc
%_bindir/xmlrpc_transport
%_bindir/xml-rpc-api2cpp
%_bindir/xmlrpc_cpp_proxy
%exclude %_bindir/xml-rpc-api2txt

%files -n %libname
%_libdir/*.so.3*

%files -n %libname-devel
%_bindir/xmlrpc-c-config
%_includedir/xmlrpc-c
%_includedir/*.h
%_pkgconfigdir/*.pc
%_libdir/*.so

%files -n %libname++
%_libdir/*.so.7*


%changelog
