Epoch: 0
BuildRequires: apache-jar-resource-bundle
BuildRequires: /proc
BuildRequires: jpackage-compat
Name:           xmltool
Version:        3.3
Release:        alt2_5jpp7
Summary:        Tool to manage XML documents through a Fluent Interface

Group:          Development/Java
License:        ASL 2.0
URL:            http://code.google.com/p/xmltool
### upstream only provides binaries or source without build scripts
# tar creation instructions
# svn export http://xmltool.googlecode.com/svn/tags/xmltool-3.3 xmltool
# tar cfJ xmltool-3.3.tar.xz xmltool
Source0:        %{name}-%{version}.tar.xz
# remove dependency on maven-license-plugin and dependencies for tests
Patch0:         001-xmltool-fixbuild.patch
BuildArch:      noarch

BuildRequires:  jpackage-utils
BuildRequires:  maven
BuildRequires:  maven-remote-resources-plugin
BuildRequires:  apache-resource-bundles

Requires:       jpackage-utils
Source44: import.info

%description
XMLTool is a very simple Java library to be able to do all sorts of common 
operations with an XML document. Java developers often end up writing the same 
code for processing XML, transforming, etc. This easy to use class puts it all 
together, using the Fluent Interface pattern to facilitate XML manipulations. 

%package javadoc
Summary:        Javadocs for %{name}
Group:          Development/Java
Requires:       %{name} = %{?epoch:%epoch:}%{version}-%{release}
Requires:       jpackage-utils
BuildArch: noarch

%description javadoc
This package contains the API documentation for %{name}.

%prep
%setup -q -n %{name}
%patch0 -p1

# Fix end-of-line encoding
sed -i 's/\r//' LICENSE.txt


%build
# tests require surefire/testng, not currently available
mvn-rpmbuild \
  -Dmaven.test.skip=true \
  install javadoc:javadoc


%install
mkdir -p $RPM_BUILD_ROOT%{_javadir}
install -Dp -m 644 target/%{name}-%{version}.jar \
  $RPM_BUILD_ROOT%{_javadir}/%{name}.jar

mkdir -p $RPM_BUILD_ROOT%{_javadocdir}/%{name}
cp -rp target/site/apidocs/  $RPM_BUILD_ROOT%{_javadocdir}/%{name}

install -d -m 755 $RPM_BUILD_ROOT%{_mavenpomdir}
install -pm 644 pom.xml $RPM_BUILD_ROOT%{_mavenpomdir}/JPP-%{name}.pom

%add_maven_depmap JPP-%{name}.pom %{name}.jar

%files
%doc LICENSE.txt
%{_mavenpomdir}/*
%{_mavendepmapfragdir}/*
%{_javadir}/*


%files javadoc
%{_javadocdir}/%{name}

%changelog
