Name: xmorph
Version: 20060817
Release: alt3
Packager: Fr. Br. George <george@altlinux.ru>

Summary: An X Window System tool for creating morphed images
License: GPL
Group: Graphics
Requires: libmorph = %version-%release
Url: http://sourceforge.net/projects/xmorph/
Source0: xmorph_%version.tar.bz2
Source1: xmorph-icons.tar.bz2
Source2: xmorph.desktop

Patch1: xmorph-dirinfo.patch
Patch2: xmorph-gcc_warnings.patch
Patch3: xmorph-gcc43.patch

%def_disable static

# Automatically added by buildreq on Fri Jan 20 2012
# optimized out: fontconfig fontconfig-devel glib2-devel libICE-devel libSM-devel libX11-devel libXmu-devel libXt-devel libatk-devel libcairo-devel libfreetype-devel libgdk-pixbuf libgdk-pixbuf-devel libgio-devel libpango-devel libstdc++-devel pkg-config xorg-xproto-devel
BuildRequires: chrpath gcc-c++ imake libXaw-devel libXext-devel libfftw3-devel libgtk+2-devel xorg-bitmaps xorg-cf-files

%package -n libmorph
Summary: Internal library required for xmorph/gtkmorph
Group: Graphics

%package -n libmorph-devel
Summary: Headers  required for xmorph/gtkmorph development
Requires: libmorph = %version-%release
Group: Graphics

%package -n libmorph-devel-static
Summary: Static libraries required for xmorph/gtkmorph development
Requires: libmorph-devel = %version-%release
Group: Graphics

%description
Xmorph is a digital image warping (aka morphing) program.  Xmorph
provides the tools needed and comprehensible instructions for you to
create morphs: changing one image into another.  Xmorph runs under the
X Window System.

%description -n libmorph
Internal library for xmorph and gtkmorph.

%description -n libmorph-devel
Development headers  for xmorph and gtkmorph.

%description -n libmorph-devel-static
Development static libs for xmorph and gtkmorph.

%prep
%setup -q -n %name-%version
%patch1
%patch2
%patch3 -p1
tar xvf %SOURCE1

%build
%configure %{subst_enable static} --disable-rpath
%make_build
chrpath -d */.libs/*morph

%install
%makeinstall

#mdk menu
mkdir -p %buildroot%_desktopdir %buildroot%_niconsdir %buildroot%_miconsdir %buildroot%_liconsdir
install mini/%name.xpm %buildroot%_miconsdir
install %name.xpm %buildroot%_niconsdir/
install large/%name.xpm %buildroot%_liconsdir
install %SOURCE2 %buildroot%_desktopdir
install morph/morph %buildroot%_bindir/morph
%find_lang  %name

%files -f %name.lang
%doc AUTHORS README HISTORY NEWS
%_datadir/%name
%_bindir/*
%_mandir/*/*
%_infodir/*
%_miconsdir/*.xpm
%_liconsdir/*.xpm
%_niconsdir/*.xpm
%_desktopdir/*

%files -n libmorph
%_libdir/*.so.*

%files -n libmorph-devel
%_libdir/*.so
%_includedir/*

%if_enabled static
%files -n libmorph-devel-static
%_libdir/*.a
%endif #static

%changelog
